/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.core.amd64.AMD64NodeLIRBuilder;
import jdk.graal.compiler.core.amd64.AMD64NodeMatchRules;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.gen.DebugInfoBuilder;
import jdk.graal.compiler.hotspot.HotSpotBackend;
import jdk.graal.compiler.hotspot.HotSpotDebugInfoBuilder;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.HotSpotLIRGenerationResult;
import jdk.graal.compiler.hotspot.HotSpotLIRGenerator;
import jdk.graal.compiler.hotspot.HotSpotLockStack;
import jdk.graal.compiler.hotspot.HotSpotNodeLIRBuilder;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotDirectStaticCallOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotIndirectCallOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotJumpToExceptionHandlerInCallerOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotLIRGenerator;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotPatchReturnAddressOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotSafepointOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotspotDirectVirtualCallOp;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import jdk.graal.compiler.hotspot.nodes.HotSpotDirectCallTargetNode;
import jdk.graal.compiler.hotspot.nodes.HotSpotIndirectCallTargetNode;
import jdk.graal.compiler.hotspot.stubs.Stub;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.amd64.AMD64BreakpointOp;
import jdk.graal.compiler.lir.amd64.AMD64SaveRegistersOp;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodes.BreakpointNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.DirectCallTargetNode;
import jdk.graal.compiler.nodes.FullInfopointNode;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.SafepointNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.NodeValueMap;
import jdk.graal.compiler.replacements.amd64.AMD64IntrinsicStubs;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public class AMD64HotSpotNodeLIRBuilder
extends AMD64NodeLIRBuilder
implements HotSpotNodeLIRBuilder {
    public AMD64HotSpotNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool gen, AMD64NodeMatchRules nodeMatchRules) {
        super(graph, gen, nodeMatchRules);
        assert (gen instanceof AMD64HotSpotLIRGenerator) : gen;
        assert (this.getDebugInfoBuilder() instanceof HotSpotDebugInfoBuilder) : this.getDebugInfoBuilder();
        ((AMD64HotSpotLIRGenerator)gen).setDebugInfoBuilder((HotSpotDebugInfoBuilder)this.getDebugInfoBuilder());
    }

    private AMD64HotSpotLIRGenerator getGen() {
        return (AMD64HotSpotLIRGenerator)this.gen;
    }

    @Override
    protected DebugInfoBuilder createDebugInfoBuilder(StructuredGraph graph, NodeValueMap nodeValueMap) {
        HotSpotLockStack lockStack = new HotSpotLockStack(this.gen.getResult().getFrameMapBuilder(), LIRKind.value((PlatformKind)AMD64Kind.QWORD));
        return new HotSpotDebugInfoBuilder(nodeValueMap, lockStack, (HotSpotLIRGenerator)((Object)this.gen));
    }

    @Override
    protected void emitPrologue(StructuredGraph graph) {
        CallingConvention incomingArguments = this.gen.getResult().getCallingConvention();
        HotSpotLIRGenerationResult result = this.getGen().getResult();
        Stub stub = result.getStub();
        if (stub != null && stub.getLinkage().getEffect() == HotSpotForeignCallLinkage.RegisterEffect.KILLS_NO_REGISTERS) {
            assert (stub.getLinkage().getDescriptor().getTransition() != HotSpotForeignCallDescriptor.Transition.SAFEPOINT) : stub;
            AMD64SaveRegistersOp saveOp = this.getGen().emitSaveAllRegisters(false);
            result.setSaveOnEntry(saveOp);
        }
        Value[] params = new Value[incomingArguments.getArgumentCount() + 1];
        this.prologAssignParams(incomingArguments, params);
        params[params.length - 1] = AMD64.rbp.asValue((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.QWORD));
        this.gen.emitIncomingValues(params);
        this.getGen().emitSaveRbp();
        this.getGen().append(((HotSpotDebugInfoBuilder)this.getDebugInfoBuilder()).lockStack());
        this.prologSetParameterNodes(graph, params);
    }

    @Override
    public void visitSafepointNode(SafepointNode i) {
        LIRFrameState info = this.state(i);
        Register thread = this.getGen().getProviders().getRegisters().getThreadRegister();
        this.append(new AMD64HotSpotSafepointOp(info, this.getGen().config, this, thread));
    }

    @Override
    protected void emitDirectCall(DirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
        CallTargetNode.InvokeKind invokeKind = ((HotSpotDirectCallTargetNode)callTarget).invokeKind();
        if (invokeKind.isIndirect()) {
            this.append(new AMD64HotspotDirectVirtualCallOp(callTarget.targetMethod(), result, parameters, temps, callState, invokeKind, this.getGen().config));
        } else {
            assert (invokeKind.isDirect());
            HotSpotResolvedJavaMethod resolvedMethod = (HotSpotResolvedJavaMethod)callTarget.targetMethod();
            assert (resolvedMethod.isConcrete()) : "Cannot make direct call to abstract method.";
            this.append(new AMD64HotSpotDirectStaticCallOp(callTarget.targetMethod(), result, parameters, temps, callState, invokeKind, this.getGen().config));
        }
    }

    @Override
    protected void emitIndirectCall(IndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
        if (callTarget instanceof HotSpotIndirectCallTargetNode) {
            Value metaspaceMethodSrc = this.operand(((HotSpotIndirectCallTargetNode)callTarget).metaspaceMethod());
            Value targetAddressSrc = this.operand(callTarget.computedAddress());
            RegisterValue metaspaceMethodDst = AMD64.rbx.asValue(metaspaceMethodSrc.getValueKind());
            RegisterValue targetAddressDst = AMD64.rax.asValue(targetAddressSrc.getValueKind());
            this.gen.emitMove((AllocatableValue)metaspaceMethodDst, metaspaceMethodSrc);
            this.gen.emitMove((AllocatableValue)targetAddressDst, targetAddressSrc);
            this.append(new AMD64HotSpotIndirectCallOp(callTarget.targetMethod(), result, parameters, temps, (Value)metaspaceMethodDst, (Value)targetAddressDst, callState));
        } else {
            super.emitIndirectCall(callTarget, result, parameters, temps, callState);
        }
    }

    @Override
    public void emitPatchReturnAddress(ValueNode address) {
        this.append(new AMD64HotSpotPatchReturnAddressOp(this.gen.asAllocatable(this.operand(address))));
    }

    @Override
    public void emitJumpToExceptionHandlerInCaller(ValueNode handlerInCallerPc, ValueNode exception, ValueNode exceptionPc) {
        AllocatableValue handler = this.gen.asAllocatable(this.operand(handlerInCallerPc));
        ForeignCallLinkage linkage = this.gen.getForeignCalls().lookupForeignCall(HotSpotBackend.EXCEPTION_HANDLER_IN_CALLER);
        CallingConvention outgoingCc = linkage.getOutgoingCallingConvention();
        assert (outgoingCc.getArgumentCount() == 2) : outgoingCc;
        RegisterValue exceptionFixed = (RegisterValue)outgoingCc.getArgument(0);
        RegisterValue exceptionPcFixed = (RegisterValue)outgoingCc.getArgument(1);
        this.gen.emitMove((AllocatableValue)exceptionFixed, this.operand(exception));
        this.gen.emitMove((AllocatableValue)exceptionPcFixed, this.operand(exceptionPc));
        AMD64HotSpotJumpToExceptionHandlerInCallerOp op = new AMD64HotSpotJumpToExceptionHandlerInCallerOp(handler, (AllocatableValue)exceptionFixed, (AllocatableValue)exceptionPcFixed);
        this.append(op);
    }

    @Override
    public void visitFullInfopointNode(FullInfopointNode i) {
        if (i.getState() != null && i.getState().bci == -3) {
            i.getDebug().log("Ignoring InfopointNode for AFTER_BCI");
        } else {
            super.visitFullInfopointNode(i);
        }
    }

    @Override
    public void visitBreakpointNode(BreakpointNode node) {
        JavaType[] sig = new JavaType[node.arguments().size()];
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = ((ValueNode)node.arguments().get(i)).stamp(NodeView.DEFAULT).javaType(this.gen.getMetaAccess());
        }
        Value[] parameters = this.visitInvokeArguments(this.gen.getRegisterConfig().getCallingConvention((CallingConvention.Type)HotSpotCallingConventionType.JavaCall, null, sig, (ValueKindFactory)this.gen), node.arguments());
        this.append(new AMD64BreakpointOp(parameters));
    }

    @Override
    public ForeignCallLinkage lookupGraalStub(ValueNode valueNode, ForeignCallDescriptor foreignCallDescriptor) {
        if (this.getGen().getResult().getStub() != null) {
            return null;
        }
        if (AMD64IntrinsicStubs.shouldInlineIntrinsic(valueNode, this.gen)) {
            return null;
        }
        return this.getGen().getForeignCalls().lookupForeignCall(foreignCallDescriptor);
    }
}

