/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotMove;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.amd64.AMD64Move;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.site.Call;

public class AMD64HotSpotMacroAssembler
extends AMD64MacroAssembler {
    private final GraalHotSpotVMConfig config;
    private final HotSpotProviders providers;

    public AMD64HotSpotMacroAssembler(GraalHotSpotVMConfig config, TargetDescription target, OptionValues optionValues, HotSpotProviders providers, boolean hasIntelJccErratum) {
        super(target, optionValues, hasIntelJccErratum);
        this.config = config;
        this.providers = providers;
    }

    @Override
    public void postCallNop(Call call) {
        if (this.config.continuationsEnabled && call.debugInfo != null) {
            this.emitByte(15);
            this.emitByte(31);
            this.emitByte(132);
            this.emitByte(0);
            this.emitInt(0);
            return;
        }
        super.postCallNop(call);
    }

    public void nmethodEntryCompare(int displacement) {
        this.emitByte(65);
        this.emitByte(129);
        this.emitByte(127);
        GraalError.guarantee(NumUtil.isByte(displacement), "expected byte sized displacement");
        this.emitByte(displacement & 0xFF);
        GraalError.guarantee(this.position() % 4 == 0, "must be aligned");
        this.emitInt(0);
    }

    public void loadObject(Register dst, AMD64Address address) {
        if (this.config.useCompressedOops) {
            this.movl(dst, address);
            CompressEncoding encoding = this.config.getOopEncoding();
            Register baseReg = encoding.hasBase() ? this.providers.getRegisters().getHeapBaseRegister() : Register.None;
            AMD64Move.UncompressPointerOp.emitUncompressCode(this, dst, encoding.getShift(), baseReg, false);
        } else {
            this.movq(dst, address);
        }
    }

    public void verifyOop(Register value, Register tmp, Register tmp2, boolean compressed, boolean nonNull) {
        Label ok = new Label();
        if (!nonNull) {
            this.testAndJcc(compressed ? AMD64BaseAssembler.OperandSize.DWORD : AMD64BaseAssembler.OperandSize.QWORD, value, value, AMD64Assembler.ConditionFlag.Zero, ok, true);
        }
        Register object = value;
        if (compressed) {
            CompressEncoding encoding = this.config.getOopEncoding();
            Register heapBaseRegister = AMD64Move.UncompressPointerOp.hasBase(encoding) ? this.providers.getRegisters().getHeapBaseRegister() : Register.None;
            this.movq(tmp, value);
            AMD64Move.UncompressPointerOp.emitUncompressCode(this, tmp, encoding.getShift(), heapBaseRegister, true);
            object = tmp;
        }
        if (this.config.useCompressedClassPointers) {
            if (this.config.useCompactObjectHeaders) {
                this.loadCompactClassPointer(tmp, object);
            } else {
                this.movl(tmp, new AMD64Address(object, this.config.hubOffset));
            }
            AMD64HotSpotMove.decodeKlassPointer(this, tmp, tmp2, this.config);
        } else {
            this.movq(tmp, new AMD64Address(object, this.config.hubOffset));
        }
        this.movl(tmp2, new AMD64Address(tmp, this.config.superCheckOffsetOffset));
        this.cmplAndJcc(tmp2, this.config.secondarySuperCacheOffset, AMD64Assembler.ConditionFlag.Equal, ok, true);
        this.movq(tmp2, new AMD64Address(tmp, tmp2, Stride.S1));
        this.cmpqAndJcc(tmp2, tmp, AMD64Assembler.ConditionFlag.Equal, ok, true);
        this.illegal();
        this.bind(ok);
    }

    @Override
    @SyncPort(from="https://github.com/openjdk/jdk/blob/08d51003d142e89b9d2f66187a4ea50e12b94fbb/src/hotspot/cpu/x86/assembler_x86.cpp#L234-L268", sha1="7e213e437f5d3e7740874d69457de4ffebbee1c5")
    protected final int membarOffset() {
        int offset = -this.config.l1LineSize;
        if (offset < -128) {
            offset = -128;
        }
        return offset;
    }

    @Override
    public Register getZeroValueRegister() {
        return this.providers.getRegisters().getZeroValueRegister(this.config);
    }

    public void loadCompactClassPointer(Register result, Register receiver) {
        GraalError.guarantee(this.config.useCompactObjectHeaders, "Load class pointer from markWord only when UseCompactObjectHeaders is on");
        this.movq(result, new AMD64Address(receiver, this.config.markOffset));
        this.shrq(result, this.config.markWordKlassShift);
    }
}

