/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotBackend;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkageImpl;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.amd64.AMD64MathStub;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.stubs.IntrinsicStubsGen;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.replacements.nodes.ArrayEqualsForeignCalls;
import jdk.graal.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public class AMD64HotSpotForeignCallsProvider
extends HotSpotHostForeignCallsProvider {
    private final Value[] nativeABICallerSaveRegisters;

    public AMD64HotSpotForeignCallsProvider(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalRuntimeProvider runtime, MetaAccessProvider metaAccess, CodeCacheProvider codeCache, WordTypes wordTypes, Value[] nativeABICallerSaveRegisters) {
        super(jvmciRuntime, runtime, metaAccess, codeCache, wordTypes);
        this.nativeABICallerSaveRegisters = nativeABICallerSaveRegisters;
    }

    @Override
    public void initialize(HotSpotProviders providers, OptionValues options) {
        TargetDescription target = providers.getCodeCache().getTarget();
        PlatformKind word = target.arch.getWordKind();
        RegisterValue exception = AMD64.rax.asValue((ValueKind)LIRKind.reference(word));
        RegisterValue exceptionPc = AMD64.rdx.asValue((ValueKind)LIRKind.value(word));
        CallingConvention exceptionCc = new CallingConvention(0, Value.ILLEGAL, new AllocatableValue[]{exception, exceptionPc});
        this.register(new HotSpotForeignCallLinkageImpl(HotSpotBackend.EXCEPTION_HANDLER, 0L, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, exceptionCc, null));
        this.register(new HotSpotForeignCallLinkageImpl(HotSpotBackend.EXCEPTION_HANDLER_IN_CALLER, -2401018188504514833L, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, exceptionCc, null));
        this.linkSnippetStubs(providers, options, IntrinsicStubsGen::new, ArrayEqualsForeignCalls.STUBS_AMD64);
        super.initialize(providers, options);
    }

    @Override
    public Value[] getNativeABICallerSaveRegisters() {
        return this.nativeABICallerSaveRegisters;
    }

    @Override
    protected void registerMathStubs(GraalHotSpotVMConfig hotSpotVMConfig, HotSpotProviders providers, OptionValues options) {
        if (HotSpotBackend.Options.GraalArithmeticStubs.getValue(options).booleanValue()) {
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.SIN, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.SIN.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.COS, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.COS.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.TAN, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.TAN.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.TANH, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.TANH.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.EXP, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.EXP.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.LOG, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.LOG.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.LOG10, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.LOG10.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(BinaryMathIntrinsicNode.BinaryOperation.POW, options, providers, this.registerStubCall(BinaryMathIntrinsicNode.BinaryOperation.POW.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        } else {
            super.registerMathStubs(hotSpotVMConfig, providers, options);
        }
    }
}

