/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotCounterOp;
import jdk.graal.compiler.hotspot.debug.BenchmarkCounters;
import jdk.graal.compiler.hotspot.meta.HotSpotRegistersProvider;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="BenchMarkCounter")
public class AMD64HotSpotCounterOp
extends HotSpotCounterOp {
    public static final LIRInstructionClass<AMD64HotSpotCounterOp> TYPE = LIRInstructionClass.create(AMD64HotSpotCounterOp.class);
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.UNINITIALIZED})
    private AllocatableValue backupSlot;

    public AMD64HotSpotCounterOp(String name, String group, Value increment, HotSpotRegistersProvider registers, GraalHotSpotVMConfig config, AllocatableValue backupSlot) {
        super(TYPE, name, group, increment, registers, config);
        this.backupSlot = backupSlot;
    }

    public AMD64HotSpotCounterOp(String[] names, String[] groups, Value[] increments, HotSpotRegistersProvider registers, GraalHotSpotVMConfig config, AllocatableValue backupSlot) {
        super(TYPE, names, groups, increments, registers, config);
        this.backupSlot = backupSlot;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb) {
        Register scratch;
        AMD64MacroAssembler masm = (AMD64MacroAssembler)crb.asm;
        TargetDescription target = crb.target;
        if (!AMD64HotSpotCounterOp.contains(this.increments, AMD64.rax)) {
            scratch = AMD64.rax;
        } else if (!AMD64HotSpotCounterOp.contains(this.increments, AMD64.rbx)) {
            scratch = AMD64.rbx;
        } else {
            throw GraalError.unimplemented("RAX and RBX are increment registers at the same time, spilling over the scratch register is not supported right now");
        }
        AMD64Address countersArrayAddr = new AMD64Address(this.thread, this.config.jvmciCountersThreadOffset);
        Register countersArrayReg = scratch;
        masm.movq((AMD64Address)crb.asAddress((Value)this.backupSlot), scratch);
        masm.movptr(countersArrayReg, countersArrayAddr);
        HotSpotCounterOp.CounterProcedure emitProcedure = (counterIndex, increment, displacement) -> AMD64HotSpotCounterOp.emitIncrement(crb, masm, countersArrayReg, increment, displacement);
        this.forEachCounter(emitProcedure, target);
        masm.movq(scratch, (AMD64Address)crb.asAddress((Value)this.backupSlot));
    }

    private static boolean contains(Value[] increments, Register register) {
        for (Value increment : increments) {
            if (!ValueUtil.isRegister((Value)increment) || !ValueUtil.asRegister((Value)increment).equals((Object)register)) continue;
            return true;
        }
        return false;
    }

    private static void emitIncrement(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register countersArrayReg, Value incrementValue, int displacement) {
        AMD64Address counterAddr = new AMD64Address(countersArrayReg, displacement);
        if (LIRValueUtil.isJavaConstant(incrementValue)) {
            int increment = AMD64HotSpotCounterOp.asInt(LIRValueUtil.asJavaConstant(incrementValue));
            masm.incrementq(counterAddr, increment);
        } else {
            masm.addq(counterAddr, ValueUtil.asRegister((Value)incrementValue));
        }
        if (BenchmarkCounters.Options.AbortOnBenchmarkCounterOverflow.getValue(crb.getOptions()).booleanValue()) {
            Label target = new Label();
            masm.jccb(AMD64Assembler.ConditionFlag.NoOverflow, target);
            crb.blockComment("[BENCHMARK COUNTER OVERFLOW]");
            masm.illegal();
            masm.bind(target);
        }
    }
}

