/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64.z;

import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.aarch64.z.AArch64HotSpotZBarrieredOp;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.aarch64.AArch64AddressValue;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

public class AArch64HotSpotZReadBarrierOp
extends AArch64HotSpotZBarrieredOp {
    public static final LIRInstructionClass<AArch64HotSpotZReadBarrierOp> TYPE = LIRInstructionClass.create(AArch64HotSpotZReadBarrierOp.class);
    private final MemoryOrderMode memoryOrder;
    @LIRInstruction.State
    protected LIRFrameState state;
    private final boolean isNotStrong;

    public AArch64HotSpotZReadBarrierOp(Variable result, AArch64AddressValue loadAddress, MemoryOrderMode memoryOrder, LIRFrameState state, GraalHotSpotVMConfig config, ForeignCallLinkage callTarget, boolean isNotStrong) {
        super(TYPE, result, loadAddress, config, callTarget);
        this.memoryOrder = memoryOrder;
        this.state = state;
        this.isNotStrong = isNotStrong;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        int loadPosition;
        Register resultReg = ValueUtil.asRegister((Value)this.result);
        switch (this.memoryOrder) {
            case PLAIN: 
            case OPAQUE: {
                loadPosition = masm.position();
                masm.ldr(64, resultReg, this.loadAddress.toAddress(), false);
                break;
            }
            case ACQUIRE: 
            case VOLATILE: {
                try (AArch64MacroAssembler.ScratchRegister scratch1 = masm.getScratchRegister();){
                    Register addrReg;
                    AArch64Address address = this.loadAddress.toAddress();
                    if (address.isBaseRegisterOnly()) {
                        addrReg = address.getBase();
                    } else {
                        addrReg = scratch1.getRegister();
                        masm.loadAddress(addrReg, address);
                    }
                    loadPosition = masm.position();
                    masm.ldar(64, resultReg, addrReg);
                    break;
                }
            }
            default: {
                throw GraalError.shouldNotReachHere("Unexpected memory order");
            }
        }
        if (this.state != null) {
            crb.recordImplicitException(loadPosition, this.state);
        }
        this.emitBarrier(crb, masm, this.isNotStrong);
    }
}

