/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64.z;

import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.aarch64.AArch64LIRGenerator;
import jdk.graal.compiler.core.aarch64.AArch64ReadBarrierSetLIRGenerator;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotMarkId;
import jdk.graal.compiler.hotspot.ZWriteBarrierSetLIRGeneratorTool;
import jdk.graal.compiler.hotspot.aarch64.z.AArch64HotSpotZAtomicReadAndWriteOp;
import jdk.graal.compiler.hotspot.aarch64.z.AArch64HotSpotZCompareAndSwapOp;
import jdk.graal.compiler.hotspot.aarch64.z.AArch64HotSpotZPreWriteBarrierOp;
import jdk.graal.compiler.hotspot.aarch64.z.AArch64HotSpotZReadBarrierOp;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.SyncPorts;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.aarch64.AArch64AddressValue;
import jdk.graal.compiler.lir.aarch64.AArch64Call;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.hotspot.aarch64.AArch64HotSpotRegisterConfig;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.word.LocationIdentity;

public class AArch64HotSpotZBarrierSetLIRGenerator
implements AArch64ReadBarrierSetLIRGenerator,
ZWriteBarrierSetLIRGeneratorTool {
    private final GraalHotSpotVMConfig config;
    private final HotSpotProviders providers;

    public AArch64HotSpotZBarrierSetLIRGenerator(GraalHotSpotVMConfig config, HotSpotProviders providers) {
        this.config = config;
        this.providers = providers;
    }

    @Override
    public ForeignCallsProvider getForeignCalls() {
        return this.providers.getForeignCalls();
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/4acafb809c66589fbbfee9c9a4ba7820f848f0e4/src/hotspot/cpu/aarch64/gc/z/z_aarch64.ad#L36-L41", sha1="ee0780117d2ff7f782c4f3e2ae79b55a3c8dd523")
    static void zColor(CompilationResultBuilder crb, AArch64MacroAssembler masm, GraalHotSpotVMConfig config, Register dst, Register src) {
        Assembler.guaranteeDifferentRegisters(src, dst);
        crb.recordMark(HotSpotMarkId.Z_BARRIER_RELOCATION_FORMAT_STORE_GOOD_BEFORE_MOV);
        masm.movzPatchable(32, dst, 0);
        masm.orr(64, dst, dst, src, AArch64Assembler.ShiftType.LSL, config.zPointerLoadShift);
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/4acafb809c66589fbbfee9c9a4ba7820f848f0e4/src/hotspot/cpu/aarch64/gc/z/z_aarch64.ad#L43-L45", sha1="3c53528425bc5609e9c5fc3588bbed0c01cd63a6")
    static void zUncolor(AArch64MacroAssembler masm, GraalHotSpotVMConfig config, Register ref) {
        masm.lsr(64, ref, ref, config.zPointerLoadShift);
    }

    @SyncPorts(value={@SyncPort(from="https://github.com/openjdk/jdk/blob/4acafb809c66589fbbfee9c9a4ba7820f848f0e4/src/hotspot/cpu/aarch64/gc/z/zBarrierSetAssembler_aarch64.cpp#L167-L225", sha1="101b4c83516738a04bf6fb3f17bfc78f58ac5784"), @SyncPort(from="https://github.com/openjdk/jdk/blob/4acafb809c66589fbbfee9c9a4ba7820f848f0e4/src/hotspot/cpu/aarch64/gc/z/zBarrierSetAssembler_aarch64.cpp#L310-L371", sha1="755eb5d52e1ad8c30c9aa9c5f009d35f8c52bb78")})
    static void emitStoreBarrier(CompilationResultBuilder crb, AArch64MacroAssembler masm, LIRInstruction op, GraalHotSpotVMConfig config, AArch64Address address, Register result, ZWriteBarrierSetLIRGeneratorTool.StoreKind storeKind, ForeignCallLinkage callTarget, LIRFrameState state) {
        try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister sc2 = masm.getScratchRegister();){
            Register rscratch1 = sc1.getRegister();
            Register rscratch2 = sc2.getRegister();
            Assembler.guaranteeDifferentRegisters(address.getBase(), result, rscratch1);
            Assembler.guaranteeDifferentRegisters(address.getOffset(), result, rscratch1);
            Assembler.guaranteeDifferentRegisters(result, rscratch1);
            if (storeKind == ZWriteBarrierSetLIRGeneratorTool.StoreKind.Atomic) {
                if (state != null) {
                    crb.recordImplicitException(masm.position(), state);
                }
                masm.ldr(16, rscratch1, address);
                crb.recordMark(HotSpotMarkId.Z_BARRIER_RELOCATION_FORMAT_STORE_GOOD_BEFORE_MOV);
                masm.movzPatchable(32, rscratch2, 0);
                masm.cmp(32, rscratch1, rscratch2);
            } else {
                if (state != null) {
                    crb.recordImplicitException(masm.position(), state);
                }
                masm.ldr(64, rscratch1, address);
                crb.recordMark(HotSpotMarkId.Z_BARRIER_RELOCATION_FORMAT_STORE_BAD_BEFORE_MOV);
                masm.movzPatchable(32, rscratch2, 0);
                masm.tst(64, rscratch1, rscratch2);
            }
            Label entry = new Label();
            Label continuation = new Label();
            if (crb.usesConservativeLabelRanges()) {
                Label good = new Label();
                masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, good);
                masm.jmp(entry);
                masm.bind(good);
            } else {
                masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, entry);
            }
            masm.bind(continuation);
            crb.getLIR().addSlowPath(op, () -> {
                masm.bind(entry);
                Label slow = new Label();
                Label slowContinuation = new Label();
                AArch64HotSpotZBarrierSetLIRGenerator.storeBarrierMedium(crb, masm, config, address, rscratch2, result, rscratch1, storeKind, continuation, slow, slowContinuation);
                masm.bind(slow);
                CallingConvention cc = callTarget.getOutgoingCallingConvention();
                assert (cc.getArgumentCount() == 1) : "only one argument expected: " + String.valueOf(cc);
                AArch64Address cArg0 = (AArch64Address)crb.asAddress((Value)cc.getArgument(0));
                masm.loadAddress(rscratch1, address);
                masm.str(64, rscratch1, cArg0);
                AArch64Call.directCall(crb, masm, callTarget, AArch64Call.isNearCall(callTarget) ? null : rscratch1, null);
                assert (cc.getReturn().equals((Object)Value.ILLEGAL)) : String.valueOf(cc) + " " + String.valueOf(callTarget);
                masm.jmp(slowContinuation);
            });
        }
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/4acafb809c66589fbbfee9c9a4ba7820f848f0e4/src/hotspot/cpu/aarch64/gc/z/zBarrierSetAssembler_aarch64.cpp#L259-L308", sha1="061eaf13b97f69aee4f687ce51e500ac3b37071a")
    static void storeBarrierMedium(CompilationResultBuilder crb, AArch64MacroAssembler masm, GraalHotSpotVMConfig config, AArch64Address address, Register rtmp1, Register rtmp2, Register rtmp3, ZWriteBarrierSetLIRGeneratorTool.StoreKind storeKind, Label mediumPathContinuation, Label slowPath, Label slowPathContinuation) {
        Assembler.guaranteeDifferentRegisters(address.getBase(), address.getOffset(), rtmp1, rtmp2, rtmp3);
        if (storeKind == ZWriteBarrierSetLIRGeneratorTool.StoreKind.Native) {
            masm.jmp(slowPath);
            masm.bind(slowPathContinuation);
            masm.jmp(mediumPathContinuation);
        } else if (storeKind == ZWriteBarrierSetLIRGeneratorTool.StoreKind.Atomic) {
            masm.loadAddress(rtmp2, address);
            masm.ldr(64, rtmp1, AArch64Address.createBaseRegisterOnlyAddress(64, rtmp2));
            masm.cbnz(64, rtmp1, slowPath);
            crb.recordMark(HotSpotMarkId.Z_BARRIER_RELOCATION_FORMAT_STORE_GOOD_BEFORE_MOV);
            masm.movzPatchable(32, rtmp1, 0);
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                Register rscratch1 = sc.getRegister();
                Label done = new Label();
                masm.prfm(AArch64Address.createBaseRegisterOnlyAddress(64, rtmp2), AArch64Assembler.PrefetchMode.PSTL1STRM);
                masm.loadExclusive(64, rtmp3, rtmp2, false);
                masm.cmp(64, rtmp3, AArch64.zr);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, done);
                masm.storeExclusive(64, rscratch1, rtmp1, rtmp2, false);
                masm.compare(64, rscratch1, 0);
                masm.bind(done);
            }
            masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, slowPath);
            masm.bind(slowPathContinuation);
            masm.jmp(mediumPathContinuation);
        } else {
            if (GraalOptions.AssemblyGCBarriersSlowPathOnly.getValue(crb.getOptions()).booleanValue()) {
                masm.jmp(slowPath);
            } else {
                AArch64HotSpotZBarrierSetLIRGenerator.storeBarrierBufferAdd(masm, config, address, rtmp1, rtmp2, slowPath);
            }
            masm.bind(slowPathContinuation);
            masm.jmp(mediumPathContinuation);
        }
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/4acafb809c66589fbbfee9c9a4ba7820f848f0e4/src/hotspot/cpu/aarch64/gc/z/zBarrierSetAssembler_aarch64.cpp#L227-L257", sha1="b52bb540cf136f455dfac53fece3cc029a240bf2")
    static void storeBarrierBufferAdd(AArch64MacroAssembler masm, GraalHotSpotVMConfig config, AArch64Address refAddr, Register tmp1, Register tmp2, Label slowPath) {
        Register rthread = AArch64HotSpotRegisterConfig.threadRegister;
        int offset4 = config.ZThreadLocalData_store_barrier_buffer_offset;
        AArch64Address buffer = masm.makeAddress(64, rthread, offset4);
        Assembler.guaranteeDifferentRegisters(refAddr.getBase(), refAddr.getOffset(), tmp1, tmp2);
        masm.ldr(64, tmp1, buffer);
        int offset3 = config.ZStoreBarrierBuffer_current_offset;
        masm.ldr(64, tmp2, masm.makeAddress(64, tmp1, offset3));
        masm.compare(64, tmp2, 0);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, slowPath);
        masm.sub(64, tmp2, tmp2, config.sizeofZStoreBarrierEntry);
        int offset2 = config.ZStoreBarrierBuffer_current_offset;
        masm.str(64, tmp2, masm.makeAddress(64, tmp1, offset2));
        masm.add(64, tmp2, tmp2, config.ZStoreBarrierBuffer_buffer_offset);
        masm.add(64, tmp2, tmp2, tmp1);
        masm.loadAddress(tmp1, refAddr);
        int offset1 = config.ZStoreBarrierEntry_p_offset;
        masm.str(64, tmp1, masm.makeAddress(64, tmp2, offset1));
        masm.ldr(64, tmp1, AArch64Address.createBaseRegisterOnlyAddress(64, tmp1));
        int offset = config.ZStoreBarrierEntry_prev_offset;
        masm.str(64, tmp1, masm.makeAddress(64, tmp2, offset));
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/4acafb809c66589fbbfee9c9a4ba7820f848f0e4/src/hotspot/cpu/aarch64/gc/z/zBarrierSetAssembler_aarch64.cpp#L105-L165", sha1="2b500d0e7769c719aca0eb4d1707ac0cbf476727")
    public static void emitLoadBarrier(CompilationResultBuilder crb, AArch64MacroAssembler masm, GraalHotSpotVMConfig config, Register ref, ForeignCallLinkage callTarget, AArch64Address address, LIRInstruction op, boolean elided, boolean isNotStrong) {
        if (elided) {
            AArch64HotSpotZBarrierSetLIRGenerator.zUncolor(masm, config, ref);
            return;
        }
        try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();){
            Register scratch1 = sc1.getRegister();
            Label entry = new Label();
            Label continuation = new Label();
            if (isNotStrong) {
                crb.recordMark(HotSpotMarkId.Z_BARRIER_RELOCATION_FORMAT_MARK_BAD_BEFORE_MOV);
                masm.movzPatchable(32, scratch1, 0);
                masm.tst(64, ref, scratch1);
                if (crb.usesConservativeLabelRanges()) {
                    Label good = new Label();
                    masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, good);
                    masm.jmp(entry);
                    masm.bind(good);
                } else {
                    masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, entry);
                }
            } else if (crb.usesConservativeLabelRanges()) {
                Label good = new Label();
                crb.recordMark(HotSpotMarkId.Z_BARRIER_RELOCATION_FORMAT_LOAD_GOOD_BEFORE_TB_X);
                masm.tbz(ref, 0, good);
                masm.jmp(entry);
                masm.bind(good);
            } else {
                crb.recordMark(HotSpotMarkId.Z_BARRIER_RELOCATION_FORMAT_LOAD_GOOD_BEFORE_TB_X);
                masm.tbnz(ref, 0, entry);
            }
            AArch64HotSpotZBarrierSetLIRGenerator.zUncolor(masm, config, ref);
            masm.bind(continuation);
            crb.getLIR().addSlowPath(op, () -> {
                Register addressReg;
                masm.bind(entry);
                CallingConvention cc = callTarget.getOutgoingCallingConvention();
                AArch64Address cArg0 = (AArch64Address)crb.asAddress((Value)cc.getArgument(0));
                AArch64Address cArg1 = (AArch64Address)crb.asAddress((Value)cc.getArgument(1));
                masm.str(64, ref, cArg0);
                if (address.isBaseRegisterOnly()) {
                    addressReg = address.getBase();
                } else {
                    addressReg = ref;
                    masm.loadAddress(ref, address);
                }
                masm.str(64, addressReg, cArg1);
                AArch64Call.directCall(crb, masm, callTarget, AArch64Call.isNearCall(callTarget) ? null : scratch1, null);
                masm.ldr(64, ref, cArg0);
                masm.jmp(continuation);
            });
        }
    }

    @Override
    public Variable emitBarrieredLoad(LIRGeneratorTool tool, LIRKind kind, Value address, LIRFrameState state, MemoryOrderMode memoryOrder, BarrierType barrierType) {
        if (kind.getPlatformKind().getVectorLength() == 1) {
            GraalError.guarantee(kind.getPlatformKind() == AArch64Kind.QWORD, "ZGC only uses uncompressed oops: %s", (Object)kind);
            ForeignCallLinkage callTarget = this.getReadBarrierStub(barrierType);
            AArch64AddressValue loadAddress = ((AArch64LIRGenerator)tool).asAddressValue(address, 64);
            Variable result = tool.newVariable(tool.toRegisterKind(kind));
            tool.getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
            boolean isNotStrong = barrierType == BarrierType.REFERENCE_GET || barrierType == BarrierType.WEAK_REFERS_TO || barrierType == BarrierType.PHANTOM_REFERS_TO;
            tool.append(new AArch64HotSpotZReadBarrierOp(result, loadAddress, memoryOrder, state, this.config, callTarget, isNotStrong));
            return result;
        }
        throw GraalError.shouldNotReachHere("unhandled");
    }

    @Override
    public void emitCompareAndSwapOp(LIRGeneratorTool tool, boolean isLogicVariant, Value address, MemoryOrderMode memoryOrder, AArch64Kind memKind, Variable result, AllocatableValue allocatableExpectedValue, AllocatableValue allocatableNewValue, BarrierType barrierType) {
        ForeignCallLinkage callTarget = this.getWriteBarrierStub(barrierType, ZWriteBarrierSetLIRGeneratorTool.StoreKind.Atomic);
        Variable temp = tool.newVariable(tool.toRegisterKind(LIRKind.value((PlatformKind)memKind)));
        tool.getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
        tool.append(new AArch64HotSpotZCompareAndSwapOp(isLogicVariant, memKind, memoryOrder, isLogicVariant, result, (Value)allocatableExpectedValue, allocatableNewValue, tool.asAllocatable(address), this.config, callTarget, temp));
    }

    @Override
    public Value emitAtomicReadAndWrite(LIRGeneratorTool tool, LIRKind accessKind, Value address, Value newValue, BarrierType barrierType) {
        Variable result = tool.newVariable(tool.toRegisterKind(accessKind));
        GraalError.guarantee(accessKind.getPlatformKind() == AArch64Kind.QWORD, "unexpected kind for ZGC");
        ForeignCallLinkage callTarget = this.getWriteBarrierStub(barrierType, ZWriteBarrierSetLIRGeneratorTool.StoreKind.Atomic);
        tool.getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
        tool.append(new AArch64HotSpotZAtomicReadAndWriteOp((AArch64Kind)accessKind.getPlatformKind(), result, tool.asAllocatable(address), tool.asAllocatable(newValue), this.config, callTarget));
        return result;
    }

    @Override
    public void emitStore(LIRGeneratorTool tool, ValueKind<?> lirKind, BarrierType barrierType, Value address, Value value, LIRFrameState state, MemoryOrderMode memoryOrder, LocationIdentity locationIdentity) {
        ZWriteBarrierSetLIRGeneratorTool.StoreKind storeKind = locationIdentity instanceof HotSpotReplacementsUtil.OopHandleLocationIdentity ? ZWriteBarrierSetLIRGeneratorTool.StoreKind.Native : ZWriteBarrierSetLIRGeneratorTool.StoreKind.Normal;
        LIRKind accessKind = (LIRKind)value.getValueKind();
        AArch64Kind kind = (AArch64Kind)value.getPlatformKind();
        Variable result = tool.newVariable(accessKind);
        AArch64AddressValue addressValue = ((AArch64LIRGenerator)tool).asAddressValue(address, 64);
        Variable tmp = tool.newVariable(tool.toRegisterKind(accessKind));
        Variable tmp2 = tool.newVariable(tool.toRegisterKind(accessKind));
        GraalError.guarantee(kind == AArch64Kind.QWORD, "unexpected kind for ZGC");
        ForeignCallLinkage callTarget = this.getWriteBarrierStub(barrierType, storeKind);
        tool.getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
        boolean emitPreWriteBarrier = !locationIdentity.isInit() || barrierType == BarrierType.POST_INIT_WRITE;
        tool.append(new AArch64HotSpotZPreWriteBarrierOp((Value)tool.asAllocatable(value), addressValue, tmp, tmp2, this.config, callTarget, result, storeKind, emitPreWriteBarrier, state));
        tool.getArithmetic().emitStore(lirKind, address, (Value)result, emitPreWriteBarrier ? null : state, memoryOrder);
    }
}

