/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64.g1;

import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotG1BarrierSetLIRTool;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotMacroAssembler;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.lir.aarch64.AArch64Move;
import jdk.graal.compiler.lir.aarch64.g1.AArch64G1BarrierSetLIRTool;
import jdk.vm.ci.code.Register;

public class AArch64HotSpotG1BarrierSetLIRTool
extends HotSpotG1BarrierSetLIRTool
implements AArch64G1BarrierSetLIRTool {
    public AArch64HotSpotG1BarrierSetLIRTool(GraalHotSpotVMConfig config, HotSpotProviders providers) {
        super(config, providers);
    }

    @Override
    public void loadObject(AArch64MacroAssembler masm, Register preVal, Register immediateAddress) {
        if (this.config.useCompressedOops) {
            masm.ldr(32, preVal, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, immediateAddress, 0));
            CompressEncoding encoding = this.config.getOopEncoding();
            AArch64Move.UncompressPointerOp.emitUncompressCode(masm, preVal, preVal, encoding, false, this.providers.getRegisters().getHeapBaseRegister(), false);
        } else {
            masm.ldr(64, preVal, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, immediateAddress, 0));
        }
    }

    @Override
    public Register getThread(AArch64MacroAssembler masm) {
        return this.providers.getRegisters().getThreadRegister();
    }

    @Override
    public void computeCard(Register cardAddress, Register storeAddress, Register tmp2, AArch64MacroAssembler masm) {
        int cardTableShift = HotSpotReplacementsUtil.cardTableShift(this.config);
        masm.mov(tmp2, this.cardTableAddress());
        masm.add(64, cardAddress, tmp2, storeAddress, AArch64Assembler.ShiftType.LSR, cardTableShift);
    }

    @Override
    public void verifyOop(AArch64MacroAssembler masm, Register previousValue, Register tmp, Register tmp2, boolean compressed, boolean nonNull) {
        ((AArch64HotSpotMacroAssembler)masm).verifyOop(previousValue, tmp, tmp2, compressed, nonNull);
    }
}

