/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotHostBackend;
import jdk.graal.compiler.hotspot.HotSpotMarkId;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64Call;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="SAFEPOINT")
public class AArch64HotSpotSafepointOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64HotSpotSafepointOp> TYPE = LIRInstructionClass.create(AArch64HotSpotSafepointOp.class);
    @LIRInstruction.State
    protected LIRFrameState state;
    @LIRInstruction.Temp
    protected AllocatableValue scratchValue;
    private final GraalHotSpotVMConfig config;
    private final Register thread;

    public AArch64HotSpotSafepointOp(LIRFrameState state, GraalHotSpotVMConfig config, Register thread, AllocatableValue scratch) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.state = state;
        this.config = config;
        this.thread = thread;
        this.scratchValue = scratch;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register scratch = ValueUtil.asRegister((Value)this.scratchValue);
        AArch64HotSpotSafepointOp.emitCode(crb, masm, this.config, false, this.thread, scratch, this.state);
    }

    public static void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm, GraalHotSpotVMConfig config, boolean atReturn, Register thread, Register scratch, LIRFrameState state) {
        assert (config.threadPollingPageOffset >= 0) : config.threadPollingPageOffset;
        if (config.threadPollingWordOffset != -1 && atReturn && config.pollingPageReturnHandler != 0L) {
            Label entryPoint = new Label();
            Label poll = new Label();
            masm.bind(poll);
            crb.recordMark(HotSpotMarkId.POLL_RETURN_FAR);
            masm.ldr(64, scratch, masm.makeAddress(64, thread, config.threadPollingWordOffset, scratch));
            masm.cmp(64, AArch64.sp, scratch);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.HI, entryPoint);
            crb.getLIR().addSlowPath(null, () -> {
                masm.bind(entryPoint);
                masm.adr(scratch, poll);
                masm.str(64, scratch, masm.makeAddress(64, thread, config.savedExceptionPCOffset));
                AArch64Call.directJmp(crb, masm, crb.getForeignCalls().lookupForeignCall(HotSpotHostBackend.POLLING_PAGE_RETURN_HANDLER));
            });
        } else {
            masm.ldr(64, scratch, masm.makeAddress(64, thread, config.threadPollingPageOffset, scratch));
            crb.recordMark(atReturn ? HotSpotMarkId.POLL_RETURN_FAR : HotSpotMarkId.POLL_FAR);
            if (state != null) {
                crb.recordInfopoint(masm.position(), state, InfopointReason.SAFEPOINT);
            }
            masm.deadLoad(32, AArch64Address.createBaseRegisterOnlyAddress(32, scratch), false);
        }
    }
}

