/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotEpilogueOp;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.DiagnosticLIRGeneratorTool;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

@Opcode(value="RETURN")
public final class AArch64HotSpotReturnOp
extends AArch64HotSpotEpilogueOp
implements DiagnosticLIRGeneratorTool.ZapStackArgumentSpaceBeforeInstruction {
    public static final LIRInstructionClass<AArch64HotSpotReturnOp> TYPE = LIRInstructionClass.create(AArch64HotSpotReturnOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value result;
    private final boolean isStub;
    private final boolean requiresReservedStackAccessCheck;

    public AArch64HotSpotReturnOp(Value result, boolean isStub, GraalHotSpotVMConfig config, Register thread, boolean requiresReservedStackAccessCheck) {
        super(TYPE, config, thread);
        this.requiresReservedStackAccessCheck = requiresReservedStackAccessCheck;
        assert (AArch64HotSpotReturnOp.validReturnValue(result));
        this.result = result;
        this.isStub = isStub;
    }

    private static boolean validReturnValue(Value result) {
        if (result.equals((Object)Value.ILLEGAL)) {
            return true;
        }
        Register reg = ValueUtil.asRegister((Value)result);
        return reg.equals((Object)AArch64.r0) || reg.equals((Object)AArch64.v0);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        boolean emitSafepoint = !this.isStub;
        this.leaveFrame(crb, masm, emitSafepoint, this.requiresReservedStackAccessCheck);
        masm.ret(AArch64.lr);
        crb.frameContext.returned(crb);
    }
}

