/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="PATCH_RETURN")
final class AArch64HotSpotPatchReturnAddressOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64HotSpotPatchReturnAddressOp> TYPE = LIRInstructionClass.create(AArch64HotSpotPatchReturnAddressOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue address;

    AArch64HotSpotPatchReturnAddressOp(AllocatableValue address) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.address = address;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        int frameSize = crb.frameMap.frameSize();
        AArch64Address lrAddress = AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, AArch64.sp, frameSize + crb.target.wordSize);
        masm.str(64, ValueUtil.asRegister((Value)this.address), lrAddress);
    }
}

