/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotMove;
import jdk.graal.compiler.lir.aarch64.AArch64Move;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.site.Call;

public class AArch64HotSpotMacroAssembler
extends AArch64MacroAssembler {
    private final GraalHotSpotVMConfig config;
    private final Register heapBaseRegister;

    public AArch64HotSpotMacroAssembler(TargetDescription target, GraalHotSpotVMConfig config, Register heapBaseRegister) {
        super(target);
        this.config = config;
        this.heapBaseRegister = heapBaseRegister;
    }

    @Override
    public void postCallNop(Call call) {
        if (this.config.continuationsEnabled && call.debugInfo != null) {
            this.nop();
            int movkEncoding = 0xF2800000 | AArch64.zr.encoding();
            this.emitInt(movkEncoding);
            this.emitInt(movkEncoding);
            return;
        }
        super.postCallNop(call);
    }

    public void verifyOop(Register value, Register tmp, Register tmp2, boolean compressed, boolean nonNull) {
        AArch64HotSpotMacroAssembler.guaranteeDifferentRegisters(value, tmp, tmp2);
        Label ok = new Label();
        if (!nonNull) {
            this.cbz(compressed ? 32 : 64, value, ok);
        }
        Register object = value;
        if (compressed) {
            CompressEncoding encoding = this.config.getOopEncoding();
            this.mov(32, tmp, value);
            AArch64Move.UncompressPointerOp.emitUncompressCode(this, tmp, tmp, encoding, true, this.heapBaseRegister, false);
            object = tmp;
        }
        if (this.config.useCompressedClassPointers) {
            if (this.config.useCompactObjectHeaders) {
                this.loadCompactClassPointer(tmp, object);
            } else {
                this.ldr(32, tmp, this.makeAddress(32, object, this.config.hubOffset));
            }
            AArch64HotSpotMove.decodeKlassPointer(this, tmp, tmp, this.config.getKlassEncoding());
        } else {
            this.ldr(64, tmp, this.makeAddress(64, object, this.config.hubOffset));
        }
        this.ldr(32, tmp2, this.makeAddress(32, tmp, this.config.superCheckOffsetOffset));
        this.compare(32, tmp2, this.config.secondarySuperCacheOffset);
        this.branchConditionally(AArch64Assembler.ConditionFlag.EQ, ok);
        this.ldr(64, tmp2, AArch64Address.createRegisterOffsetAddress(64, tmp, tmp2, false));
        this.cmp(64, tmp2, tmp);
        this.branchConditionally(AArch64Assembler.ConditionFlag.EQ, ok);
        this.illegal();
        this.bind(ok);
    }

    public void verifyHeapBase() {
        if (this.heapBaseRegister != null && this.config.narrowOopBase != 0L) {
            try (AArch64MacroAssembler.ScratchRegister sc1 = this.getScratchRegister();){
                Label skip = new Label();
                Register scratch1 = sc1.getRegister();
                this.mov(scratch1, this.config.narrowOopBase);
                this.cmp(64, this.heapBaseRegister, scratch1);
                this.branchConditionally(AArch64Assembler.ConditionFlag.EQ, skip);
                AArch64Address base = this.makeAddress(64, this.heapBaseRegister, 0);
                this.ldr(64, scratch1, base);
                this.bind(skip);
            }
        }
    }

    public void loadCompactClassPointer(Register result, Register receiver) {
        GraalError.guarantee(this.config.useCompactObjectHeaders, "Load class pointer from markWord only when UseCompactObjectHeaders is on");
        this.ldr(64, result, this.makeAddress(64, receiver, this.config.markOffset));
        this.lsr(64, result, result, this.config.markWordKlassShift);
    }
}

