/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Function;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.aarch64.AArch64ArithmeticLIRGenerator;
import jdk.graal.compiler.core.aarch64.AArch64LIRGenerator;
import jdk.graal.compiler.core.aarch64.AArch64LIRKindTool;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.common.spi.LIRKindTool;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotBackend;
import jdk.graal.compiler.hotspot.HotSpotDebugInfoBuilder;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntime;
import jdk.graal.compiler.hotspot.HotSpotLIRGenerationResult;
import jdk.graal.compiler.hotspot.HotSpotLIRGenerator;
import jdk.graal.compiler.hotspot.HotSpotLockStack;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotCRuntimeCallEpilogueOp;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotCRuntimeCallPrologueOp;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotCounterOp;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotDeoptimizeCallerOp;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotDeoptimizeOp;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotDeoptimizeWithExceptionCallerOp;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotMove;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotMoveFactory;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotReturnOp;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotStrategySwitchOp;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotUnwindOp;
import jdk.graal.compiler.hotspot.aarch64.g1.AArch64HotSpotG1BarrierSetLIRTool;
import jdk.graal.compiler.hotspot.aarch64.z.AArch64HotSpotZBarrierSetLIRGenerator;
import jdk.graal.compiler.hotspot.debug.BenchmarkCounters;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.meta.HotSpotRegistersProvider;
import jdk.graal.compiler.hotspot.stubs.ForeignCallStub;
import jdk.graal.compiler.hotspot.stubs.Stub;
import jdk.graal.compiler.lir.ConstantValue;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.LabelRef;
import jdk.graal.compiler.lir.SwitchStrategy;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.lir.aarch64.AArch64AddressValue;
import jdk.graal.compiler.lir.aarch64.AArch64Call;
import jdk.graal.compiler.lir.aarch64.AArch64ControlFlow;
import jdk.graal.compiler.lir.aarch64.AArch64FrameMapBuilder;
import jdk.graal.compiler.lir.aarch64.AArch64Move;
import jdk.graal.compiler.lir.aarch64.AArch64PrefetchOp;
import jdk.graal.compiler.lir.aarch64.AArch64RestoreRegistersOp;
import jdk.graal.compiler.lir.aarch64.AArch64SaveRegistersOp;
import jdk.graal.compiler.lir.aarch64.AArch64SpinWaitOp;
import jdk.graal.compiler.lir.aarch64.g1.AArch64G1BarrierSetLIRGenerator;
import jdk.graal.compiler.lir.gen.BarrierSetLIRGeneratorTool;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.gen.MoveFactory;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public class AArch64HotSpotLIRGenerator
extends AArch64LIRGenerator
implements HotSpotLIRGenerator {
    final GraalHotSpotVMConfig config;
    private HotSpotDebugInfoBuilder debugInfoBuilder;
    private LIRFrameState currentRuntimeCallInfo;
    private Label label;

    protected static BarrierSetLIRGeneratorTool getBarrierSet(GraalHotSpotVMConfig config, HotSpotProviders providers) {
        if (config.gc == HotSpotGraalRuntime.HotSpotGC.G1) {
            return new AArch64G1BarrierSetLIRGenerator(new AArch64HotSpotG1BarrierSetLIRTool(config, providers));
        }
        if (config.gc == HotSpotGraalRuntime.HotSpotGC.Z) {
            return new AArch64HotSpotZBarrierSetLIRGenerator(config, providers);
        }
        return null;
    }

    protected AArch64HotSpotLIRGenerator(HotSpotProviders providers, GraalHotSpotVMConfig config, LIRGenerationResult lirGenRes) {
        this(new AArch64LIRKindTool(), new AArch64ArithmeticLIRGenerator(null), AArch64HotSpotLIRGenerator.getBarrierSet(config, providers), new AArch64HotSpotMoveFactory(), providers, config, lirGenRes);
    }

    protected AArch64HotSpotLIRGenerator(LIRKindTool lirKindTool, AArch64ArithmeticLIRGenerator arithmeticLIRGen, BarrierSetLIRGeneratorTool barrierSetLIRGen, MoveFactory moveFactory, HotSpotProviders providers, GraalHotSpotVMConfig config, LIRGenerationResult lirGenRes) {
        super(lirKindTool, arithmeticLIRGen, barrierSetLIRGen, moveFactory, providers, lirGenRes);
        this.config = config;
    }

    @Override
    public HotSpotProviders getProviders() {
        return (HotSpotProviders)super.getProviders();
    }

    @Override
    public boolean needOnlyOopMaps() {
        return this.getResult().getStub() != null;
    }

    @Override
    protected Value getCompareValueForConstantPointer(Value v) {
        if (LIRValueUtil.isConstantValue(v)) {
            Constant c = LIRValueUtil.asConstant(v);
            if (JavaConstant.isNull((Constant)c)) {
                PlatformKind platformKind = v.getPlatformKind();
                assert (platformKind.equals((Object)AArch64Kind.DWORD) || platformKind.equals((Object)AArch64Kind.QWORD)) : String.format("unexpected null value: %s[%s]", platformKind, v);
                return new ConstantValue(LIRKind.value(platformKind), (Constant)(platformKind.getSizeInBytes() == 4 ? JavaConstant.INT_0 : JavaConstant.LONG_0));
            }
            if (c instanceof HotSpotObjectConstant) {
                return this.asAllocatable(v);
            }
        }
        return super.getCompareValueForConstantPointer(v);
    }

    @Override
    protected void emitForeignCallOp(ForeignCallLinkage linkage, Value targetAddress, Value result, Value[] arguments, Value[] temps, LIRFrameState info) {
        this.currentRuntimeCallInfo = info;
        if (AArch64Call.isNearCall(linkage)) {
            this.append(new AArch64Call.DirectNearForeignCallOp(linkage, result, arguments, temps, info, this.label));
        } else {
            this.append(new AArch64Call.DirectFarForeignCallOp(linkage, result, arguments, temps, info, this.label));
        }
        Stub stub = this.getStub();
        if (stub != null && stub.getLinkage().getEffect() == HotSpotForeignCallLinkage.RegisterEffect.KILLS_NO_REGISTERS && result != null) {
            assert (stub instanceof ForeignCallStub) : stub;
            CallingConvention inCC = stub.getLinkage().getIncomingCallingConvention();
            if (!inCC.getReturn().equals((Object)linkage.getOutgoingCallingConvention().getReturn())) {
                assert (ValueUtil.isStackSlot((Value)inCC.getReturn())) : inCC.getReturn();
                this.emitMove(inCC.getReturn(), result);
            }
        }
    }

    protected AArch64SaveRegistersOp emitSaveRegisters(Register[] savedRegisters, AllocatableValue[] savedRegisterLocations) {
        AArch64SaveRegistersOp save = new AArch64SaveRegistersOp(savedRegisters, savedRegisterLocations);
        this.append(save);
        return save;
    }

    protected VirtualStackSlot allocateSaveRegisterLocation(Register register) {
        PlatformKind kind = this.target().arch.getLargestStorableKind(register.getRegisterCategory());
        if (kind.getVectorLength() > 1) {
            kind = AArch64Kind.DOUBLE;
        }
        return this.getResult().getFrameMapBuilder().allocateSpillSlot(LIRKind.value(kind));
    }

    public AArch64SaveRegistersOp emitSaveAllRegisters(Register[] savedRegisters) {
        AllocatableValue[] savedRegisterLocations = new AllocatableValue[savedRegisters.length];
        for (int i = 0; i < savedRegisters.length; ++i) {
            savedRegisterLocations[i] = this.allocateSaveRegisterLocation(savedRegisters[i]);
        }
        return this.emitSaveRegisters(savedRegisters, savedRegisterLocations);
    }

    protected void emitRestoreRegisters(AArch64SaveRegistersOp save) {
        this.append(new AArch64RestoreRegistersOp((AllocatableValue[])save.getSlots().clone(), save));
    }

    @Override
    public VirtualStackSlot getLockSlot(int lockDepth) {
        return this.getLockStack().makeLockSlot(lockDepth);
    }

    private HotSpotLockStack getLockStack() {
        assert (this.debugInfoBuilder != null && this.debugInfoBuilder.lockStack() != null) : this.debugInfoBuilder;
        return this.debugInfoBuilder.lockStack();
    }

    @Override
    public Value emitCompress(Value pointer, CompressEncoding encoding, boolean nonNull) {
        LIRKind inputKind = (LIRKind)pointer.getValueKind(LIRKind.class);
        assert (inputKind.getPlatformKind() == AArch64Kind.QWORD) : inputKind;
        if (inputKind.isReference(0)) {
            Variable result = this.newVariable(LIRKind.compressedReference((PlatformKind)AArch64Kind.DWORD));
            this.append(new AArch64HotSpotMove.CompressPointer(result, this.asAllocatable(pointer), (AllocatableValue)this.getProviders().getRegisters().getHeapBaseRegister().asValue(), encoding, nonNull));
            return result;
        }
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AArch64Kind.DWORD));
        AllocatableValue base = Value.ILLEGAL;
        if (encoding.hasBase()) {
            base = this.emitLoadConstant(LIRKind.value((PlatformKind)AArch64Kind.QWORD), (Constant)JavaConstant.forLong((long)encoding.getBase()));
        }
        this.append(new AArch64HotSpotMove.CompressPointer(result, this.asAllocatable(pointer), base, encoding, nonNull));
        return result;
    }

    @Override
    public Value emitUncompress(Value pointer, CompressEncoding encoding, boolean nonNull) {
        LIRKind inputKind = (LIRKind)pointer.getValueKind(LIRKind.class);
        assert (inputKind.getPlatformKind() == AArch64Kind.DWORD) : Assertions.errorMessage(new Object[]{inputKind, pointer});
        if (inputKind.isReference(0)) {
            Variable result = this.newVariable(LIRKind.reference((PlatformKind)AArch64Kind.QWORD));
            this.append(new AArch64HotSpotMove.UncompressPointer(result, this.asAllocatable(pointer), (AllocatableValue)this.getProviders().getRegisters().getHeapBaseRegister().asValue(), encoding, nonNull));
            return result;
        }
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AArch64Kind.QWORD));
        AllocatableValue base = Value.ILLEGAL;
        if (encoding.hasBase()) {
            base = this.emitLoadConstant(LIRKind.value((PlatformKind)AArch64Kind.QWORD), (Constant)JavaConstant.forLong((long)encoding.getBase()));
        }
        this.append(new AArch64HotSpotMove.UncompressPointer(result, this.asAllocatable(pointer), base, encoding, nonNull));
        return result;
    }

    @Override
    public void emitNullCheck(Value address, LIRFrameState state) {
        if (address.getValueKind().getPlatformKind() == AArch64Kind.DWORD) {
            CompressEncoding encoding = this.config.getOopEncoding();
            Value uncompressed = this.emitUncompress(address, encoding, false);
            this.append(new AArch64Move.NullCheckOp(this.asAddressValue(uncompressed, -1), state));
        } else {
            super.emitNullCheck(address, state);
        }
    }

    private Value transformBenchmarkCounterIncrement(Value increment) {
        if (LIRValueUtil.isJavaConstant(increment) && AArch64ArithmeticLIRGenerator.isAddSubtractConstant(LIRValueUtil.asJavaConstant(increment))) {
            return increment;
        }
        return this.asAllocatable(increment);
    }

    @Override
    public LIRInstruction createBenchmarkCounter(String name, String group, Value increment) {
        if (BenchmarkCounters.enabled) {
            return new AArch64HotSpotCounterOp(name, group, this.transformBenchmarkCounterIncrement(increment), this.getProviders().getRegisters(), this.config);
        }
        throw GraalError.shouldNotReachHere("BenchmarkCounters are not enabled!");
    }

    @Override
    public LIRInstruction createMultiBenchmarkCounter(String[] names, String[] groups, Value[] increments) {
        if (BenchmarkCounters.enabled) {
            Value[] incrementValues = (Value[])Arrays.stream(increments).map(this::transformBenchmarkCounterIncrement).toArray(Value[]::new);
            return new AArch64HotSpotCounterOp(names, groups, incrementValues, this.getProviders().getRegisters(), this.config);
        }
        throw GraalError.shouldNotReachHere("BenchmarkCounters are not enabled!");
    }

    @Override
    public void emitPrefetchAllocate(Value address) {
        this.append(new AArch64PrefetchOp(this.asAddressValue(address, -1), AArch64Assembler.PrefetchMode.PSTL1KEEP));
    }

    @Override
    public void beforeRegisterAllocation() {
        super.beforeRegisterAllocation();
        boolean hasDebugInfo = this.getResult().getLIR().hasDebugInfo();
        if (hasDebugInfo) {
            this.getResult().setDeoptimizationRescueSlot(((AArch64FrameMapBuilder)this.getResult().getFrameMapBuilder()).allocateDeoptimizationRescueSlot());
        }
        this.getResult().setMaxInterpreterFrameSize(this.debugInfoBuilder.maxInterpreterFrameSize());
    }

    @Override
    public Variable emitForeignCall(ForeignCallLinkage linkage, LIRFrameState state, Value ... args) {
        Variable result;
        HotSpotForeignCallLinkage hotspotLinkage = (HotSpotForeignCallLinkage)linkage;
        boolean destroysRegisters = hotspotLinkage.destroysRegisters();
        AArch64SaveRegistersOp save = null;
        Stub stub = this.getStub();
        if (destroysRegisters && stub != null && stub.getLinkage().getEffect() == HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED) {
            Register[] savedRegisters = this.getRegisterConfig().getAllocatableRegisters().toArray();
            save = this.emitSaveAllRegisters(savedRegisters);
        }
        LIRFrameState debugInfo = null;
        if (hotspotLinkage.needsDebugInfo()) {
            debugInfo = state;
            assert (debugInfo != null || this.getStub() != null);
        }
        if (destroysRegisters || hotspotLinkage.needsJavaFrameAnchor()) {
            HotSpotRegistersProvider registers = this.getProviders().getRegisters();
            Register thread = registers.getThreadRegister();
            Variable scratch = this.newVariable(LIRKind.value(this.target().arch.getWordKind()));
            this.label = new Label();
            this.append(new AArch64HotSpotCRuntimeCallPrologueOp(this.config.threadLastJavaSpOffset(), this.config.threadLastJavaPcOffset(), thread, scratch, this.label));
            result = super.emitForeignCall(hotspotLinkage, debugInfo, args);
            this.append(new AArch64HotSpotCRuntimeCallEpilogueOp(this.config.threadLastJavaSpOffset(), this.config.threadLastJavaPcOffset(), thread, this.label));
            this.label = null;
        } else {
            result = super.emitForeignCall(hotspotLinkage, debugInfo, args);
        }
        if (save != null) {
            HotSpotLIRGenerationResult generationResult = this.getResult();
            LIRFrameState key = this.currentRuntimeCallInfo;
            if (key == null) {
                key = LIRFrameState.noCalleeSaveInfo();
            }
            assert (!generationResult.getCalleeSaveInfo().containsKey((Object)key));
            generationResult.getCalleeSaveInfo().put((Object)key, (Object)save);
            this.emitRestoreRegisters(save);
        }
        return result;
    }

    @Override
    public void emitDeoptimizeCaller(DeoptimizationAction action, DeoptimizationReason reason) {
        Value actionAndReason = this.emitJavaConstant(this.getMetaAccess().encodeDeoptActionAndReason(action, reason, 0));
        Value speculation = this.emitJavaConstant(this.getMetaAccess().encodeSpeculation(SpeculationLog.NO_SPECULATION));
        this.moveDeoptValuesToThread(actionAndReason, speculation);
        this.append(new AArch64HotSpotDeoptimizeCallerOp(this.config));
    }

    @Override
    public void emitDeoptimizeWithExceptionInCaller(Value exception) {
        Register thread = this.getProviders().getRegisters().getThreadRegister();
        this.append(new AArch64HotSpotDeoptimizeWithExceptionCallerOp(this.config, exception, thread));
    }

    @Override
    public void emitDeoptimize(Value actionAndReason, Value failedSpeculation, LIRFrameState state) {
        this.moveDeoptValuesToThread(actionAndReason, failedSpeculation);
        this.append(new AArch64HotSpotDeoptimizeOp(state));
    }

    private void moveDeoptValuesToThread(Value actionAndReason, Value speculation) {
        this.moveValueToThread(actionAndReason, this.config.pendingDeoptimizationOffset);
        this.moveValueToThread(speculation, this.config.pendingFailedSpeculationOffset);
    }

    private void moveValueToThread(Value value, int offset) {
        LIRKind wordKind = LIRKind.value(this.target().arch.getWordKind());
        int bitMemoryTransferSize = value.getValueKind().getPlatformKind().getSizeInBytes() * 8;
        RegisterValue thread = this.getProviders().getRegisters().getThreadRegister().asValue((ValueKind)wordKind);
        AArch64AddressValue address = AArch64AddressValue.makeAddress(wordKind, bitMemoryTransferSize, (AllocatableValue)thread, offset);
        this.append(new AArch64Move.StoreOp((AArch64Kind)value.getPlatformKind(), address, this.asAllocatable(value), null));
    }

    @Override
    public void emitUnwind(Value exception) {
        ForeignCallLinkage linkage = this.getForeignCalls().lookupForeignCall(HotSpotBackend.UNWIND_EXCEPTION_TO_CALLER);
        CallingConvention outgoingCc = linkage.getOutgoingCallingConvention();
        assert (outgoingCc.getArgumentCount() == 2) : Assertions.errorMessage(outgoingCc);
        RegisterValue exceptionParameter = (RegisterValue)outgoingCc.getArgument(0);
        this.emitMove((AllocatableValue)exceptionParameter, exception);
        this.append(new AArch64HotSpotUnwindOp(this.config, exceptionParameter));
    }

    @Override
    public void emitReturn(JavaKind kind, Value input) {
        AArch64SaveRegistersOp saveOnEntry;
        AllocatableValue operand = Value.ILLEGAL;
        if (input != null) {
            operand = this.resultOperandFor(kind, input.getValueKind());
            this.emitMove(operand, input);
        }
        if ((saveOnEntry = (AArch64SaveRegistersOp)this.getResult().getSaveOnEntry()) != null) {
            this.append(new AArch64RestoreRegistersOp(saveOnEntry.getSlots(), saveOnEntry));
        }
        Register thread = this.getProviders().getRegisters().getThreadRegister();
        this.append(new AArch64HotSpotReturnOp((Value)operand, this.getStub() != null, this.config, thread, this.getResult().requiresReservedStackAccessCheck()));
    }

    public Stub getStub() {
        return this.getResult().getStub();
    }

    @Override
    public HotSpotLIRGenerationResult getResult() {
        return (HotSpotLIRGenerationResult)super.getResult();
    }

    @Override
    protected AArch64ControlFlow.StrategySwitchOp createStrategySwitchOp(SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, AllocatableValue key, Function<Condition, AArch64Assembler.ConditionFlag> converter) {
        return new AArch64HotSpotStrategySwitchOp(strategy, keyTargets, defaultTarget, key, converter);
    }

    public void setDebugInfoBuilder(HotSpotDebugInfoBuilder debugInfoBuilder) {
        this.debugInfoBuilder = debugInfoBuilder;
    }

    @Override
    public void emitZeroMemory(Value address, Value length, boolean isAligned) {
        EnumSet flags = ((AArch64)this.target().arch).getFlags();
        int zvaLength = this.config.zvaLength;
        boolean isDcZvaProhibited = 0 == zvaLength;
        boolean useDcZva = !isDcZvaProhibited && flags.contains(AArch64.Flag.UseBlockZeroing);
        this.emitZeroMemory(address, length, isAligned, useDcZva, zvaLength);
    }

    private Consumer<AArch64MacroAssembler> onSpinWaitInst() {
        return switch (this.config.onSpinWaitInst) {
            case "nop" -> AArch64MacroAssembler::nop;
            case "isb" -> AArch64Assembler::isb;
            case "yield" -> AArch64MacroAssembler::pause;
            default -> throw GraalError.shouldNotReachHere("Unknown OnSpinWaitInst " + this.config.onSpinWaitInst);
        };
    }

    @Override
    public void emitSpinWait() {
        if (!"none".equals(this.config.onSpinWaitInst)) {
            GraalError.guarantee(this.config.onSpinWaitInstCount > 0, "illegal onSpinWaitInstCount");
            this.append(new AArch64SpinWaitOp(this.onSpinWaitInst(), this.config.onSpinWaitInstCount));
        }
    }

    @Override
    public int getArrayLengthOffset() {
        return this.config.arrayOopDescLengthOffset();
    }

    @Override
    public Register getHeapBaseRegister() {
        return this.getProviders().getRegisters().getHeapBaseRegister();
    }

    @Override
    protected int getVMPageSize() {
        return this.config.vmPageSize;
    }

    @Override
    protected int getSoftwarePrefetchHintDistance() {
        return this.config.softwarePrefetchHintDistance;
    }
}

