/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotHostBackend;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotSafepointOp;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallsProvider;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.aarch64.AArch64BlockEndOp;
import jdk.graal.compiler.lir.aarch64.AArch64Call;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.hotspot.aarch64.AArch64HotSpotRegisterConfig;

abstract class AArch64HotSpotEpilogueOp
extends AArch64BlockEndOp {
    protected final GraalHotSpotVMConfig config;
    protected final Register thread;

    protected AArch64HotSpotEpilogueOp(LIRInstructionClass<? extends AArch64HotSpotEpilogueOp> c, GraalHotSpotVMConfig config, Register thread) {
        super((LIRInstructionClass<? extends AArch64BlockEndOp>)c);
        this.config = config;
        this.thread = thread;
    }

    protected AArch64HotSpotEpilogueOp(LIRInstructionClass<? extends AArch64HotSpotEpilogueOp> c, GraalHotSpotVMConfig config) {
        super((LIRInstructionClass<? extends AArch64BlockEndOp>)c);
        this.config = config;
        this.thread = null;
    }

    protected void leaveFrame(CompilationResultBuilder crb, AArch64MacroAssembler masm, boolean emitSafepoint, boolean requiresReservedStackAccessCheck) {
        assert (crb.frameContext != null) : "We never elide frames in aarch64";
        crb.frameContext.leave(crb);
        if (requiresReservedStackAccessCheck) {
            HotSpotForeignCallsProvider foreignCalls = (HotSpotForeignCallsProvider)crb.getForeignCalls();
            Label noReserved = new Label();
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                Register scratch = sc.getRegister();
                masm.ldr(64, scratch, masm.makeAddress(64, this.thread, this.config.javaThreadReservedStackActivationOffset));
                masm.subs(64, AArch64.zr, AArch64.sp, scratch);
            }
            masm.branchConditionally(AArch64Assembler.ConditionFlag.LO, noReserved);
            ForeignCallLinkage enableStackReservedZone = foreignCalls.lookupForeignCall(HotSpotHostBackend.ENABLE_STACK_RESERVED_ZONE);
            CallingConvention cc = enableStackReservedZone.getOutgoingCallingConvention();
            assert (cc.getArgumentCount() == 1) : cc;
            Register arg0 = ((RegisterValue)cc.getArgument(0)).getRegister();
            masm.mov(64, arg0, this.thread);
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                masm.stp(64, AArch64HotSpotRegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_PAIR_PRE_INDEXED, AArch64.sp, -16));
                AArch64Call.directCall(crb, masm, enableStackReservedZone, sc.getRegister(), null);
                masm.ldp(64, AArch64HotSpotRegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, AArch64.sp, 16));
            }
            AArch64Call.directJmp(crb, masm, foreignCalls.lookupForeignCall(HotSpotHostBackend.THROW_DELAYED_STACKOVERFLOW_ERROR));
            masm.bind(noReserved);
        }
        if (emitSafepoint) {
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                Register scratch = sc.getRegister();
                AArch64HotSpotSafepointOp.emitCode(crb, masm, this.config, true, this.thread, scratch, null);
            }
        }
    }
}

