/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64;

import java.lang.reflect.Modifier;
import jdk.graal.compiler.asm.BranchTargetOutOfBoundsException;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.code.DataSection;
import jdk.graal.compiler.core.aarch64.AArch64NodeMatchRules;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.alloc.RegisterAllocationConfig;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.gen.LIRGenerationProvider;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotDataBuilder;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.HotSpotHostBackend;
import jdk.graal.compiler.hotspot.HotSpotLIRGenerationResult;
import jdk.graal.compiler.hotspot.HotSpotMarkId;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotLIRGenerator;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotMacroAssembler;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotMove;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotNodeLIRBuilder;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotRegisterAllocationConfig;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.stubs.Stub;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.aarch64.AArch64Call;
import jdk.graal.compiler.lir.aarch64.AArch64FrameMap;
import jdk.graal.compiler.lir.aarch64.AArch64FrameMapBuilder;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.asm.CompilationResultBuilderFactory;
import jdk.graal.compiler.lir.asm.EntryPointDecorator;
import jdk.graal.compiler.lir.asm.FrameContext;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.graal.compiler.lir.framemap.FrameMapBuilder;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.aarch64.AArch64HotSpotRegisterConfig;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;

public class AArch64HotSpotBackend
extends HotSpotHostBackend
implements LIRGenerationProvider {
    public AArch64HotSpotBackend(GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime, HotSpotProviders providers) {
        super(config, runtime, providers);
    }

    @Override
    protected FrameMapBuilder newFrameMapBuilder(RegisterConfig registerConfig, Stub stub) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        AArch64FrameMap frameMap = new AArch64FrameMap(this.getCodeCache(), registerConfigNonNull, this);
        return new AArch64FrameMapBuilder(frameMap, this.getCodeCache(), registerConfigNonNull);
    }

    @Override
    public LIRGeneratorTool newLIRGenerator(LIRGenerationResult lirGenRes) {
        return new AArch64HotSpotLIRGenerator(this.getProviders(), this.config, lirGenRes);
    }

    @Override
    public NodeLIRBuilderTool newNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool lirGen) {
        return new AArch64HotSpotNodeLIRBuilder(graph, lirGen, new AArch64NodeMatchRules(lirGen));
    }

    @Override
    protected void bangStackWithOffset(CompilationResultBuilder crb, int bangOffset) {
        AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
        try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
            Register scratch = sc.getRegister();
            AArch64Address address = masm.makeAddress(64, AArch64.sp, -bangOffset, scratch);
            masm.str(64, AArch64.zr, address);
        }
    }

    @Override
    public InstalledCode createInstalledCode(DebugContext debug, ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult, InstalledCode predefinedInstalledCode, boolean isDefault, Object[] context) {
        boolean isStub;
        boolean bl = isStub = method == null;
        if (!isStub) assert (this.hasInvalidatePlaceholder(compilationResult));
        return super.createInstalledCode(debug, method, compilationRequest, compilationResult, predefinedInstalledCode, isDefault, context);
    }

    private boolean hasInvalidatePlaceholder(CompilationResult compilationResult) {
        byte[] targetCode = compilationResult.getTargetCode();
        int verifiedEntryOffset = 0;
        for (CompilationResult.CodeMark mark : compilationResult.getMarks()) {
            if (mark.id != HotSpotMarkId.VERIFIED_ENTRY && mark.id != HotSpotMarkId.OSR_ENTRY) continue;
            verifiedEntryOffset = mark.pcOffset;
            break;
        }
        Unsafe unsafe = Unsafe.getUnsafe();
        int instruction = unsafe.getIntVolatile(targetCode, unsafe.arrayBaseOffset(byte[].class) + verifiedEntryOffset);
        AArch64MacroAssembler masm = new AArch64MacroAssembler(this.getTarget());
        masm.nop();
        return instruction == masm.getInt(0);
    }

    public void rawLeave(CompilationResultBuilder crb) {
        AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
        FrameMap frameMap = crb.frameMap;
        int totalFrameSize = frameMap.totalFrameSize();
        try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
            int wordSize = 8;
            Register scratch = sc.getRegister();
            int frameSize = frameMap.frameSize();
            assert (totalFrameSize > 0) : totalFrameSize;
            AArch64Address.AddressingMode addressingMode = AArch64Address.AddressingMode.IMMEDIATE_PAIR_SIGNED_SCALED;
            if (AArch64Address.isValidImmediateAddress(64, addressingMode, frameSize)) {
                masm.ldp(64, AArch64HotSpotRegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress(64, addressingMode, AArch64.sp, frameSize));
                masm.add(64, AArch64.sp, AArch64.sp, totalFrameSize);
            } else {
                int frameRecordSize = 2 * wordSize;
                masm.add(64, AArch64.sp, AArch64.sp, totalFrameSize - frameRecordSize, scratch);
                masm.ldp(64, AArch64HotSpotRegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, AArch64.sp, frameRecordSize));
            }
            if (this.config.ropProtection) {
                masm.autia(AArch64.lr, AArch64HotSpotRegisterConfig.fp);
            }
        }
    }

    public static void rawEnter(CompilationResultBuilder crb, FrameMap frameMap, AArch64MacroAssembler masm, GraalHotSpotVMConfig config, boolean isStub) {
        try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
            if (config.ropProtection) {
                masm.pacia(AArch64.lr, AArch64HotSpotRegisterConfig.fp);
            }
            int frameSize = frameMap.frameSize();
            int totalFrameSize = frameMap.totalFrameSize();
            int wordSize = crb.target.arch.getWordSize();
            assert (frameSize + 2 * wordSize == totalFrameSize) : "total framesize should be framesize + 2 words";
            Register scratch = sc.getRegister();
            assert (totalFrameSize > 0) : totalFrameSize;
            AArch64Address.AddressingMode addressingMode = AArch64Address.AddressingMode.IMMEDIATE_PAIR_SIGNED_SCALED;
            if (AArch64Address.isValidImmediateAddress(64, addressingMode, frameSize)) {
                masm.sub(64, AArch64.sp, AArch64.sp, totalFrameSize);
                masm.stp(64, AArch64HotSpotRegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress(64, addressingMode, AArch64.sp, frameSize));
                if (config.preserveFramePointer(isStub)) {
                    masm.add(64, AArch64HotSpotRegisterConfig.fp, AArch64.sp, frameSize);
                }
            } else {
                int frameRecordSize = 2 * wordSize;
                masm.stp(64, AArch64HotSpotRegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_PAIR_PRE_INDEXED, AArch64.sp, -frameRecordSize));
                if (config.preserveFramePointer(isStub)) {
                    masm.mov(64, AArch64HotSpotRegisterConfig.fp, AArch64.sp);
                }
                masm.sub(64, AArch64.sp, AArch64.sp, totalFrameSize - frameRecordSize, scratch);
            }
        }
    }

    @Override
    public CompilationResultBuilder newCompilationResultBuilder(LIRGenerationResult lirGenRen, FrameMap frameMap, CompilationResult compilationResult, CompilationResultBuilderFactory factory, EntryPointDecorator entryPointDecorator) {
        HotSpotLIRGenerationResult gen = (HotSpotLIRGenerationResult)lirGenRen;
        LIR lir = gen.getLIR();
        assert (gen.getDeoptimizationRescueSlot() == null || frameMap.frameNeedsAllocating()) : "method that can deoptimize must have a frame";
        Stub stub = gen.getStub();
        AArch64HotSpotMacroAssembler masm = new AArch64HotSpotMacroAssembler(this.getTarget(), this.config, AArch64HotSpotRegisterConfig.heapBaseRegister);
        HotSpotFrameContext frameContext = new HotSpotFrameContext(stub != null, entryPointDecorator);
        HotSpotDataBuilder dataBuilder = new HotSpotDataBuilder(this.getCodeCache().getTarget());
        CompilationResultBuilder crb = factory.createBuilder(this.getProviders(), frameMap, masm, dataBuilder, frameContext, lir.getOptions(), lir.getDebug(), compilationResult, Register.None, lir);
        crb.setTotalFrameSize(frameMap.totalFrameSize());
        crb.setMaxInterpreterFrameSize(gen.getMaxInterpreterFrameSize());
        crb.setMinDataSectionItemAlignment(this.getMinDataSectionItemAlignment());
        StackSlot deoptimizationRescueSlot = gen.getDeoptimizationRescueSlot();
        if (deoptimizationRescueSlot != null && stub == null) {
            crb.compilationResult.setCustomStackAreaOffset(deoptimizationRescueSlot);
        }
        if (stub != null) {
            this.updateStub(stub, gen, frameMap);
        }
        return crb;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, ResolvedJavaMethod installedCodeOwner, EntryPointDecorator entryPointDecorator) {
        crb.buildLabelOffsets();
        try {
            this.emitCodeHelper(crb, installedCodeOwner, entryPointDecorator);
        }
        catch (BranchTargetOutOfBoundsException e) {
            crb.resetForEmittingCode();
            crb.setConservativeLabelRanges();
            this.emitCodeHelper(crb, installedCodeOwner, entryPointDecorator);
        }
    }

    private void emitCodeHelper(CompilationResultBuilder crb, ResolvedJavaMethod installedCodeOwner, EntryPointDecorator entryPointDecorator) {
        AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
        FrameMap frameMap = crb.frameMap;
        RegisterConfig regConfig = frameMap.getRegisterConfig();
        this.emitCodePrefix(crb, installedCodeOwner, masm, regConfig);
        if (entryPointDecorator != null) {
            entryPointDecorator.emitEntryPoint(crb, true);
        }
        AArch64HotSpotBackend.emitCodeBody(crb, masm);
        this.emitCodeSuffix(crb, masm);
    }

    private void emitCodePrefix(CompilationResultBuilder crb, ResolvedJavaMethod installedCodeOwner, AArch64MacroAssembler masm, RegisterConfig regConfig) {
        Label verifiedStub = new Label();
        HotSpotProviders providers = this.getProviders();
        if (installedCodeOwner != null && !Modifier.isStatic(installedCodeOwner.getModifiers())) {
            int size;
            JavaType[] parameterTypes = new JavaType[]{providers.getMetaAccess().lookupJavaType(Object.class)};
            CallingConvention cc = regConfig.getCallingConvention((CallingConvention.Type)HotSpotCallingConventionType.JavaCallee, null, parameterTypes, (ValueKindFactory)this);
            Register receiver = ValueUtil.asRegister((Value)cc.getArgument(0));
            int n = size = this.config.useCompressedClassPointers ? 32 : 64;
            if (this.config.icSpeculatedKlassOffset == Integer.MAX_VALUE) {
                crb.recordMark(HotSpotMarkId.UNVERIFIED_ENTRY);
                Register klass = AArch64.rscratch1;
                if (this.config.useCompressedClassPointers) {
                    if (this.config.useCompactObjectHeaders) {
                        ((AArch64HotSpotMacroAssembler)masm).loadCompactClassPointer(klass, receiver);
                    } else {
                        masm.ldr(size, klass, masm.makeAddress(size, receiver, this.config.hubOffset));
                    }
                    AArch64HotSpotMove.decodeKlassPointer(masm, klass, klass, this.config.getKlassEncoding());
                } else {
                    masm.ldr(size, klass, masm.makeAddress(size, receiver, this.config.hubOffset));
                }
                Register inlineCacheKlass = AArch64HotSpotRegisterConfig.inlineCacheRegister;
                masm.cmp(64, inlineCacheKlass, klass);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, verifiedStub);
                AArch64Call.directJmp(crb, masm, this.getForeignCalls().lookupForeignCall(IC_MISS_HANDLER));
            } else {
                int inlineCacheCheckSize;
                Register data = AArch64HotSpotRegisterConfig.inlineCacheRegister;
                Register tmp1 = AArch64.rscratch1;
                Register tmp2 = AArch64.r10;
                ForeignCallLinkage icMissHandler = this.getForeignCalls().lookupForeignCall(IC_MISS_HANDLER);
                int n2 = inlineCacheCheckSize = AArch64Call.isNearCall(icMissHandler) ? 20 : 32;
                if (this.config.useCompactObjectHeaders) {
                    inlineCacheCheckSize += 4;
                }
                masm.align(this.config.codeEntryAlignment, masm.position() + inlineCacheCheckSize);
                int startICCheck = masm.position();
                crb.recordMark(HotSpotMarkId.UNVERIFIED_ENTRY);
                AArch64Address icSpeculatedKlass = masm.makeAddress(size, data, this.config.icSpeculatedKlassOffset);
                if (this.config.useCompactObjectHeaders) {
                    ((AArch64HotSpotMacroAssembler)masm).loadCompactClassPointer(tmp1, receiver);
                } else {
                    masm.ldr(size, tmp1, masm.makeAddress(size, receiver, this.config.hubOffset));
                }
                masm.ldr(size, tmp2, icSpeculatedKlass);
                masm.cmp(size, tmp1, tmp2);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, verifiedStub);
                AArch64Call.directJmp(crb, masm, icMissHandler);
                int actualInlineCacheCheckSize = masm.position() - startICCheck;
                if (actualInlineCacheCheckSize != inlineCacheCheckSize) {
                    throw new GraalError("%s != %s", actualInlineCacheCheckSize, inlineCacheCheckSize);
                }
            }
        }
        masm.align(this.config.codeEntryAlignment);
        masm.bind(verifiedStub);
        crb.recordMark(crb.compilationResult.getEntryBCI() != -1 ? HotSpotMarkId.OSR_ENTRY : HotSpotMarkId.VERIFIED_ENTRY);
    }

    private static void emitCodeBody(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        AArch64HotSpotBackend.emitInvalidatePlaceholder(crb, masm);
        crb.emitLIR();
    }

    public static void emitInvalidatePlaceholder(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        crb.blockComment("[nop for method invalidation]");
        masm.nop();
    }

    private void emitCodeSuffix(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        HotSpotProviders providers = this.getProviders();
        HotSpotFrameContext frameContext = (HotSpotFrameContext)crb.frameContext;
        if (!frameContext.isStub) {
            Register scratch;
            AArch64MacroAssembler.ScratchRegister sc;
            HotSpotHostForeignCallsProvider foreignCalls = providers.getForeignCalls();
            if (crb.getPendingImplicitExceptionList() != null) {
                sc = masm.getScratchRegister();
                try {
                    scratch = sc.getRegister();
                    for (CompilationResultBuilder.PendingImplicitException pendingImplicitException : crb.getPendingImplicitExceptionList()) {
                        int pos = masm.position();
                        Register thread = this.getProviders().getRegisters().getThreadRegister();
                        int dwordSizeInBits = AArch64Kind.DWORD.getSizeInBytes() * 8;
                        AArch64Address pendingDeoptimization = AArch64Address.createImmediateAddress(dwordSizeInBits, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, thread, this.config.pendingDeoptimizationOffset);
                        masm.mov(scratch, pendingImplicitException.state.deoptReasonAndAction.asInt());
                        masm.str(dwordSizeInBits, scratch, pendingDeoptimization);
                        JavaConstant deoptSpeculation = pendingImplicitException.state.deoptSpeculation;
                        if (deoptSpeculation.getJavaKind() == JavaKind.Long) {
                            int qwordSizeInBits = AArch64Kind.QWORD.getSizeInBytes() * 8;
                            AArch64Address pendingSpeculation = AArch64Address.createImmediateAddress(qwordSizeInBits, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, thread, this.config.pendingFailedSpeculationOffset);
                            masm.mov(scratch, pendingImplicitException.state.deoptSpeculation.asLong());
                            masm.str(qwordSizeInBits, scratch, pendingSpeculation);
                        } else {
                            assert (deoptSpeculation.getJavaKind() == JavaKind.Int) : deoptSpeculation;
                            AArch64Address pendingSpeculation = AArch64Address.createImmediateAddress(dwordSizeInBits, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, thread, this.config.pendingFailedSpeculationOffset);
                            masm.mov(scratch, pendingImplicitException.state.deoptSpeculation.asInt());
                            masm.str(dwordSizeInBits, scratch, pendingSpeculation);
                        }
                        ForeignCallLinkage uncommonTrapBlob = foreignCalls.lookupForeignCall(DEOPT_BLOB_UNCOMMON_TRAP);
                        Register helper = AArch64Call.isNearCall(uncommonTrapBlob) ? null : scratch;
                        AArch64Call.directCall(crb, masm, uncommonTrapBlob, helper, pendingImplicitException.state);
                        crb.recordImplicitException(pendingImplicitException.codeOffset, pos, pendingImplicitException.state);
                    }
                }
                finally {
                    if (sc != null) {
                        sc.close();
                    }
                }
            }
            sc = masm.getScratchRegister();
            try {
                scratch = sc.getRegister();
                crb.recordMark(HotSpotMarkId.EXCEPTION_HANDLER_ENTRY);
                ForeignCallLinkage linkage = foreignCalls.lookupForeignCall(EXCEPTION_HANDLER);
                Register helper = AArch64Call.isNearCall(linkage) ? null : scratch;
                AArch64Call.directCall(crb, masm, linkage, helper, null);
                masm.halt();
            }
            finally {
                if (sc != null) {
                    sc.close();
                }
            }
            crb.recordMark(HotSpotMarkId.DEOPT_HANDLER_ENTRY);
            ForeignCallLinkage linkage = foreignCalls.lookupForeignCall(DEOPT_BLOB_UNPACK);
            masm.adr(AArch64.lr, 0);
            AArch64Call.directJmp(crb, masm, linkage);
            if (this.config.supportsMethodHandleDeoptimizationEntry() && crb.needsMHDeoptHandler()) {
                crb.recordMark(HotSpotMarkId.DEOPT_MH_HANDLER_ENTRY);
                masm.adr(AArch64.lr, 0);
                AArch64Call.directJmp(crb, masm, linkage);
            }
        }
    }

    @Override
    public RegisterAllocationConfig newRegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo, Object stub) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        return new AArch64HotSpotRegisterAllocationConfig(registerConfigNonNull, allocationRestrictedTo, this.config.preserveFramePointer(stub != null));
    }

    public class HotSpotFrameContext
    implements FrameContext {
        final boolean isStub;
        private final EntryPointDecorator entryPointDecorator;

        HotSpotFrameContext(boolean isStub, EntryPointDecorator entryPointDecorator) {
            this.isStub = isStub;
            this.entryPointDecorator = entryPointDecorator;
        }

        @Override
        public void enter(CompilationResultBuilder crb) {
            FrameMap frameMap = crb.frameMap;
            AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
            if (!this.isStub) {
                AArch64HotSpotBackend.this.emitStackOverflowCheck(crb);
            }
            crb.blockComment("[method prologue]");
            AArch64HotSpotBackend.rawEnter(crb, frameMap, masm, AArch64HotSpotBackend.this.config, this.isStub);
            crb.recordMark(HotSpotMarkId.FRAME_COMPLETE);
            if (!this.isStub && ((AArch64HotSpotBackend)AArch64HotSpotBackend.this).config.nmethodEntryBarrier != 0L) {
                this.emitNmethodEntryBarrier(crb, masm);
            }
            if (this.entryPointDecorator != null) {
                this.entryPointDecorator.emitEntryPoint(crb, false);
            }
            if (GraalOptions.ZapStackOnMethodEntry.getValue(crb.getOptions()).booleanValue()) {
                try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                    Register scratch = sc.getRegister();
                    int longSize = 8;
                    masm.mov(64, scratch, AArch64.sp);
                    AArch64Address address = AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, scratch, longSize);
                    try (AArch64MacroAssembler.ScratchRegister sc2 = masm.getScratchRegister();){
                        Register value = sc2.getRegister();
                        masm.mov(value, 841573668843749358L);
                        for (int i = 0; i < frameMap.frameSize(); i += longSize) {
                            masm.str(64, value, address);
                        }
                    }
                }
            }
            crb.blockComment("[code body]");
        }

        private void emitNmethodEntryBarrier(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();
                 AArch64MacroAssembler.ScratchRegister sc2 = masm.getScratchRegister();){
                Register scratch1 = sc.getRegister();
                Register scratch2 = sc2.getRegister();
                GraalError.guarantee(HotSpotMarkId.ENTRY_BARRIER_PATCH.isAvailable(), "must be available");
                ForeignCallLinkage callTarget = AArch64HotSpotBackend.this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.NMETHOD_ENTRY_BARRIER);
                Register thread = AArch64HotSpotBackend.this.getProviders().getRegisters().getThreadRegister();
                Label continuation = new Label();
                Label entryPoint = new Label();
                crb.recordMark(HotSpotMarkId.ENTRY_BARRIER_PATCH);
                DataSection.Data data = crb.dataBuilder.createMutableData(4, 4);
                masm.ldr(32, scratch1, (AArch64Address)crb.recordDataSectionReference(data));
                if (((AArch64HotSpotBackend)AArch64HotSpotBackend.this).config.BarrierSetAssembler_nmethod_patching_type == ((AArch64HotSpotBackend)AArch64HotSpotBackend.this).config.NMethodPatchingType_conc_instruction_and_data_patch) {
                    masm.mov(scratch2, ((AArch64HotSpotBackend)AArch64HotSpotBackend.this).config.BarrierSetAssembler_patching_epoch_addr);
                    masm.orr(64, scratch2, scratch2, scratch1, AArch64Assembler.ShiftType.LSR, 32);
                    masm.ldr(32, scratch2, AArch64Address.createBaseRegisterOnlyAddress(32, scratch2));
                    masm.orr(64, scratch1, scratch1, scratch2, AArch64Assembler.ShiftType.LSL, 32);
                    AArch64Address threadDisarmedAndEpochAddr = masm.makeAddress(64, thread, ((AArch64HotSpotBackend)AArch64HotSpotBackend.this).config.threadDisarmedOffset, scratch2);
                    masm.ldr(64, scratch2, threadDisarmedAndEpochAddr);
                    masm.cmp(64, scratch1, scratch2);
                } else {
                    if (((AArch64HotSpotBackend)AArch64HotSpotBackend.this).config.BarrierSetAssembler_nmethod_patching_type == ((AArch64HotSpotBackend)AArch64HotSpotBackend.this).config.NMethodPatchingType_conc_data_patch) {
                        masm.dmb(AArch64Assembler.BarrierKind.LOAD_ANY);
                    }
                    AArch64Address threadDisarmedAddr = masm.makeAddress(32, thread, ((AArch64HotSpotBackend)AArch64HotSpotBackend.this).config.threadDisarmedOffset, scratch2);
                    masm.ldr(32, scratch2, threadDisarmedAddr);
                    masm.cmp(32, scratch1, scratch2);
                }
                masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, entryPoint);
                crb.getLIR().addSlowPath(null, () -> {
                    masm.bind(entryPoint);
                    int beforeCall = masm.position();
                    if (AArch64Call.isNearCall(callTarget)) {
                        masm.bl();
                    } else {
                        masm.movNativeAddress(scratch1, 0L, true);
                        masm.blr(scratch1);
                    }
                    crb.recordDirectCall(beforeCall, masm.position(), callTarget, null);
                    masm.jmp(continuation);
                });
                masm.bind(continuation);
            }
        }

        @Override
        public void leave(CompilationResultBuilder crb) {
            crb.blockComment("[method epilogue]");
            AArch64HotSpotBackend.this.rawLeave(crb);
        }

        @Override
        public void returned(CompilationResultBuilder crb) {
        }
    }
}

