/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.lir.gen.WriteBarrierSetLIRGeneratorTool;

public interface ZWriteBarrierSetLIRGeneratorTool
extends WriteBarrierSetLIRGeneratorTool {
    public static final int UNPATCHED = 0;

    public ForeignCallsProvider getForeignCalls();

    default public ForeignCallLinkage getReadBarrierStub(BarrierType barrierType) {
        return switch (barrierType) {
            case BarrierType.READ -> this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_LOAD_BARRIER);
            case BarrierType.REFERENCE_GET -> this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_REFERENCE_GET_BARRIER);
            case BarrierType.WEAK_REFERS_TO -> this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_WEAK_REFERS_TO_BARRIER);
            case BarrierType.PHANTOM_REFERS_TO -> this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_PHANTOM_REFERS_TO_BARRIER);
            default -> throw GraalError.shouldNotReachHere("Unexpected barrier type: " + String.valueOf((Object)barrierType));
        };
    }

    default public ForeignCallLinkage getWriteBarrierStub(BarrierType barrierType, StoreKind storeKind) {
        return switch (barrierType) {
            case BarrierType.FIELD, BarrierType.ARRAY, BarrierType.POST_INIT_WRITE -> {
                if (storeKind == StoreKind.Atomic) {
                    yield this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_STORE_BARRIER_WITH_HEALING);
                }
                if (storeKind == StoreKind.Native) {
                    yield this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_STORE_BARRIER_NATIVE);
                }
                yield this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_STORE_BARRIER_WITHOUT_HEALING);
            }
            case BarrierType.AS_NO_KEEPALIVE_WRITE -> this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_REFERENCE_CLEAR_BARRIER);
            default -> throw GraalError.shouldNotReachHere("Unexpected barrier type: " + String.valueOf((Object)barrierType));
        };
    }

    public static enum StoreKind {
        Normal,
        Atomic,
        Native;

    }
}

