/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import jdk.graal.compiler.util.SignatureUtil;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.UnresolvedJavaType;

public final class SnippetSignature
implements Signature {
    private final List<String> parameters;
    private final String returnType;
    private final String originalString;
    @NativeImageReinitialize
    private static EnumMap<JavaKind, ResolvedJavaType> primitiveTypes = null;

    static synchronized void initPrimitiveKindCache(MetaAccessProvider metaAccess) {
        if (primitiveTypes == null) {
            EnumMap<JavaKind, ResolvedJavaType> types = new EnumMap<JavaKind, ResolvedJavaType>(JavaKind.class);
            for (JavaKind kind : JavaKind.values()) {
                if (!kind.isPrimitive()) continue;
                types.put(kind, metaAccess.lookupJavaType(kind.toJavaClass()));
            }
            primitiveTypes = types;
        }
    }

    public SnippetSignature(String signature) {
        ArrayList<String> buffer = new ArrayList<String>();
        this.returnType = SignatureUtil.parseSignature(signature, buffer);
        this.parameters = List.copyOf(buffer);
        this.originalString = signature;
    }

    public int getParameterCount(boolean withReceiver) {
        return this.parameters.size() + (withReceiver ? 1 : 0);
    }

    public JavaKind getParameterKind(int index) {
        return JavaKind.fromTypeString((String)this.parameters.get(index));
    }

    private static JavaType getUnresolvedOrPrimitiveType(String name) {
        if (name.length() == 1) {
            JavaKind kind = JavaKind.fromPrimitiveOrVoidTypeChar((char)name.charAt(0));
            return (JavaType)primitiveTypes.get(kind);
        }
        return UnresolvedJavaType.create((String)name);
    }

    public JavaType getParameterType(int index, ResolvedJavaType accessingClass) {
        if (accessingClass == null) {
            return SnippetSignature.getUnresolvedOrPrimitiveType(this.parameters.get(index));
        }
        throw new NoClassDefFoundError("dynamic resolution unsupported: " + this.parameters.get(index));
    }

    public String toMethodDescriptor() {
        return this.originalString;
    }

    public JavaKind getReturnKind() {
        return JavaKind.fromTypeString((String)this.returnType);
    }

    public JavaType getReturnType(ResolvedJavaType accessingClass) {
        if (accessingClass == null) {
            return SnippetSignature.getUnresolvedOrPrimitiveType(this.returnType);
        }
        throw new NoClassDefFoundError("dynamic resolution unsupported: " + this.returnType);
    }

    public String toString() {
        return "SnippetSignature<" + this.originalString + ">";
    }

    public boolean equals(Object obj) {
        if (obj instanceof SnippetSignature) {
            SnippetSignature other = (SnippetSignature)obj;
            if (other.originalString.equals(this.originalString)) {
                assert (other.parameters.equals(this.parameters));
                assert (other.returnType.equals(this.returnType));
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.originalString.hashCode();
    }
}

