/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.gc.ZBarrierSet;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;

public class HotSpotZBarrierSet
extends ZBarrierSet {
    public HotSpotZBarrierSet(ResolvedJavaType objectArrayType, ResolvedJavaField referentField) {
        super(objectArrayType, referentField);
    }

    @Override
    protected BarrierType barrierForLocation(BarrierType currentBarrier, LocationIdentity location, JavaKind storageKind) {
        if (location instanceof HotSpotReplacementsUtil.OopHandleLocationIdentity) {
            return BarrierType.READ;
        }
        return super.barrierForLocation(currentBarrier, location, storageKind);
    }

    @Override
    public BarrierType readBarrierType(LocationIdentity location, ValueNode address, Stamp loadStamp) {
        if (location instanceof HotSpotReplacementsUtil.OopHandleLocationIdentity) {
            assert (loadStamp instanceof AbstractObjectStamp) : loadStamp;
            return BarrierType.READ;
        }
        return super.readBarrierType(location, address, loadStamp);
    }

    @Override
    public BarrierType writeBarrierType(LocationIdentity location) {
        if (location instanceof HotSpotReplacementsUtil.OopHandleLocationIdentity) {
            return BarrierType.FIELD;
        }
        return BarrierType.NONE;
    }
}

