/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.util.BitSet;
import jdk.graal.compiler.bytecode.Bytecode;
import jdk.graal.compiler.bytecode.BytecodeProvider;
import jdk.graal.compiler.bytecode.ResolvedJavaMethodBytecode;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.hotspot.CompilationContext;
import jdk.graal.compiler.hotspot.EncodedSnippets;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotBytecodeParser;
import jdk.graal.compiler.hotspot.HotSpotGraalServices;
import jdk.graal.compiler.hotspot.HotSpotGraphBuilderInstance;
import jdk.graal.compiler.hotspot.SymbolicSnippetEncoder;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.meta.HotSpotWordOperationPlugin;
import jdk.graal.compiler.hotspot.word.HotSpotOperation;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.SnippetParameterInfo;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import jdk.graal.compiler.replacements.IntrinsicGraphBuilder;
import jdk.graal.compiler.replacements.ReplacementsImpl;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.nativeimage.ImageInfo;

public class HotSpotReplacementsImpl
extends ReplacementsImpl {
    @NativeImageReinitialize
    private EconomicSet<ResolvedJavaMethod> registeredSnippets = EconomicSet.create();
    private boolean snippetRegistrationClosed;
    private static volatile EncodedSnippets encodedSnippets;
    @NativeImageReinitialize
    private static SymbolicSnippetEncoder snippetEncoder;

    public HotSpotReplacementsImpl(HotSpotProviders providers, BytecodeProvider bytecodeProvider, TargetDescription target) {
        super(new GraalDebugHandlersFactory(providers.getSnippetReflection()), providers, bytecodeProvider, target);
    }

    HotSpotReplacementsImpl(HotSpotReplacementsImpl replacements, HotSpotProviders providers) {
        super(new GraalDebugHandlersFactory(replacements.getProviders().getSnippetReflection()), providers, replacements.getDefaultReplacementBytecodeProvider(), replacements.target);
    }

    @Override
    public HotSpotProviders getProviders() {
        return (HotSpotProviders)super.getProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SymbolicSnippetEncoder maybeInitializeEncoder() {
        if (ImageInfo.inImageRuntimeCode()) {
            return null;
        }
        if (!ImageInfo.inImageBuildtimeCode()) return snippetEncoder;
        Class<HotSpotReplacementsImpl> clazz = HotSpotReplacementsImpl.class;
        synchronized (HotSpotReplacementsImpl.class) {
            if (snippetEncoder != null) return snippetEncoder;
            snippetEncoder = new SymbolicSnippetEncoder(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return snippetEncoder;
        }
    }

    @Override
    public Class<? extends GraphBuilderPlugin> getIntrinsifyingPlugin(ResolvedJavaMethod method) {
        if (!ImageInfo.inImageRuntimeCode() && method.getAnnotation(HotSpotOperation.class) != null) {
            return HotSpotWordOperationPlugin.class;
        }
        return super.getIntrinsifyingPlugin(method);
    }

    @Override
    public void registerConditionalPlugin(InvocationPlugin plugin) {
        if (!ImageInfo.inImageRuntimeCode() && snippetEncoder != null) {
            snippetEncoder.registerConditionalPlugin(plugin);
        }
    }

    @Override
    public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod method, Invoke invoke) {
        if (!ImageInfo.inImageRuntimeCode() && b.parsingIntrinsic() && snippetEncoder != null && this.getIntrinsifyingPlugin(method) != null) {
            snippetEncoder.addDelayedInvocationPluginMethod(method);
            return;
        }
        super.notifyNotInlined(b, method, invoke);
    }

    @Override
    public boolean hasSubstitution(ResolvedJavaMethod method, OptionValues options) {
        InvocationPlugin plugin = this.graphBuilderPlugins.getInvocationPlugins().lookupInvocation(method, options);
        return plugin != null;
    }

    @Override
    public StructuredGraph getInlineSubstitution(ResolvedJavaMethod method, int invokeBci, boolean isInOOMETry, Invoke.InlineControl inlineControl, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, StructuredGraph.AllowAssumptions allowAssumptions, OptionValues options) {
        StructuredGraph result;
        assert (invokeBci >= 0) : method;
        if (!inlineControl.allowSubstitution()) {
            return null;
        }
        InvocationPlugin plugin = this.graphBuilderPlugins.getInvocationPlugins().lookupInvocation(method, options);
        if (plugin != null) {
            ResolvedJavaMethodBytecode code = new ResolvedJavaMethodBytecode(method);
            try (DebugContext debug = this.openSnippetDebugContext("Substitution_", method, options);){
                result = new HotSpotIntrinsicGraphBuilder(options, debug, (CoreProviders)this.providers, (Bytecode)code, invokeBci, allowAssumptions, isInOOMETry).buildGraph(plugin);
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public void registerSnippet(ResolvedJavaMethod method, ResolvedJavaMethod original, Object receiver, boolean trackNodeSourcePosition, OptionValues options) {
        assert (method.isStatic() || receiver != null) : "must have a constant type for the receiver";
        if (!ImageInfo.inImageRuntimeCode()) {
            assert (!this.snippetRegistrationClosed || System.getProperty("GraalUnitTest") != null) : "Cannot register snippet after registration is closed: " + method.format("%H.%n(%p)");
            if (this.registeredSnippets.add((Object)method) && ImageInfo.inImageBuildtimeCode()) {
                snippetEncoder.registerSnippet(method, original, receiver, trackNodeSourcePosition);
            }
        }
    }

    @Override
    public SnippetParameterInfo getSnippetParameterInfo(ResolvedJavaMethod method) {
        if (ImageInfo.inImageRuntimeCode()) {
            return HotSpotReplacementsImpl.getEncodedSnippets().getSnippetParameterInfo(method);
        }
        return super.getSnippetParameterInfo(method);
    }

    @Override
    public boolean isSnippet(ResolvedJavaMethod method) {
        if (ImageInfo.inImageRuntimeCode()) {
            return HotSpotReplacementsImpl.getEncodedSnippets().isSnippet(method);
        }
        return super.isSnippet(method);
    }

    @Override
    public void closeSnippetRegistration() {
        this.snippetRegistrationClosed = true;
    }

    public static EncodedSnippets getEncodedSnippets() {
        if (encodedSnippets == null) {
            throw GraalError.shouldNotReachHere("encoded snippets not found");
        }
        return encodedSnippets;
    }

    public static boolean snippetsAreEncoded() {
        return encodedSnippets != null;
    }

    public void clearSnippetParameterNames() {
        assert (snippetEncoder != null);
        snippetEncoder.clearSnippetParameterNames();
    }

    public static void setEncodedSnippets(EncodedSnippets encodedSnippets) {
        HotSpotReplacementsImpl.encodedSnippets = encodedSnippets;
    }

    public boolean encode(OptionValues options) {
        SymbolicSnippetEncoder encoder = snippetEncoder;
        if (encoder != null) {
            return encoder.encode(options);
        }
        return false;
    }

    @Override
    public StructuredGraph getSnippet(ResolvedJavaMethod method, ResolvedJavaMethod original, Object[] args, BitSet nonNullParameters, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, OptionValues options) {
        if (ImageInfo.inImageRuntimeCode()) {
            try (CompilationContext scope = HotSpotGraalServices.enterGlobalCompilationContext();){
                StructuredGraph graph = HotSpotReplacementsImpl.getEncodedSnippets().getEncodedSnippet(method, original, this, args, StructuredGraph.AllowAssumptions.NO, options);
                if (graph == null) {
                    throw GraalError.shouldNotReachHere("snippet not found: " + method.format("%H.%n(%p)"));
                }
                StructuredGraph structuredGraph = graph;
                return structuredGraph;
            }
        }
        assert (this.registeredSnippets == null || this.registeredSnippets.contains((Object)method)) : "Asking for snippet method that was never registered: " + method.format("%H.%n(%p)");
        return super.getSnippet(method, original, args, nonNullParameters, trackNodeSourcePosition, replaceePosition, options);
    }

    @Override
    public <T> T getInjectedArgument(Class<T> capability) {
        if (capability.equals(GraalHotSpotVMConfig.class)) {
            return (T)this.getProviders().getConfig();
        }
        return super.getInjectedArgument(capability);
    }

    public ResolvedJavaMethod findSnippetMethod(ResolvedJavaMethod thisMethod) {
        if (snippetEncoder == null) {
            throw new GraalError("findSnippetMethod called before initialization of Replacements");
        }
        return snippetEncoder.findSnippetMethod(thisMethod);
    }

    public static MetaAccessProvider noticeTypes(MetaAccessProvider metaAccess) {
        if (ImageInfo.inImageBuildtimeCode()) {
            return SymbolicSnippetEncoder.noticeTypes(metaAccess);
        }
        return metaAccess;
    }

    static boolean isGraalClass(ResolvedJavaType type) {
        return HotSpotReplacementsImpl.isGraalClass(type.toClassName());
    }

    static boolean isGraalClass(Class<?> clazz) {
        return HotSpotReplacementsImpl.isGraalClass(clazz.getName());
    }

    static boolean isGraalClass(String className) {
        String elementClassName;
        if (className.charAt(0) == '[') {
            elementClassName = className;
            while (elementClassName.charAt(0) == '[') {
                elementClassName = elementClassName.substring(1);
            }
            if (elementClassName.charAt(0) != 'L') {
                return false;
            }
            elementClassName = elementClassName.substring(1, elementClassName.length() - 1);
        } else {
            elementClassName = className;
        }
        return elementClassName.startsWith("jdk.vm.ci.") || elementClassName.startsWith("jdk.graal.compiler.") || elementClassName.startsWith("org.graalvm.") || elementClassName.startsWith("com.oracle.graal.");
    }

    @Override
    protected ReplacementsImpl.GraphMaker createGraphMaker(ResolvedJavaMethod substitute, ResolvedJavaMethod original) {
        return new HotSpotGraphMaker(this, substitute, original);
    }

    public static class HotSpotIntrinsicGraphBuilder
    extends IntrinsicGraphBuilder {
        private final boolean isInOOMETry;

        public HotSpotIntrinsicGraphBuilder(OptionValues options, DebugContext debug, CoreProviders providers, Bytecode code, int invokeBci, StructuredGraph.AllowAssumptions allowAssumptions, boolean isInOOMETry) {
            super(options, debug, providers, code, invokeBci, allowAssumptions);
            this.isInOOMETry = isInOOMETry;
        }

        public HotSpotIntrinsicGraphBuilder(OptionValues options, DebugContext debug, CoreProviders providers, Bytecode code, int invokeBci, StructuredGraph.AllowAssumptions allowAssumptions, GraphBuilderConfiguration graphBuilderConfig) {
            super(options, debug, providers, code, invokeBci, allowAssumptions, graphBuilderConfig);
            this.isInOOMETry = false;
        }

        @Override
        public GuardingNode intrinsicRangeCheck(LogicNode condition, boolean negated) {
            return HotSpotBytecodeParser.doIntrinsicRangeCheck(this, condition, negated);
        }

        @Override
        public boolean currentBlockCatchesOOME() {
            return this.isInOOMETry;
        }
    }

    static class HotSpotGraphMaker
    extends ReplacementsImpl.GraphMaker {
        HotSpotGraphMaker(ReplacementsImpl replacements, ResolvedJavaMethod substitute, ResolvedJavaMethod substitutedMethod) {
            super(replacements, substitute, substitutedMethod);
        }

        @Override
        protected GraphBuilderPhase.Instance createGraphBuilder(Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
            return new HotSpotGraphBuilderInstance(providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        }
    }
}

