/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntime;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotVMEventListener;

public class HotSpotGraalVMEventListener
implements HotSpotVMEventListener {
    private HotSpotGraalRuntime runtime;

    HotSpotGraalVMEventListener(HotSpotGraalRuntime runtime) {
        this.setRuntime(runtime);
    }

    void setRuntime(HotSpotGraalRuntime runtime) {
        assert (this.runtime == null || this.runtime == runtime) : runtime;
        this.runtime = runtime;
    }

    public void notifyShutdown() {
        if (this.runtime != null) {
            this.runtime.shutdown();
        }
    }

    public void notifyInstall(HotSpotCodeCacheProvider codeCache, InstalledCode installedCode, CompiledCode compiledCode) {
        DebugContext debug = DebugContext.forCurrentThread();
        if (debug.isDumpEnabled(1)) {
            CompilationResult compResult = debug.contextLookup(CompilationResult.class);
            assert (compResult != null) : "can't dump installed code properly without CompilationResult";
            debug.dump(1, installedCode, "After code installation");
        }
        if (debug.isLogEnabled()) {
            debug.log("%s", (Object)codeCache.disassemble(installedCode));
        }
    }

    public void notifyBootstrapFinished() {
        this.runtime.notifyBootstrapFinished();
        if (DebugOptions.ClearMetricsAfterBootstrap.getValue(this.runtime.getOptions()).booleanValue()) {
            this.runtime.clearMetrics();
        }
    }
}

