/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.Objects;
import jdk.graal.compiler.hotspot.CompilationContext;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstantScope;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.hotspot.VMIntrinsicMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.nativeimage.ImageInfo;

public class HotSpotGraalServices {
    private static final Method methodGetOopMapAt;

    public static boolean hasGetOopMapAt() {
        return methodGetOopMapAt != null;
    }

    public static BitSet getOopMapAt(ResolvedJavaMethod method, int bci) {
        if (methodGetOopMapAt != null) {
            try {
                try {
                    return (BitSet)methodGetOopMapAt.invoke((Object)method, bci);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        }
        throw new InternalError("This JDK doesn't support ResolvedJavaMethod.getOopMapAt(int, BitSet)");
    }

    public static CompilationContext enterGlobalCompilationContext() {
        HotSpotObjectConstantScope impl = HotSpotObjectConstantScope.enterGlobalScope();
        return impl == null ? null : new CompilationContext((AutoCloseable)impl);
    }

    public static CompilationContext openLocalCompilationContext(Object description) {
        HotSpotObjectConstantScope impl = HotSpotObjectConstantScope.openLocalScope((Object)Objects.requireNonNull(description));
        return impl == null ? null : new CompilationContext((AutoCloseable)impl);
    }

    public static void exit(int status, HotSpotJVMCIRuntime runtime) {
        if (ImageInfo.inImageRuntimeCode()) {
            runtime.exitHotSpot(status);
        } else {
            System.exit(status);
        }
    }

    public static SpeculationLog newHotSpotSpeculationLog(long cachedFailedSpeculationsAddress) {
        return new HotSpotSpeculationLog(cachedFailedSpeculationsAddress);
    }

    public static boolean isIntrinsicAvailable(VMIntrinsicMethod intrinsic) {
        try {
            Field isAvailable = VMIntrinsicMethod.class.getField("isAvailable");
            return isAvailable.getBoolean(intrinsic);
        }
        catch (ReflectiveOperationException e) {
            return true;
        }
    }

    public static boolean isIntrinsicSupportedByC2(VMIntrinsicMethod intrinsic) {
        try {
            Field c2Supported = VMIntrinsicMethod.class.getField("c2Supported");
            return c2Supported.getBoolean(intrinsic);
        }
        catch (ReflectiveOperationException e) {
            return true;
        }
    }

    static {
        Method getOopMapAt = null;
        try {
            getOopMapAt = HotSpotResolvedJavaMethod.class.getDeclaredMethod("getOopMapAt", Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        methodGetOopMapAt = getOopMapAt;
    }
}

