/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jdk.graal.compiler.hotspot.HotSpotGraalCompiler;
import jdk.graal.compiler.hotspot.HotSpotGraalCompilerFactory;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.options.OptionsParser;
import jdk.graal.compiler.serviceprovider.GlobalAtomicLong;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.common.NativeImageReinitialize;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public class HotSpotGraalOptionValues {
    private static final String UNSUPPORTED_GRAAL_OPTIONS_FILE_PROPERTY_NAME = "jdk.graal.options.file";
    public static final String GRAAL_OPTION_PROPERTY_PREFIX = "jdk.graal.";
    public static final String LEGACY_GRAAL_OPTION_PROPERTY_PREFIX = "graal.";
    public static final String LIBGRAAL_VM_OPTION_PROPERTY_PREFIX = "jdk.graal.internal.";
    private static final Set<String> UNSUPPORTED_LIBGRAAL_PREFIXES = Set.of("jdk.libgraal.", "libgraal.");
    private static final GlobalAtomicLong LEGACY_OPTION_DEPRECATION_WARNED = new GlobalAtomicLong(0L);
    @NativeImageReinitialize
    private static volatile OptionValues hotspotOptions;

    public static String asSystemPropertySetting(OptionValues options, OptionKey<?> value) {
        return GRAAL_OPTION_PROPERTY_PREFIX + value.getName() + "=" + String.valueOf(value.getValue(options));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OptionValues defaultOptions() {
        OptionValues res = hotspotOptions;
        if (res != null) return res;
        Class<HotSpotGraalOptionValues> clazz = HotSpotGraalOptionValues.class;
        synchronized (HotSpotGraalOptionValues.class) {
            res = hotspotOptions;
            if (res != null) return res;
            hotspotOptions = res = HotSpotGraalOptionValues.initializeOptions();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return res;
        }
    }

    public static EconomicMap<OptionKey<?>, Object> parseOptions() {
        EconomicMap<OptionKey<?>, Object> compilerOptionValues = OptionValues.newOptionMap();
        try (InitTimer t = InitTimer.timer((String)"InitializeOptions");){
            Iterable<OptionDescriptors> descriptors = OptionsParser.getOptionsLoader();
            Map<String, String> savedProps = GraalServices.getSavedProperties();
            EconomicMap compilerOptionSettings = EconomicMap.create();
            HashMap<String, String> vmOptionSettings = new HashMap<String, String>();
            for (Map.Entry<String, String> e : savedProps.entrySet()) {
                Object name = e.getKey();
                if (((String)name).startsWith(LEGACY_GRAAL_OPTION_PROPERTY_PREFIX)) {
                    String baseName = ((String)name).substring(LEGACY_GRAAL_OPTION_PROPERTY_PREFIX.length());
                    name = GRAAL_OPTION_PROPERTY_PREFIX + baseName;
                    if (LEGACY_OPTION_DEPRECATION_WARNED.compareAndSet(0L, 1L)) {
                        System.err.printf("WARNING: The 'graal.' property prefix for the Graal option %s\nWARNING: (and all other Graal options) is deprecated and will be ignored\nWARNING: in a future release. Please use 'jdk.graal.%s' instead.%n", baseName, baseName);
                    }
                }
                if (((String)name).startsWith(GRAAL_OPTION_PROPERTY_PREFIX)) {
                    if (((String)name).startsWith(LIBGRAAL_VM_OPTION_PROPERTY_PREFIX)) {
                        vmOptionSettings.put(HotSpotGraalOptionValues.stripPrefix((String)name, LIBGRAAL_VM_OPTION_PROPERTY_PREFIX), e.getValue());
                        continue;
                    }
                    if (((String)name).equals(UNSUPPORTED_GRAAL_OPTIONS_FILE_PROPERTY_NAME)) {
                        String msg = String.format("The '%s' property is no longer supported.", UNSUPPORTED_GRAAL_OPTIONS_FILE_PROPERTY_NAME);
                        throw new IllegalArgumentException(msg);
                    }
                    String value = e.getValue();
                    compilerOptionSettings.put((Object)HotSpotGraalOptionValues.stripPrefix((String)name, GRAAL_OPTION_PROPERTY_PREFIX), (Object)value);
                    continue;
                }
                for (String prefix : UNSUPPORTED_LIBGRAAL_PREFIXES) {
                    if (!((String)name).startsWith(prefix)) continue;
                    String baseName = ((String)name).substring(prefix.length());
                    String msg = String.format("The '%s' property prefix is no longer supported. Use %s%s instead of %s%s.", prefix, LIBGRAAL_VM_OPTION_PROPERTY_PREFIX, baseName, prefix, baseName);
                    throw new IllegalArgumentException(msg);
                }
            }
            if (!vmOptionSettings.isEmpty()) {
                HotSpotGraalOptionValues.notifyLibgraalOptions(vmOptionSettings);
            }
            OptionsParser.parseOptions((EconomicMap<String, String>)compilerOptionSettings, compilerOptionValues, descriptors);
            Iterator<Map.Entry<String, String>> iterator = compilerOptionValues;
            return iterator;
        }
    }

    private static String stripPrefix(String name, String prefix) {
        String baseName = name.substring(prefix.length());
        if (baseName.isEmpty()) {
            throw new IllegalArgumentException("Option name must follow '" + prefix + "' prefix");
        }
        return baseName;
    }

    private static void notifyLibgraalOptions(Map<String, String> settings) {
        System.err.printf("WARNING: Ignoring the following libgraal VM option(s) while executing jargraal: %s%n", String.join((CharSequence)", ", settings.keySet()));
    }

    private static OptionValues initializeOptions() {
        EconomicMap<OptionKey<?>, Object> values = HotSpotGraalOptionValues.parseOptions();
        OptionValues options = new OptionValues((UnmodifiableEconomicMap<OptionKey<?>, Object>)values);
        if (HotSpotGraalCompiler.Options.CrashAtThrowsOOME.getValue(options).booleanValue() && HotSpotGraalCompiler.Options.CrashAtIsFatal.getValue(options) != 0) {
            throw new IllegalArgumentException("CrashAtThrowsOOME and CrashAtIsFatal cannot both be enabled");
        }
        return options;
    }

    static void printProperties(OptionValues compilerOptions, PrintStream out) {
        boolean all = HotSpotGraalCompilerFactory.Options.PrintPropertiesAll.getValue(compilerOptions);
        compilerOptions.printHelp(OptionsParser.getOptionsLoader(), out, GRAAL_OPTION_PROPERTY_PREFIX, all);
        if (all) {
            HotSpotGraalOptionValues.printLibgraalProperties(out, LIBGRAAL_VM_OPTION_PROPERTY_PREFIX);
        }
    }

    private static void printLibgraalProperties(PrintStream out, String prefix) {
    }
}

