/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.io.PrintStream;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.MethodFilter;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.hotspot.CompilerConfigurationFactory;
import jdk.graal.compiler.hotspot.HotSpotGraalCompiler;
import jdk.graal.compiler.hotspot.HotSpotGraalJVMCIServiceLocator;
import jdk.graal.compiler.hotspot.HotSpotGraalOptionValues;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntime;
import jdk.graal.compiler.hotspot.HotSpotGraalServices;
import jdk.graal.compiler.hotspot.IsGraalPredicate;
import jdk.graal.compiler.hotspot.JVMCIVersionCheck;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotVMConfigAccess;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.runtime.JVMCICompilerFactory;
import jdk.vm.ci.runtime.JVMCIRuntime;
import jdk.vm.ci.services.Services;
import org.graalvm.nativeimage.ImageInfo;

public final class HotSpotGraalCompilerFactory
implements JVMCICompilerFactory {
    private static MethodFilter graalCompileOnlyFilter;
    private static boolean compileGraalWithC1Only;
    private IsGraalPredicate isGraalPredicate;
    private final HotSpotGraalJVMCIServiceLocator locator;
    private OptionValues options;
    private IllegalArgumentException optionsFailure;
    private volatile boolean initialized;

    HotSpotGraalCompilerFactory(HotSpotGraalJVMCIServiceLocator locator) {
        this.locator = locator;
    }

    public String getCompilerName() {
        return "graal";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        if (!this.initialized) {
            HotSpotGraalCompilerFactory hotSpotGraalCompilerFactory = this;
            synchronized (hotSpotGraalCompilerFactory) {
                if (!this.initialized) {
                    this.initialize();
                    this.initialized = true;
                }
            }
        }
    }

    public void onSelection() {
        if (ImageInfo.inImageRuntimeCode()) {
            this.initialize();
            this.initialized = true;
        }
    }

    private void initialize() {
        JVMCIVersionCheck.check(GraalServices.getSavedProperties(), false, null);
        assert (this.options == null) : "cannot select " + String.valueOf(this.getClass()) + " service more than once";
        try {
            this.options = HotSpotGraalOptionValues.defaultOptions();
        }
        catch (IllegalArgumentException e) {
            this.optionsFailure = e;
            return;
        }
        HotSpotGraalCompilerFactory.initializeGraalCompilePolicyFields(this.options);
        this.isGraalPredicate = compileGraalWithC1Only ? new IsGraalPredicate() : null;
    }

    private static void initializeGraalCompilePolicyFields(OptionValues options) {
        compileGraalWithC1Only = Options.CompileGraalWithC1Only.getValue(options) != false && !ImageInfo.inImageRuntimeCode();
        String optionValue = Options.GraalCompileOnly.getValue(options);
        if (optionValue != null) {
            MethodFilter filter = MethodFilter.parse(optionValue);
            if (filter.matchesNothing()) {
                filter = null;
            }
            graalCompileOnlyFilter = filter;
        }
    }

    public void printProperties(PrintStream out) {
        this.ensureInitialized();
        out.println("[Graal properties]");
        if (this.optionsFailure != null) {
            System.err.printf("Error parsing Graal options: %s%n", this.optionsFailure.getMessage());
            return;
        }
        HotSpotGraalOptionValues.printProperties(this.options, out);
    }

    public HotSpotGraalCompiler createCompiler(JVMCIRuntime runtime) {
        HotSpotVMConfigAccess config;
        if (ImageInfo.inImageBuildtimeCode() && ImageInfo.inImageRuntimeCode()) {
            throw new GraalError("Invariant violation: inImageBuildtimeCode && inImageRuntimeCode must not both be true");
        }
        if (Services.IS_BUILDING_NATIVE_IMAGE && Services.IS_IN_NATIVE_IMAGE) {
            throw new GraalError("Invariant violation: IS_BUILDING_NATIVE_IMAGE && IS_IN_NATIVE_IMAGE must not both be true");
        }
        HotSpotJVMCIRuntime hsRuntime = (HotSpotJVMCIRuntime)runtime;
        this.checkUnsafeAccess(hsRuntime);
        this.ensureInitialized();
        if (this.optionsFailure != null) {
            System.err.printf("Error parsing Graal options: %s%nError: A fatal exception has occurred. Program will exit.%n", this.optionsFailure.getMessage());
            HotSpotGraalServices.exit(1, hsRuntime);
        }
        if (Options.PrintPropertiesAll.getValue(this.options).booleanValue() && !((Boolean)(config = new HotSpotVMConfigAccess(hsRuntime.getConfigStore())).getFlag("JVMCIPrintProperties", Boolean.class)).booleanValue()) {
            TTY.printf("Warning: Ignoring %s since JVMCIPrintProperties is false%n", Options.PrintPropertiesAll.getName());
        }
        CompilerConfigurationFactory factory = CompilerConfigurationFactory.selectFactory(null, this.options, hsRuntime);
        if (this.isGraalPredicate != null) {
            this.isGraalPredicate.onCompilerConfigurationFactorySelection(hsRuntime, factory);
        }
        HotSpotGraalCompiler compiler = HotSpotGraalCompilerFactory.createCompiler("VM", runtime, this.options, factory);
        this.locator.onCompilerCreation(compiler);
        return compiler;
    }

    private void checkUnsafeAccess(HotSpotJVMCIRuntime hsRuntime) {
        if (ImageInfo.inImageRuntimeCode()) {
            return;
        }
        try {
            Unsafe.getUnsafe();
        }
        catch (IllegalAccessError e) {
            Module module = this.getClass().getModule();
            Object targets = module.getName();
            String ee = "com.oracle.graal.graal_enterprise";
            if (module.getDescriptor().exports().stream().anyMatch(export -> export.targets().contains(ee))) {
                targets = (String)targets + "," + ee;
            }
            System.err.printf("Error: jargraal requires --add-exports=java.base/jdk.internal.misc=%s to be specified to the launcher.%n", targets);
            HotSpotGraalServices.exit(1, hsRuntime);
        }
    }

    public static HotSpotGraalCompiler createCompiler(String runtimeNameQualifier, JVMCIRuntime runtime, OptionValues options, CompilerConfigurationFactory compilerConfigurationFactory) {
        HotSpotJVMCIRuntime jvmciRuntime = (HotSpotJVMCIRuntime)runtime;
        try (InitTimer t = InitTimer.timer((String)"HotSpotGraalRuntime.<init>");){
            HotSpotGraalRuntime graalRuntime = new HotSpotGraalRuntime(runtimeNameQualifier, jvmciRuntime, compilerConfigurationFactory, options);
            HotSpotGraalCompiler hotSpotGraalCompiler = new HotSpotGraalCompiler(jvmciRuntime, graalRuntime, graalRuntime.getOptions());
            return hotSpotGraalCompiler;
        }
    }

    static boolean shouldExclude(HotSpotResolvedJavaMethod method) {
        if (graalCompileOnlyFilter != null) {
            Signature signature;
            String name;
            String javaClassName = method.getDeclaringClass().toJavaName();
            return !graalCompileOnlyFilter.matches(javaClassName, name = method.getName(), signature = method.getSignature());
        }
        return false;
    }

    static class Options {
        public static final OptionKey<Boolean> CompileGraalWithC1Only = new OptionKey<Boolean>(true);
        public static final OptionKey<String> GraalCompileOnly = new OptionKey<Object>(null);
        public static final OptionKey<Boolean> PrintPropertiesAll = new OptionKey<Boolean>(false);

        Options() {
        }
    }
}

