/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.api.runtime.GraalJVMCICompiler;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.GraalCompiler;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.hotspot.BootstrapWatchDog;
import jdk.graal.compiler.hotspot.CompilationCounters;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotBackend;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntime;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.HotSpotGraphBuilderPhase;
import jdk.graal.compiler.hotspot.JVMCICompilerShadow;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.phases.OnStackReplacementPhase;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.lir.asm.CompilationResultBuilderFactory;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.nodes.Cancellable;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.spi.ProfileProvider;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import jdk.graal.compiler.serviceprovider.GlobalAtomicLong;
import jdk.graal.compiler.serviceprovider.VMSupport;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompilationRequestResult;
import jdk.vm.ci.hotspot.HotSpotCompilationRequestResult;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.DefaultProfilingInfo;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.TriState;
import org.graalvm.nativeimage.ImageInfo;

public class HotSpotGraalCompiler
implements GraalJVMCICompiler,
Cancellable,
JVMCICompilerShadow,
GraalCompiler.RequestedCrashHandler {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private final HotSpotJVMCIRuntime jvmciRuntime;
    private final HotSpotGraalRuntimeProvider graalRuntime;
    private final CompilationCounters compilationCounters;
    private final BootstrapWatchDog bootstrapWatchDog;
    private List<DebugHandlersFactory> factories;
    private static final GlobalAtomicLong OOME_CRASH_DONE = new GlobalAtomicLong(0L);

    HotSpotGraalCompiler(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalRuntimeProvider graalRuntime, OptionValues options) {
        this.jvmciRuntime = jvmciRuntime;
        this.graalRuntime = graalRuntime;
        this.compilationCounters = CompilationCounters.Options.CompilationCountLimit.getValue(options) > 0 ? new CompilationCounters(options) : null;
        this.bootstrapWatchDog = graalRuntime.isBootstrapping() && DebugOptions.BootstrapInitializeOnly.getValue(options) == false ? BootstrapWatchDog.maybeCreate(graalRuntime) : null;
    }

    public List<DebugHandlersFactory> getDebugHandlersFactories() {
        if (this.factories == null) {
            this.factories = Collections.singletonList(new GraalDebugHandlersFactory(this.graalRuntime.getHostProviders().getSnippetReflection()));
        }
        return this.factories;
    }

    @Override
    public HotSpotGraalRuntimeProvider getGraalRuntime() {
        return this.graalRuntime;
    }

    public CompilationRequestResult compileMethod(CompilationRequest request) {
        CompilationRequestResult compilationRequestResult;
        block8: {
            AutoCloseable ignored = VMSupport.getCompilationRequestScope();
            try {
                compilationRequestResult = this.compileMethod(request, true, this.getGraalRuntime().getOptions());
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return HotSpotCompilationRequestResult.failure((String)e.toString(), (boolean)false);
                }
            }
            ignored.close();
        }
        return compilationRequestResult;
    }

    /*
     * Exception decompiling
     */
    public CompilationRequestResult compileMethod(CompilationRequest request, boolean installAsDefault, OptionValues initialOptions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean shouldRetainLocalVariables(long envAddress) {
        GraalHotSpotVMConfig config = this.graalRuntime.getVMConfig();
        if (envAddress == 0L) {
            return false;
        }
        if (config.jvmciCompileStateCanPopFrameOffset != Integer.MIN_VALUE && (UNSAFE.getByte(envAddress + (long)config.jvmciCompileStateCanPopFrameOffset) & 0xFF) != 0) {
            return true;
        }
        return config.jvmciCompileStateCanAccessLocalVariablesOffset != Integer.MIN_VALUE && (UNSAFE.getByte(envAddress + (long)config.jvmciCompileStateCanAccessLocalVariablesOffset) & 0xFF) != 0;
    }

    private boolean shouldUsePreciseUnresolvedDeopts() {
        GraalHotSpotVMConfig config = this.graalRuntime.getVMConfig();
        return config.xcompMode;
    }

    @Override
    public boolean isCancelled() {
        return this.graalRuntime.isShutdown();
    }

    public StructuredGraph createGraph(ResolvedJavaMethod method, int entryBCI, ProfileProvider profileProvider, CompilationIdentifier compilationId, OptionValues options, DebugContext debug) {
        StructuredGraph.AllowAssumptions allowAssumptions = StructuredGraph.AllowAssumptions.ifTrue(GraalOptions.OptAssumptions.getValue(options));
        SpeculationLog speculationLog = method.getSpeculationLog();
        if (speculationLog != null) {
            speculationLog.collectFailedSpeculations();
        }
        return new StructuredGraph.Builder(options, debug, allowAssumptions).method(method).cancellable(this).entryBCI(entryBCI).speculationLog(speculationLog).profileProvider(profileProvider).compilationId(compilationId).build();
    }

    public CompilationResult compileHelper(CompilationResultBuilderFactory crbf, CompilationResult result, StructuredGraph graph, boolean shouldRetainLocalVariables, boolean shouldUsePreciseUnresolvedDeopts, boolean eagerResolving, OptionValues options) {
        int entryBCI = graph.getEntryBCI();
        ResolvedJavaMethod method = graph.method();
        assert (options == graph.getOptions()) : Assertions.errorMessage(options, graph.getOptions());
        HotSpotBackend backend = this.graalRuntime.getHostBackend();
        HotSpotProviders providers = backend.getProviders();
        boolean isOSR = entryBCI != -1;
        Suites suites = this.getSuites(providers, options);
        LIRSuites lirSuites = this.getLIRSuites(providers, options);
        ProfilingInfo profilingInfo = graph.getProfileProvider() != null ? graph.getProfileProvider().getProfilingInfo(method, !isOSR, isOSR) : DefaultProfilingInfo.get((TriState)TriState.FALSE);
        OptimisticOptimizations optimisticOpts = this.getOptimisticOpts(profilingInfo, options);
        if (isOSR && !OnStackReplacementPhase.Options.DeoptAfterOSR.getValue(options).booleanValue()) {
            optimisticOpts.remove(OptimisticOptimizations.Optimization.RemoveNeverExecutedCode);
        }
        result.setEntryBCI(entryBCI);
        boolean shouldDebugNonSafepoints = providers.getCodeCache().shouldDebugNonSafepoints();
        PhaseSuite<HighTierContext> graphBuilderSuite = this.configGraphBuilderSuite(providers.getSuites().getDefaultGraphBuilderSuite(), shouldDebugNonSafepoints, shouldRetainLocalVariables, shouldUsePreciseUnresolvedDeopts, eagerResolving, isOSR);
        GraalCompiler.compile(new GraalCompiler.Request<CompilationResult>(graph, method, providers, backend, graphBuilderSuite, optimisticOpts, profilingInfo, suites, lirSuites, result, crbf, null, this, true));
        graph.getOptimizationLog().emit();
        if (!isOSR) {
            profilingInfo.setCompilerIRSize(StructuredGraph.class, graph.getNodeCount());
        }
        return result;
    }

    public CompilationResult compile(StructuredGraph graph, boolean shouldRetainLocalVariables, boolean shouldUsePreciseUnresolvedDeopts, boolean eagerResolving, CompilationIdentifier compilationId, DebugContext debug) {
        CompilationResult result = new CompilationResult(compilationId);
        return this.compileHelper(CompilationResultBuilderFactory.Default, result, graph, shouldRetainLocalVariables, shouldUsePreciseUnresolvedDeopts, eagerResolving, debug.getOptions());
    }

    protected OptimisticOptimizations getOptimisticOpts(ProfilingInfo profilingInfo, OptionValues options) {
        return new OptimisticOptimizations(profilingInfo, options);
    }

    protected Suites getSuites(HotSpotProviders providers, OptionValues options) {
        return providers.getSuites().getDefaultSuites(options, providers.getLowerer().getTarget().arch);
    }

    protected LIRSuites getLIRSuites(HotSpotProviders providers, OptionValues options) {
        return providers.getSuites().getDefaultLIRSuites(options);
    }

    protected PhaseSuite<HighTierContext> configGraphBuilderSuite(PhaseSuite<HighTierContext> suite, boolean shouldDebugNonSafepoints, boolean shouldRetainLocalVariables, boolean shouldUsePreciseUnresolvedDeopts, boolean eagerResolving, boolean isOSR) {
        PhaseSuite<HighTierContext> newGbs = suite.copy();
        GraphBuilderPhase graphBuilderPhase = (GraphBuilderPhase)newGbs.findPhase(GraphBuilderPhase.class).previous();
        GraphBuilderConfiguration graphBuilderConfig = graphBuilderPhase.getGraphBuilderConfig();
        if (shouldDebugNonSafepoints) {
            graphBuilderConfig = graphBuilderConfig.withNodeSourcePosition(true);
        }
        if (shouldRetainLocalVariables) {
            graphBuilderConfig = graphBuilderConfig.withRetainLocalVariables(true);
        }
        if (shouldUsePreciseUnresolvedDeopts) {
            graphBuilderConfig = graphBuilderConfig.withUsePreciseUnresolvedDeopts(true);
        }
        if (eagerResolving) {
            graphBuilderConfig = graphBuilderConfig.withEagerResolving(true);
            graphBuilderConfig = graphBuilderConfig.withUnresolvedIsError(true);
        }
        if (this.graalRuntime.getVMConfig().alwaysSafeConstructors) {
            graphBuilderConfig = graphBuilderConfig.withAlwaysSafeConstructors();
        }
        HotSpotGraphBuilderPhase newGraphBuilderPhase = new HotSpotGraphBuilderPhase(graphBuilderConfig);
        newGbs.findPhase(GraphBuilderPhase.class).set(newGraphBuilderPhase);
        if (isOSR) {
            newGbs.appendPhase(new OnStackReplacementPhase());
        }
        return newGbs;
    }

    @Override
    public boolean isGCSupported(int gcIdentifier) {
        HotSpotGraalRuntime.HotSpotGC gc = HotSpotGraalRuntime.HotSpotGC.forName(gcIdentifier, this.graalRuntime.getVMConfig());
        if (gc != null) {
            return gc.supported;
        }
        return false;
    }

    @Override
    public boolean notifyCrash(OptionValues options, String crashMessage) {
        if (ImageInfo.inImageRuntimeCode()) {
            if (Options.CrashAtThrowsOOME.getValue(options).booleanValue()) {
                if (OOME_CRASH_DONE.compareAndSet(0L, 1L)) {
                    String largeString = Arrays.toString(new int[0x7FFFFFFE]);
                    throw new InternalError("Failed to trigger OOME: largeString.length=" + largeString.length());
                }
                return false;
            }
            int crashAtIsFatal = Options.CrashAtIsFatal.getValue(options);
            if (crashAtIsFatal != 0) {
                VMSupport.fatalError(crashMessage, crashAtIsFatal);
                System.out.println("CrashAtIsFatal: no fatalError function pointer installed");
            }
        }
        return true;
    }

    public static final class Options {
        public static final OptionKey<Integer> CrashAtIsFatal = new OptionKey<Integer>(0);
        public static final OptionKey<String> OnShutdownCallback = new OptionKey<Object>(null);
        public static final OptionKey<Boolean> CrashAtThrowsOOME = new OptionKey<Boolean>(false);
    }
}

