/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.lir.gen.G1BarrierSetLIRTool;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.InvokeTarget;

public abstract class HotSpotG1BarrierSetLIRTool
implements G1BarrierSetLIRTool {
    protected final Register threadRegister;
    protected final GraalHotSpotVMConfig config;
    protected final HotSpotProviders providers;

    public HotSpotG1BarrierSetLIRTool(GraalHotSpotVMConfig config, HotSpotProviders providers) {
        this.config = config;
        this.providers = providers;
        this.threadRegister = providers.getRegisters().getThreadRegister();
    }

    @Override
    public int satbQueueMarkingActiveOffset() {
        return HotSpotReplacementsUtil.g1SATBQueueMarkingActiveOffset(this.config);
    }

    @Override
    public int satbQueueBufferOffset() {
        return HotSpotReplacementsUtil.g1SATBQueueBufferOffset(this.config);
    }

    @Override
    public int satbQueueIndexOffset() {
        return HotSpotReplacementsUtil.g1SATBQueueIndexOffset(this.config);
    }

    @Override
    public int cardQueueBufferOffset() {
        return HotSpotReplacementsUtil.g1CardQueueBufferOffset(this.config);
    }

    @Override
    public int cardQueueIndexOffset() {
        return HotSpotReplacementsUtil.g1CardQueueIndexOffset(this.config);
    }

    @Override
    public byte dirtyCardValue() {
        return this.config.dirtyCardValue;
    }

    @Override
    public byte youngCardValue() {
        return HotSpotReplacementsUtil.g1YoungCardValue(this.config);
    }

    @Override
    public long cardTableAddress() {
        return HotSpotReplacementsUtil.cardTableStart(this.config);
    }

    @Override
    public int logOfHeapRegionGrainBytes() {
        return HotSpotReplacementsUtil.logOfHeapRegionGrainBytes(this.config);
    }

    @Override
    public ForeignCallDescriptor preWriteBarrierDescriptor() {
        return HotSpotHostForeignCallsProvider.G1WBPRECALL_STACK_ONLY;
    }

    @Override
    public ForeignCallDescriptor postWriteBarrierDescriptor() {
        return HotSpotHostForeignCallsProvider.G1WBPOSTCALL_STACK_ONLY;
    }

    @Override
    public InvokeTarget getCallTarget(ForeignCallLinkage callTarget) {
        return callTarget;
    }
}

