/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.util.BitSet;
import java.util.List;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.common.spi.ForeignCallSignature;
import jdk.graal.compiler.core.target.Backend;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import jdk.graal.compiler.hotspot.stubs.Stub;
import jdk.graal.compiler.serviceprovider.GlobalAtomicLong;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.meta.InvokeTarget;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.nativeimage.ImageInfo;

public interface HotSpotForeignCallLinkage
extends ForeignCallLinkage,
InvokeTarget {
    public static final long JUMP_ADDRESS = -2401018188504514833L;

    @Override
    public HotSpotForeignCallDescriptor getDescriptor();

    public void setCompiledStub(Stub var1);

    public RegisterEffect getEffect();

    public boolean isCompiledStub();

    public Stub getStub();

    public void finalizeAddress(Backend var1);

    public long getAddress();

    public boolean mayContainFP();

    public boolean needsJavaFrameAnchor();

    public String getSymbol();

    public static class Stubs {
        private static final EconomicMap<ForeignCallSignature, GlobalAtomicLong> STUBS = EconomicMap.create();

        static CodeInfo getCodeInfo(Stub stub, Backend backend) {
            ForeignCallSignature sig = stub.getLinkage().getDescriptor().getSignature();
            GlobalAtomicLong data = Stubs.getStubData(sig);
            long codeInfoInMemory = data.get();
            if (codeInfoInMemory == 0L) {
                CodeInfo codeInfo = new CodeInfo(stub.getCode(backend).getStart(), stub.getDestroyedCallerRegisters());
                data.set(codeInfo.toMemory());
                return codeInfo;
            }
            RegisterArray allRegisters = backend.getCodeCache().getTarget().arch.getRegisters();
            return CodeInfo.fromMemory(codeInfoInMemory, allRegisters);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static GlobalAtomicLong getStubData(ForeignCallSignature sig) {
            GlobalAtomicLong data;
            if (ImageInfo.inImageRuntimeCode()) {
                data = (GlobalAtomicLong)STUBS.get((Object)sig);
                GraalError.guarantee(data != null, "missing global data for %s", (Object)sig);
            } else {
                EconomicMap<ForeignCallSignature, GlobalAtomicLong> economicMap = STUBS;
                synchronized (economicMap) {
                    data = (GlobalAtomicLong)STUBS.get((Object)sig);
                    if (data == null) {
                        data = new GlobalAtomicLong(0L);
                        STUBS.put((Object)sig, (Object)data);
                    }
                }
            }
            return data;
        }

        public static void initStubs(List<ForeignCallSignature> sigs) {
            GraalError.guarantee(STUBS.isEmpty(), "cannot re-initialize STUBS: %s", STUBS);
            for (ForeignCallSignature sig : sigs) {
                Stubs.initStub(sig);
            }
        }

        public static boolean initStub(ForeignCallSignature sig) {
            if (!STUBS.containsKey((Object)sig)) {
                STUBS.put((Object)sig, (Object)new GlobalAtomicLong(0L));
                return true;
            }
            return false;
        }
    }

    public record CodeInfo(long start, EconomicSet<Register> killedRegisters) {
        public static CodeInfo fromMemory(long memory, RegisterArray allRegisters) {
            Unsafe unsafe = Unsafe.getUnsafe();
            int offset = 0;
            long start = unsafe.getLong(memory + (long)offset);
            int bsLongsLength = unsafe.getInt(memory + (long)(offset += 8));
            offset += 4;
            long[] bsLongs = new long[bsLongsLength];
            for (int i = 0; i < bsLongsLength; ++i) {
                bsLongs[i] = unsafe.getLong(memory + (long)offset);
                offset += 8;
            }
            BitSet bs = BitSet.valueOf(bsLongs);
            EconomicSet killedRegisters = EconomicSet.create((int)bs.cardinality());
            int regNum = bs.nextSetBit(0);
            while (regNum >= 0) {
                killedRegisters.add((Object)allRegisters.get(regNum));
                regNum = bs.nextSetBit(regNum + 1);
            }
            return new CodeInfo(start, (EconomicSet<Register>)killedRegisters);
        }

        public long toMemory() {
            BitSet bs = new BitSet();
            for (Register reg : this.killedRegisters) {
                bs.set(reg.number);
            }
            Unsafe unsafe = Unsafe.getUnsafe();
            long[] bsLongs = bs.toLongArray();
            int memorySize = 12 + 8 * bsLongs.length;
            long memory = unsafe.allocateMemory(memorySize);
            int offset = 0;
            unsafe.putLong(memory + (long)offset, this.start);
            unsafe.putInt(memory + (long)(offset += 8), bsLongs.length);
            offset += 4;
            for (long l : bsLongs) {
                unsafe.putLong(memory + (long)offset, l);
                offset += 8;
            }
            GraalError.guarantee(memorySize == offset, "%s != %s", (Object)memorySize, (Object)offset);
            return memory;
        }
    }

    public static enum RegisterEffect {
        DESTROYS_ALL_CALLER_SAVE_REGISTERS,
        COMPUTES_REGISTERS_KILLED,
        KILLS_NO_REGISTERS;

    }
}

