/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.CompilationRequestIdentifier;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;

public class HotSpotCompilationIdentifier
implements CompilationRequestIdentifier {
    private final HotSpotCompilationRequest request;

    public HotSpotCompilationIdentifier(HotSpotCompilationRequest request) {
        this.request = request;
    }

    public boolean isOsrCompilation() {
        return this.request.getEntryBCI() != -1;
    }

    @Override
    public final String toString() {
        return this.toString(CompilationIdentifier.Verbosity.DETAILED);
    }

    @Override
    public String toString(CompilationIdentifier.Verbosity verbosity) {
        return this.buildString(new StringBuilder(), verbosity).toString();
    }

    protected StringBuilder buildString(StringBuilder sb, CompilationIdentifier.Verbosity verbosity) {
        switch (verbosity) {
            case ID: {
                this.buildID(sb);
                break;
            }
            case NAME: {
                this.buildName(sb);
                break;
            }
            case DETAILED: {
                this.buildID(sb);
                sb.append('[');
                this.buildName(sb);
                if (this.isOsrCompilation()) {
                    sb.append("@");
                    sb.append(this.request.getEntryBCI());
                }
                sb.append(']');
                break;
            }
            default: {
                throw new GraalError("unknown verbosity: " + String.valueOf((Object)verbosity));
            }
        }
        return sb;
    }

    protected StringBuilder buildName(StringBuilder sb) {
        return sb.append(this.request.getMethod().format("%H.%n(%p)"));
    }

    protected StringBuilder buildID(StringBuilder sb) {
        if (this.isOsrCompilation()) {
            sb.append("HotSpotOSRCompilation-");
        } else {
            sb.append("HotSpotCompilation-");
        }
        return sb.append(this.request.getId());
    }

    public HotSpotCompilationRequest getRequest() {
        return this.request;
    }
}

