/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.hotspot.HotSpotGraalServices;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GeneratedNodeIntrinsicInvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageInfo;

public class HotSpotBytecodeParser
extends BytecodeParser {
    public static final String BAD_NODE_INTRINSIC_PLUGIN_CONTEXT = "@NodeIntrinsic plugin can't be used outside of Snippet context: ";

    protected HotSpotBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
        super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext);
    }

    @Override
    protected Object lookupConstant(int cpi, int opcode, boolean allowBootstrapMethodInvocation) {
        try {
            return super.lookupConstant(cpi, opcode, allowBootstrapMethodInvocation);
        }
        catch (BootstrapMethodError e) {
            DeoptimizeNode deopt = this.append(new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint));
            deopt.updateNodeSourcePosition(() -> this.createBytecodePosition());
            return e;
        }
    }

    @Override
    public GuardingNode intrinsicRangeCheck(LogicNode condition, boolean negated) {
        return HotSpotBytecodeParser.doIntrinsicRangeCheck(this, condition, negated);
    }

    @Override
    protected boolean applyInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType, InvocationPlugin plugin) {
        if (plugin instanceof GeneratedNodeIntrinsicInvocationPlugin) {
            GeneratedNodeIntrinsicInvocationPlugin nodeIntrinsicPlugin = (GeneratedNodeIntrinsicInvocationPlugin)plugin;
            if (ImageInfo.inImageRuntimeCode() || this.graph.method().getAnnotation(Snippet.class) == null) {
                throw new PermanentBailoutException(BAD_NODE_INTRINSIC_PLUGIN_CONTEXT + nodeIntrinsicPlugin.getSource().getSimpleName());
            }
        }
        return super.applyInvocationPlugin(invokeKind, args, targetMethod, resultType, plugin);
    }

    public static FixedGuardNode doIntrinsicRangeCheck(GraphBuilderContext context, LogicNode condition, boolean negated) {
        return context.add(new FixedGuardNode(condition, DeoptimizationReason.BoundsCheckException, DeoptimizationAction.None, !negated));
    }

    @Override
    protected boolean mustClearNonLiveLocalsAtOSREntry() {
        return !HotSpotGraalServices.hasGetOopMapAt();
    }

    @Override
    protected boolean needBarrierAfterFieldStore(ResolvedJavaField field) {
        HotSpotResolvedJavaField hfield;
        if (this.method.isConstructor() && field instanceof HotSpotResolvedJavaField && (hfield = (HotSpotResolvedJavaField)field).isStable()) {
            return true;
        }
        return super.needBarrierAfterFieldStore(field);
    }
}

