/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.blocks;

import java.util.SortedSet;
import java.util.TreeSet;
import jdk.graal.compiler.core.common.cfg.AbstractControlFlowGraph;
import jdk.graal.compiler.core.common.cfg.CFGLoop;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hightiercodegen.reconstruction.StackifierData;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.blocks.LabeledBlock;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.CatchScopeContainer;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.IfScopeContainer;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.LoopScopeContainer;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.Scope;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.ScopeContainer;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.SwitchScopeContainer;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.IntegerSwitchNode;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;

public class LabeledBlockGeneration {
    public static final String LabeledBlockPrefix = "lb";
    protected final EconomicMap<HIRBlock, SortedSet<LabeledBlock>> labeledBlockStarts = EconomicMap.create();
    protected final EconomicMap<HIRBlock, LabeledBlock> labeledBlockEnds = EconomicMap.create();
    protected final LabeledBlockGenerator labeledBlockGenerator = new LabeledBlockGenerator();
    protected final ControlFlowGraph cfg;
    protected final StackifierData stackifierData;

    public LabeledBlockGeneration(StackifierData stackifierData, ControlFlowGraph cfg) {
        this.stackifierData = stackifierData;
        this.cfg = cfg;
    }

    public boolean isLabeledBlockNeeded(HIRBlock block, HIRBlock successor) {
        if (Assertions.assertionsEnabled()) {
            boolean found = false;
            for (int i = 0; i < block.getSuccessorCount(); ++i) {
                HIRBlock s = (HIRBlock)block.getSuccessorAt(i);
                found = found || s == successor;
            }
            assert (found);
        }
        ScopeContainer scopeContainer = this.stackifierData.getScopeEntry(block.getEndNode());
        if (block.isLoopEnd()) {
            assert (block.getSuccessorCount() == 1) : Assertions.errorMessage(block);
            return false;
        }
        if (LabeledBlockGeneration.isNormalLoopExit(block, successor, this.stackifierData)) {
            return false;
        }
        if (block.getEndNode() instanceof IfNode) {
            if (((IfNode)block.getEndNode()).trueSuccessor() == successor.getBeginNode() ? ((IfScopeContainer)scopeContainer).getThenScope() != null : ((IfScopeContainer)scopeContainer).getElseScope() != null) {
                return false;
            }
        } else if (block.getEndNode() instanceof InvokeWithExceptionNode) {
            InvokeWithExceptionNode invokeWithExc = (InvokeWithExceptionNode)block.getEndNode();
            if (invokeWithExc.getPrimarySuccessor() == successor.getBeginNode()) {
                return !LabeledBlockGeneration.isJumpingOverCatchBlock(block, successor, this.stackifierData);
            }
            assert (invokeWithExc.exceptionEdge() == successor.getBeginNode()) : Assertions.errorMessage(invokeWithExc, successor);
            if (((CatchScopeContainer)scopeContainer).getCatchScope() != null) {
                return false;
            }
        } else if (block.getEndNode() instanceof IntegerSwitchNode) {
            IntegerSwitchNode switchNode = (IntegerSwitchNode)block.getEndNode();
            Scope[] caseScopes = ((SwitchScopeContainer)this.stackifierData.getScopeEntry(switchNode)).getCaseScopes();
            for (int i = 0; i < switchNode.getSuccessorCount(); ++i) {
                if (switchNode.blockSuccessor(i) != successor.getBeginNode()) continue;
                return caseScopes[i] == null;
            }
            GraalError.shouldNotReachHere("successor of switchnode not found in its successor list");
        }
        if (LabeledBlockGeneration.isLastBlockInThenBranch(block, this.stackifierData)) {
            return !LabeledBlockGeneration.isJumpingToAfterElseBranch(block, successor, this.stackifierData);
        }
        if (LabeledBlockGeneration.isLastBlockInSwitchArm(block, this.stackifierData)) {
            return true;
        }
        return !this.stackifierData.isPredecessor(block, successor);
    }

    private static boolean isJumpingToAfterElseBranch(HIRBlock block, HIRBlock successor, StackifierData stackifierData) {
        Scope scope = (Scope)stackifierData.getEnclosingScope().get((Object)block);
        HIRBlock startBlock = scope.getStartBlock();
        IfScopeContainer ifScopeContainer = (IfScopeContainer)stackifierData.getScopeEntry(startBlock.getEndNode());
        Scope elseScope = ifScopeContainer.getElseScope();
        if (elseScope == null) {
            return false;
        }
        HIRBlock[] sortedBlocks = stackifierData.getBlocks();
        for (int id = stackifierData.blockOrder(block) + 1; id < stackifierData.blockOrder(successor); ++id) {
            if (elseScope.getBlocks().contains((Object)sortedBlocks[id])) continue;
            return false;
        }
        return true;
    }

    private static boolean isLastBlockInThenBranch(HIRBlock block, StackifierData stackifierData) {
        HIRBlock startBlock;
        Scope scope = (Scope)stackifierData.getEnclosingScope().get((Object)block);
        if (scope != null && (startBlock = scope.getStartBlock()).getEndNode() instanceof IfNode) {
            IfScopeContainer ifScopeContainer = (IfScopeContainer)stackifierData.getScopeEntry(startBlock.getEndNode());
            return ifScopeContainer.getThenScope() == scope && scope.getLastBlock(stackifierData) == block;
        }
        return false;
    }

    private static boolean isLastBlockInSwitchArm(HIRBlock block, StackifierData stackifierData) {
        HIRBlock startBlock;
        Scope scope = (Scope)stackifierData.getEnclosingScope().get((Object)block);
        if (scope != null && (startBlock = scope.getStartBlock()).getEndNode() instanceof IntegerSwitchNode) {
            return scope.getLastBlock(stackifierData) == block;
        }
        return false;
    }

    private static boolean isJumpingOverCatchBlock(HIRBlock block, HIRBlock successor, StackifierData stackifierData) {
        assert (block.getEndNode() instanceof InvokeWithExceptionNode) : Assertions.errorMessage(block, block.getEndNode());
        assert (block.getFirstSuccessor() == successor) : Assertions.errorMessage(block, successor);
        CatchScopeContainer catchScopeContainer = (CatchScopeContainer)stackifierData.getScopeEntry(block.getEndNode());
        Scope catchScope = catchScopeContainer.getCatchScope();
        if (catchScope == null) {
            return false;
        }
        EconomicSet<HIRBlock> blocksInCatchScope = catchScope.getBlocks();
        HIRBlock[] sortedBlocks = stackifierData.getBlocks();
        for (int id = stackifierData.blockOrder(block) + 1; id < stackifierData.blockOrder(successor); ++id) {
            if (blocksInCatchScope.contains((Object)sortedBlocks[id])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNormalLoopExit(HIRBlock block, HIRBlock successor, StackifierData stackifierData) {
        CFGLoop<HIRBlock> l1 = block.getLoop();
        if (l1 != null) {
            HIRBlock lastLoopBlock = ((LoopScopeContainer)stackifierData.getScopeEntry(l1.getHeader().getBeginNode())).getLoopScope().getLastBlock(stackifierData);
            return stackifierData.isPredecessor(lastLoopBlock, successor);
        }
        return false;
    }

    public static SortedSet<LabeledBlock> getSortedSetByLabeledBlockEnd(StackifierData stackifierData) {
        return new TreeSet<LabeledBlock>((b1, b2) -> stackifierData.blockOrder(b2.getEnd()) - stackifierData.blockOrder(b1.getEnd()));
    }

    private static HIRBlock commonDominatorFor(HIRBlock b, boolean pred) {
        HIRBlock commonDom = null;
        for (int i = 0; i < (pred ? b.getPredecessorCount() : b.getSuccessorCount()); ++i) {
            HIRBlock block = pred ? (HIRBlock)b.getPredecessorAt(i) : (HIRBlock)b.getSuccessorAt(i);
            commonDom = (HIRBlock)AbstractControlFlowGraph.commonDominator(commonDom, block);
        }
        return commonDom;
    }

    public void generateLabeledBlocks() {
        this.stackifierData.setLabeledBlockStarts(this.labeledBlockStarts);
        this.stackifierData.setLabeledBlockEnd(this.labeledBlockEnds);
        for (HIRBlock block : this.stackifierData.getBlocks()) {
            for (int i = 0; i < block.getSuccessorCount(); ++i) {
                HIRBlock successor = (HIRBlock)block.getSuccessorAt(i);
                if (!this.isLabeledBlockNeeded(block, successor)) continue;
                HIRBlock labeledBlockStart = this.getLabeledBlockStart(block, successor);
                if (this.labeledBlockEndsBeforeBasicBlock(successor)) continue;
                LabeledBlock labeledBlock = this.labeledBlockGenerator.generateLabeledBlock(labeledBlockStart, successor);
                this.addToMaps(labeledBlock);
            }
        }
    }

    private HIRBlock getLabeledBlockStart(HIRBlock predecessor, HIRBlock successor) {
        HIRBlock earliestStart = predecessor;
        if (successor.getPredecessorCount() > 1) {
            earliestStart = LabeledBlockGeneration.commonDominatorFor(successor, true);
        }
        Scope startScope = (Scope)this.stackifierData.getEnclosingScope().get((Object)earliestStart);
        Scope endScope = (Scope)this.stackifierData.getEnclosingScope().get((Object)successor);
        if (successor.isLoopHeader()) {
            endScope = endScope.getParentScope();
        }
        if (startScope != endScope) {
            while (startScope != null && startScope.getParentScope() != endScope) {
                startScope = startScope.getParentScope();
            }
            if (startScope == null) {
                assert (endScope == null) : this.cfg.graph.method().getDeclaringClass().getUnqualifiedName() + "." + this.cfg.graph.method().getName() + " Cannot jump from start of a method into a scope " + String.valueOf(endScope);
                earliestStart = this.cfg.getStartBlock();
            } else {
                earliestStart = startScope.getStartBlock();
            }
        }
        for (HIRBlock b : this.labeledBlockEnds.getKeys()) {
            LabeledBlock forwardBlock;
            if (!this.stackifierData.isOrderedBefore(predecessor, b) || !this.stackifierData.isOrderedBefore(b, successor) || !this.stackifierData.isOrderedBefore((forwardBlock = (LabeledBlock)this.labeledBlockEnds.get((Object)b)).getStart(), earliestStart)) continue;
            earliestStart = forwardBlock.getStart();
        }
        return earliestStart;
    }

    private boolean labeledBlockEndsBeforeBasicBlock(HIRBlock labeledBlockEnd) {
        return this.labeledBlockEnds.get((Object)labeledBlockEnd) != null;
    }

    private void addToMaps(LabeledBlock labeledBLock) {
        if (this.labeledBlockStarts.get((Object)labeledBLock.getStart()) == null) {
            this.labeledBlockStarts.put((Object)labeledBLock.getStart(), LabeledBlockGeneration.getSortedSetByLabeledBlockEnd(this.stackifierData));
        }
        ((SortedSet)this.labeledBlockStarts.get((Object)labeledBLock.getStart())).add(labeledBLock);
        HIRBlock endBlock = labeledBLock.getEnd();
        assert (!this.labeledBlockEnds.containsKey((Object)endBlock));
        this.labeledBlockEnds.put((Object)endBlock, (Object)labeledBLock);
    }

    private static class LabeledBlockGenerator {
        private int currentId = 0;

        private LabeledBlockGenerator() {
        }

        public LabeledBlock generateLabeledBlock(HIRBlock start, HIRBlock end) {
            return new LabeledBlock(start, end, this.currentId++);
        }
    }
}

