/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hightiercodegen.reconstruction.stackifier;

import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hightiercodegen.reconstruction.StackifierData;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.CatchScopeContainer;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.IfScopeContainer;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.LoopScopeContainer;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.Scope;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.ScopeContainer;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.SwitchScopeContainer;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.phases.BasePhase;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public class CFStackifierSortPhase
extends BasePhase<StackifierData> {
    @Override
    protected void run(StructuredGraph graph, StackifierData stackifierData) {
        try (DebugContext.Scope scope1 = graph.getDebug().scope("Stackifier Sort Phase");){
            Instance instance = new Instance(graph, stackifierData);
            instance.run();
        }
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.ALWAYS_APPLICABLE;
    }

    public static final class Instance {
        private final SortedSet<HIRBlock> freeBlocks = new TreeSet<HIRBlock>(Comparator.comparingInt(BasicBlock::getId));
        private final EconomicMap<HIRBlock, Scope> enclosingScopes;
        private final StructuredGraph.ScheduleResult scheduleResult;
        private final ControlFlowGraph cfg;
        private final HIRBlock[] sortedBlocks;
        private final Deque<ScopeEntry> scopes = new LinkedList<ScopeEntry>();
        private final StackifierData stackifierData;

        private Instance(StructuredGraph graph, StackifierData stackifierData) {
            this.scheduleResult = graph.getLastSchedule();
            this.cfg = this.scheduleResult.getCFG();
            this.stackifierData = stackifierData;
            this.sortedBlocks = new HIRBlock[this.cfg.getBlocks().length];
            this.enclosingScopes = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE, (int)this.sortedBlocks.length);
        }

        private static HIRBlock getSuccessorAt(HIRBlock current, int index) {
            if (current.isLoopEnd()) {
                throw GraalError.shouldNotReachHere("unexpected loop end");
            }
            return (HIRBlock)current.getSuccessorAt(index);
        }

        private static int getSuccessorCount(HIRBlock current) {
            if (current.isLoopEnd()) {
                return 0;
            }
            return current.getSuccessorCount();
        }

        private void sort() {
            int id = 0;
            EconomicMap remainingPredecessorsMap = EconomicMap.create();
            this.initializeRemainingPredecessors((EconomicMap<HIRBlock, Integer>)remainingPredecessorsMap);
            this.freeBlocks.add(this.cfg.getStartBlock());
            while (!this.freeBlocks.isEmpty()) {
                assert (id < this.sortedBlocks.length) : Assertions.errorMessage(id, this.sortedBlocks);
                HIRBlock current = this.freeBlocks.first();
                this.freeBlocks.remove(current);
                this.cfg.graph.getDebug().log("Current free block %s", current);
                if (!this.scopes.isEmpty() && !this.scopes.getFirst().scope.getBlocks().contains((Object)current)) {
                    this.scopes.getFirst().addDeferredBlock(current);
                    this.cfg.graph.getDebug().log("Current block %s deferred by scope %s", (Object)current, (Object)this.scopes.getFirst().scope);
                    continue;
                }
                for (ScopeEntry scopeEntry : this.scopes) {
                    scopeEntry.openBlocks.remove((Object)current);
                }
                this.checkForNewScopes(current);
                if (!this.scopes.isEmpty() && this.scopes.getFirst().openBlocks.isEmpty()) {
                    this.closeScope();
                }
                this.cfg.graph.getDebug().log("Placing %s at %d", (Object)current, id);
                this.sortedBlocks[id] = current;
                ++id;
                for (int i = 0; i < Instance.getSuccessorCount(current); ++i) {
                    HIRBlock successor = Instance.getSuccessorAt(current, i);
                    int remainingPredecessors = (Integer)remainingPredecessorsMap.get((Object)successor) - 1;
                    remainingPredecessorsMap.put((Object)successor, (Object)remainingPredecessors);
                    if (remainingPredecessors != 0) continue;
                    this.freeBlocks.add(successor);
                }
            }
            this.cfg.graph.getDebug().log("Processed [%d/%d] basic blocks", id, this.cfg.getBlocks().length);
            assert (id == this.cfg.getBlocks().length) : "Not all basic blocks have been reached during Stackifier sort";
        }

        private void closeScope() {
            ScopeEntry closedScopeEntry = this.scopes.getFirst();
            assert (closedScopeEntry.openBlocks.isEmpty());
            this.cfg.graph.getDebug().log("Closing scope %s", closedScopeEntry.scope);
            this.scopes.removeFirst();
            for (HIRBlock b : closedScopeEntry.deferredBlocks) {
                this.freeBlocks.add(b);
            }
            if (this.scopes.size() > 0 && this.scopes.getFirst().openBlocks.isEmpty()) {
                this.closeScope();
            }
        }

        private void checkForNewScopes(HIRBlock current) {
            ScopeContainer scopeContainer;
            Scope parent = this.scopes.isEmpty() ? null : this.scopes.getFirst().scope;
            if (current.isLoopHeader()) {
                Scope loopScope = ((LoopScopeContainer)this.stackifierData.getScopeEntry(current.getBeginNode())).getLoopScope();
                this.pushNewScope(current, loopScope);
                this.scopes.getFirst().scope.setParentScope(parent);
                parent = this.scopes.getFirst().scope;
                this.cfg.graph.getDebug().log("New scope %s", loopScope);
            }
            if ((scopeContainer = this.stackifierData.getScopeEntry(current.getEndNode())) != null) {
                if (scopeContainer instanceof IfScopeContainer) {
                    IfScopeContainer ifScopeContainer = (IfScopeContainer)scopeContainer;
                    Scope thenScope = ifScopeContainer.getThenScope();
                    Scope elseScope = ifScopeContainer.getElseScope();
                    if (elseScope != null) {
                        this.pushNewScope(current, elseScope);
                        this.scopes.getFirst().scope.setParentScope(parent);
                        this.cfg.graph.getDebug().log("New scope %s", elseScope);
                    }
                    if (thenScope != null) {
                        this.pushNewScope(current, thenScope);
                        this.scopes.getFirst().scope.setParentScope(parent);
                        this.cfg.graph.getDebug().log("New scope %s", thenScope);
                    }
                } else if (scopeContainer instanceof CatchScopeContainer) {
                    CatchScopeContainer catchScopeContainer = (CatchScopeContainer)scopeContainer;
                    Scope catchScope = catchScopeContainer.getCatchScope();
                    if (catchScope != null) {
                        this.pushNewScope(current, catchScope);
                        this.scopes.getFirst().scope.setParentScope(parent);
                        this.cfg.graph.getDebug().log("New scope %s", catchScope);
                    }
                } else if (scopeContainer instanceof SwitchScopeContainer) {
                    SwitchScopeContainer switchScopeContainer = (SwitchScopeContainer)scopeContainer;
                    Scope[] caseScopes = switchScopeContainer.getCaseScopes();
                    for (int i = caseScopes.length - 1; i >= 0; --i) {
                        if (caseScopes[i] == null) continue;
                        this.pushNewScope(current, caseScopes[i]);
                        this.scopes.getFirst().scope.setParentScope(parent);
                        this.cfg.graph.getDebug().log("New scope %s", caseScopes[i]);
                    }
                }
            }
        }

        private void pushNewScope(HIRBlock current, Scope scope) {
            ScopeEntry newScopeEntry = new ScopeEntry(scope);
            newScopeEntry.openBlocks.remove((Object)current);
            this.scopes.addFirst(newScopeEntry);
            for (HIRBlock b : this.scopes.getFirst().scope.getBlocks()) {
                this.enclosingScopes.put((Object)b, (Object)this.scopes.getFirst().scope);
            }
        }

        private void initializeRemainingPredecessors(EconomicMap<HIRBlock, Integer> remainingPredecessors) {
            for (HIRBlock b : this.cfg.getBlocks()) {
                int predecessors = b.isLoopHeader() ? ((LoopBeginNode)b.getBeginNode()).forwardEndCount() : b.getPredecessorCount();
                remainingPredecessors.put((Object)b, (Object)predecessors);
            }
        }

        public void run() {
            this.sort();
            this.stackifierData.setSortedBlocks(this.sortedBlocks, this.cfg);
            this.stackifierData.setEnclosingScope(this.enclosingScopes);
        }
    }

    private static class ScopeEntry {
        final EconomicSet<HIRBlock> deferredBlocks = EconomicSet.create();
        final EconomicSet<HIRBlock> openBlocks;
        final Scope scope;

        ScopeEntry(Scope currentScope) {
            this.scope = currentScope;
            this.openBlocks = EconomicSet.create(this.scope.getBlocks());
        }

        public void addDeferredBlock(HIRBlock current) {
            this.deferredBlocks.add((Object)current);
        }
    }
}

