/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hightiercodegen.irwalk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.irwalk.BlockVisitHistory;
import jdk.graal.compiler.hightiercodegen.irwalk.IRWalkVerifier;
import jdk.graal.compiler.hightiercodegen.lowerer.PhiResolveLowerer;
import jdk.graal.compiler.hightiercodegen.reconstruction.ReconstructionData;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;

public abstract class IRWalker {
    protected final CodeGenTool codeGenTool;
    protected final ControlFlowGraph cfg;
    protected final BlockMap<List<Node>> blockToNodeMap;
    protected final NodeMap<HIRBlock> nodeToBlockMap;
    protected final IRWalkVerifier verifier;
    protected final BlockVisitHistory blockHistory;
    protected final ReconstructionData reconstructionData;

    public IRWalker(CodeGenTool codeGenTool, ControlFlowGraph cfg, BlockMap<List<Node>> blockToNodeMap, NodeMap<HIRBlock> nodeToBlockMap, ReconstructionData reconstructionData) {
        this.codeGenTool = codeGenTool;
        this.cfg = cfg;
        this.reconstructionData = reconstructionData;
        this.blockHistory = new BlockVisitHistory();
        this.blockToNodeMap = blockToNodeMap;
        this.nodeToBlockMap = nodeToBlockMap;
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (HIRBlock b : cfg.getBlocks()) {
            nodes.addAll((Collection<Node>)blockToNodeMap.get(b));
        }
        this.verifier = new IRWalkVerifier(nodes);
    }

    public void lowerFunction(DebugContext debugContext) {
        try (DebugContext.Scope s = debugContext.scope("Code Flow Verification");){
            this.lower(debugContext);
            this.verifier.verify(this.cfg.graph, this.codeGenTool, this.reconstructionData);
        }
        catch (Throwable t) {
            throw debugContext.handle(new GraalError(t).addContext("graph", this.cfg.graph));
        }
    }

    protected abstract void lower(DebugContext var1);

    protected void lowerLoopEndResolver(LoopEndNode node) {
        new PhiResolveLowerer(node).lower(this.codeGenTool);
    }

    protected boolean lowerNode(Node n) {
        if (this.codeGenTool.nodeLowerer().isTopLevelStatement(n)) {
            this.codeGenTool.lowerStatement(n);
            return true;
        }
        return false;
    }
}

