/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.graal.compiler.graphio.parsing.BinaryReader;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputBytecode;
import jdk.graal.compiler.graphio.parsing.model.Properties;

public class InputMethod
extends Properties.Entity {
    private final BinaryReader.Method method;
    private final String name;
    private final int bci;
    private final String shortName;
    private final List<InputMethod> inlined;
    private InputMethod parentMethod;
    private final Group group;
    private final List<InputBytecode> bytecodes;

    public BinaryReader.Method getMethod() {
        return this.method;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.name);
        result = result * 31 + this.bci;
        result = result * 31 + Objects.hashCode(this.shortName);
        result = result * 31 + Objects.hashCode(this.inlined);
        result = result * 31 + Objects.hashCode(this.bytecodes);
        result = result * 31 + Objects.hashCode(this.method);
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof InputMethod)) {
            return false;
        }
        InputMethod im = (InputMethod)o;
        return Objects.equals(this.name, im.name) && this.bci == im.bci && Objects.equals(this.shortName, im.shortName) && Objects.equals(this.inlined, im.inlined) && Objects.equals(this.bytecodes, im.bytecodes) && Objects.equals(this.method, im.method);
    }

    public InputMethod(Group parent, String name, String shortName, int bci, BinaryReader.Method method) {
        this.group = parent;
        this.name = name;
        this.bci = bci;
        this.shortName = shortName;
        this.inlined = new ArrayList<InputMethod>();
        this.bytecodes = new ArrayList<InputBytecode>();
        if (method != null) {
            this.setBytecodes(method.code);
        }
        this.method = method;
    }

    public List<InputBytecode> getBytecodes() {
        return Collections.unmodifiableList(this.bytecodes);
    }

    public List<InputMethod> getInlined() {
        return Collections.unmodifiableList(this.inlined);
    }

    public void addInlined(InputMethod m) {
        for (InputMethod m2 : this.inlined) {
            assert (m2.getBci() != m.getBci());
        }
        this.inlined.add(m);
        assert (m.parentMethod == null);
        m.parentMethod = this;
        for (InputBytecode bc : this.bytecodes) {
            if (bc.getBci() != m.getBci()) continue;
            bc.setInlined(m);
        }
    }

    public Group getGroup() {
        return this.group;
    }

    public String getShortName() {
        return this.shortName;
    }

    private void setBytecodes(byte[] code) {
        if (code == null || code.length == 0) {
            return;
        }
        InputBytecode.parseCode(code, this.bytecodes, this.inlined);
    }

    public void setBytecodes(String text) {
        Pattern instruction = Pattern.compile("\\s*(\\d+)\\s*:?\\s*(\\w+)\\s*(.*)(?://(.*))?");
        String[] strings = text.split("\n");
        int oldBci = -1;
        block0: for (String string : strings) {
            String s;
            if (string.startsWith(" ") || (s = string.trim()).isEmpty()) continue;
            Matcher matcher = instruction.matcher(s);
            if (matcher.matches()) {
                String bciString = matcher.group(1);
                String opcode = matcher.group(2);
                String operands = matcher.group(3).trim();
                String comment = matcher.group(4);
                if (comment != null) {
                    comment = comment.trim();
                }
                int curBci = Integer.parseInt(bciString);
                assert (curBci > oldBci);
                InputBytecode bc = new InputBytecode(curBci, opcode, operands, comment);
                this.bytecodes.add(bc);
                for (InputMethod m : this.inlined) {
                    if (m.getBci() != curBci) continue;
                    bc.setInlined(m);
                    continue block0;
                }
                continue;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Unparseable bytecode: " + s);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getBci() {
        return this.bci;
    }
}

