/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing.model;

import java.util.ArrayList;
import java.util.List;

public abstract class Event<L> {
    protected final List<L> listener = new ArrayList<L>();
    private volatile boolean fireEvents = true;
    private volatile boolean eventWasFired;

    public void addListener(L l) {
        this.listener.add(l);
    }

    public void removeListener(L l) {
        this.listener.remove(l);
    }

    protected synchronized List<L> getListeners() {
        return new ArrayList<L>(this.listener);
    }

    public void fire() {
        if (this.fireEvents) {
            List<L> tmpList = this.getListeners();
            for (L l : tmpList) {
                this.fire(l);
            }
        } else {
            this.eventWasFired = true;
        }
    }

    public synchronized void beginAtomic() {
        assert (this.fireEvents) : "endAtomic has to be called before another beginAtomic may be called";
        this.fireEvents = false;
        this.eventWasFired = false;
    }

    public synchronized void endAtomic() {
        assert (!this.fireEvents) : "beginAtomic has to be called first";
        this.fireEvents = true;
        if (this.eventWasFired) {
            this.fire();
        }
    }

    protected abstract void fire(L var1);
}

