/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing;

import java.util.Objects;

public final class LocationStratum {
    public final String uri;
    public final String file;
    public final String language;
    public final int line;
    public final int startOffset;
    public final int endOffset;

    private static String intern(String a) {
        if (a != null) {
            return a.intern();
        }
        return null;
    }

    LocationStratum(String uri, String file, String language, int line, int startOffset, int endOffset) {
        this.uri = LocationStratum.intern(uri);
        this.file = LocationStratum.intern(file);
        this.language = LocationStratum.intern(language);
        this.line = line;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.uri);
        hash = 41 * hash + Objects.hashCode(this.file);
        hash = 41 * hash + Objects.hashCode(this.language);
        hash = 41 * hash + this.line;
        hash = 41 * hash + this.startOffset;
        hash = 41 * hash + this.endOffset;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationStratum other = (LocationStratum)obj;
        if (this.line != other.line) {
            return false;
        }
        if (this.startOffset != other.startOffset) {
            return false;
        }
        if (this.endOffset != other.endOffset) {
            return false;
        }
        if (!Objects.equals(this.uri, other.uri)) {
            return false;
        }
        if (!Objects.equals(this.file, other.file)) {
            return false;
        }
        return Objects.equals(this.language, other.language);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.language).append("/");
        sb.append(this.uri != null ? this.uri : this.file);
        sb.append(":").append(this.line);
        if (this.startOffset > -1 || this.endOffset > -1) {
            sb.append("(");
            if (this.startOffset > -1) {
                sb.append(this.startOffset);
            }
            sb.append("-");
            if (this.endOffset > -1) {
                sb.append(this.endOffset);
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

