/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graph.iterators;

import java.util.Iterator;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.NodeIterator;
import jdk.graal.compiler.graph.iterators.NodePredicate;

public class PredicatedProxyNodeIterator<T extends Node>
extends NodeIterator<T> {
    private final Iterator<T> iterator;
    private final NodePredicate predicate;

    public PredicatedProxyNodeIterator(Iterator<T> iterator, NodePredicate predicate) {
        this.iterator = iterator;
        this.predicate = predicate;
    }

    @Override
    protected void forward() {
        while (this.iterator.hasNext()) {
            Node c = (Node)this.iterator.next();
            if (c == null || !c.isAlive() || !this.predicate.apply(c)) continue;
            this.current = c;
            return;
        }
        this.current = null;
    }
}

