/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graph;

import jdk.graal.compiler.graph.Edges;
import jdk.graal.compiler.graph.InputEdges;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodeinfo.InputType;

public final class Position {
    private final Edges edges;
    private final int index;
    private final int subIndex;

    public Position(Edges edges, int index, int subIndex) {
        this.edges = edges;
        this.index = index;
        this.subIndex = subIndex;
    }

    public Node get(Node node) {
        if (this.index < this.edges.getDirectCount()) {
            return Edges.getNode(node, this.edges.getOffsets(), this.index);
        }
        return Edges.getNodeList(node, this.edges.getOffsets(), this.index).get(this.subIndex);
    }

    public InputType getInputType() {
        return ((InputEdges)this.edges).getInputType(this.index);
    }

    public String getName() {
        return this.edges.getName(this.index);
    }

    public boolean isInputOptional() {
        return ((InputEdges)this.edges).isOptional(this.index);
    }

    public void set(Node node, Node value) {
        if (this.index < this.edges.getDirectCount()) {
            this.edges.setNode(node, this.index, value);
        } else {
            Edges.getNodeList(node, this.edges.getOffsets(), this.index).set(this.subIndex, value);
        }
    }

    public void initialize(Node node, Node value) {
        if (this.index < this.edges.getDirectCount()) {
            this.edges.initializeNode(node, this.index, value);
        } else {
            Edges.getNodeList(node, this.edges.getOffsets(), this.index).initialize(this.subIndex, value);
        }
    }

    public String toString() {
        String res = this.edges.getType(this.index).getSimpleName() + ":" + this.edges.getName(this.index);
        if (this.subIndex != -1) {
            res = res + "[" + this.subIndex + "]";
        }
        return res;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        result = 31 * result + this.edges.hashCode();
        result = 31 * result + this.subIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        if (this.index != other.index) {
            return false;
        }
        if (this.edges != other.edges) {
            return false;
        }
        return this.subIndex == other.subIndex;
    }

    public int getSubIndex() {
        return this.subIndex;
    }

    public int getIndex() {
        return this.index;
    }

    public Class<?> getType() {
        if (this.index < this.edges.getDirectCount()) {
            return this.edges.getType(this.index);
        }
        return Node.class;
    }
}

