/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graph;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.graph.Node;

class NodeUsageIterator
implements Iterator<Node> {
    final Node node;
    int index = -1;
    Node current;

    void advance() {
        this.current = null;
        ++this.index;
        if (this.index == 0) {
            this.current = this.node.usage0;
        } else if (this.index == 1) {
            this.current = this.node.usage1;
        } else {
            int relativeIndex = this.index - 2;
            if (relativeIndex < this.node.extraUsagesCount) {
                this.current = this.node.extraUsages[relativeIndex];
            }
        }
    }

    NodeUsageIterator(Node node) {
        this.node = node;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public Node next() {
        Node result = this.current;
        if (result == null) {
            throw new NoSuchElementException();
        }
        this.advance();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

