/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graph;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;

public final class NodeFlood
implements Iterable<Node> {
    private final NodeBitMap visited;
    private final Queue<Node> worklist;
    private int totalMarkedCount;

    public NodeFlood(Graph graph) {
        this.visited = graph.createNodeBitMap();
        this.worklist = new ArrayDeque<Node>();
    }

    public void add(Node node) {
        if (node != null && !this.visited.isMarked(node)) {
            this.visited.mark(node);
            this.worklist.add(node);
            ++this.totalMarkedCount;
        }
    }

    public int getTotalMarkedCount() {
        return this.totalMarkedCount;
    }

    public void addAll(Iterable<? extends Node> nodes) {
        for (Node node : nodes) {
            this.add(node);
        }
    }

    public NodeBitMap getVisited() {
        return this.visited;
    }

    public boolean isMarked(Node node) {
        return this.visited.isMarked(node);
    }

    public boolean isNew(Node node) {
        return this.visited.isNew(node);
    }

    @Override
    public Iterator<Node> iterator() {
        return new QueueConsumingIterator(this.worklist);
    }

    private static class QueueConsumingIterator
    implements Iterator<Node> {
        private final Queue<Node> queue;

        QueueConsumingIterator(Queue<Node> queue) {
            this.queue = queue;
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public Node next() {
            return this.queue.remove();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

