/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graph;

import jdk.graal.compiler.debug.GraalError;

public class LinkedStack<T> {
    final LinkedListNode<T> dummyHead = new LinkedListNode<Object>(null);

    public void push(T data) {
        LinkedListNode prevHead = this.dummyHead.next;
        LinkedListNode<T> newHead = new LinkedListNode<T>(data);
        newHead.next = prevHead;
        this.dummyHead.next = newHead;
    }

    public T pop() {
        GraalError.guarantee(!this.isEmpty(), "Cannot pop on empty stack");
        LinkedListNode prevHead = this.dummyHead.next;
        this.dummyHead.next = prevHead.next;
        return prevHead.data;
    }

    public boolean isEmpty() {
        return this.dummyHead.next == null;
    }

    public T peek() {
        GraalError.guarantee(!this.isEmpty(), "Cannot peek on empty stack");
        LinkedListNode head = this.dummyHead.next;
        return head.data;
    }

    private static class LinkedListNode<T> {
        LinkedListNode<T> next;
        T data;

        LinkedListNode(T data) {
            this.data = data;
        }
    }
}

