/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graph;

import java.util.ArrayList;
import jdk.graal.compiler.graph.Edges;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;

public final class InputEdges
extends Edges {
    private final InputType[] inputTypes;
    private final boolean[] isOptional;

    public InputEdges(int directCount, ArrayList<NodeClass.InputInfo> edges) {
        super(Edges.Type.Inputs, directCount, edges);
        this.inputTypes = new InputType[edges.size()];
        this.isOptional = new boolean[edges.size()];
        for (int i = 0; i < edges.size(); ++i) {
            this.inputTypes[i] = edges.get((int)i).inputType;
            this.isOptional[i] = edges.get((int)i).optional;
        }
    }

    public static void translateInto(InputEdges inputs, ArrayList<NodeClass.InputInfo> infos) {
        for (int index = 0; index < inputs.getCount(); ++index) {
            infos.add(new NodeClass.InputInfo(inputs.offsets[index], inputs.getName(index), inputs.getType(index), inputs.getDeclaringClass(index), inputs.inputTypes[index], inputs.isOptional(index)));
        }
    }

    public InputType getInputType(int index) {
        return this.inputTypes[index];
    }

    public boolean isOptional(int index) {
        return this.isOptional[index];
    }

    @Override
    public void update(Node node, Node oldValue, Node newValue) {
        node.updateUsages(oldValue, newValue);
    }
}

