/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import java.util.concurrent.TimeUnit;
import jdk.graal.compiler.debug.AccumulatedKey;
import jdk.graal.compiler.debug.BaseTimerKey;
import jdk.graal.compiler.debug.DebugContext;
import org.graalvm.collections.Pair;

final class WallClockTimerKey
extends BaseTimerKey {
    WallClockTimerKey(String nameFormat, Object nameArg1, Object nameArg2) {
        super(nameFormat, nameArg1, nameArg2);
    }

    @Override
    protected BaseTimerKey.Timer createTimerInstance(DebugContext debug) {
        return new WallClockTimer(this, debug);
    }

    @Override
    public TimeUnit getTimeUnit() {
        return TimeUnit.NANOSECONDS;
    }

    @Override
    public String toHumanReadableFormat(long value) {
        return String.format("%d ms", value);
    }

    @Override
    public Pair<String, String> toCSVFormat(long value) {
        return Pair.create((Object)Long.toString(value), (Object)"ms");
    }

    static final class WallClockTimer
    extends BaseTimerKey.Timer {
        WallClockTimer(AccumulatedKey counter, DebugContext debug) {
            super(counter, debug);
        }

        @Override
        long getCounterValue() {
            return System.nanoTime();
        }
    }
}

