/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.function.Supplier;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.debug.PathUtilities;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.common.NativeImageReinitialize;
import org.graalvm.nativeimage.ImageInfo;

final class IgvDumpChannel
implements WritableByteChannel {
    private static final String ENABLE_NETWORK_DUMPING_PROP = "debug.jdk.graal.enableNetworkDumping";
    private static final boolean ENABLE_NETWORK_DUMPING = Boolean.parseBoolean(GraalServices.getSavedProperty("debug.jdk.graal.enableNetworkDumping"));
    private final Supplier<String> pathProvider;
    private final OptionValues options;
    private WritableByteChannel sharedChannel;
    private boolean closed;
    @NativeImageReinitialize
    private static boolean networkDumpingUnsupportedWarned;
    @NativeImageReinitialize
    private static String lastTargetAnnouncement;

    IgvDumpChannel(Supplier<String> pathProvider, OptionValues options) {
        this.pathProvider = pathProvider;
        this.options = options;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        WritableByteChannel channel = this.channel();
        return channel == null ? 0 : channel.write(src);
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
    }

    void realClose() throws IOException {
        this.closed = true;
        if (this.sharedChannel != null) {
            this.sharedChannel.close();
            this.sharedChannel = null;
        }
    }

    WritableByteChannel channel() throws IOException {
        if (this.closed) {
            throw new IOException("already closed");
        }
        if (this.sharedChannel == null) {
            DebugOptions.PrintGraphTarget target = (DebugOptions.PrintGraphTarget)((Object)DebugOptions.PrintGraph.getValue(this.options));
            if (target == DebugOptions.PrintGraphTarget.File) {
                this.sharedChannel = IgvDumpChannel.createFileChannel(this.pathProvider, null);
            } else if (target == DebugOptions.PrintGraphTarget.Network) {
                if (ImageInfo.inImageRuntimeCode() && !ENABLE_NETWORK_DUMPING) {
                    if (!networkDumpingUnsupportedWarned) {
                        networkDumpingUnsupportedWarned = true;
                        TTY.printf("WARNING: Graph dumping to network not supported as the %s system property was false when building libgraal - dumping to file instead.%n", ENABLE_NETWORK_DUMPING_PROP);
                    }
                    this.sharedChannel = IgvDumpChannel.createFileChannel(this.pathProvider, null);
                } else {
                    this.sharedChannel = IgvDumpChannel.createNetworkChannel(this.pathProvider, this.options);
                }
            } else {
                TTY.println("WARNING: Graph dumping requested but value of %s option is %s", new Object[]{DebugOptions.PrintGraph.getName(), DebugOptions.PrintGraphTarget.Disable});
            }
        }
        return this.sharedChannel;
    }

    private static WritableByteChannel createNetworkChannel(Supplier<String> pathProvider, OptionValues options) throws IOException {
        String host = DebugOptions.PrintGraphHost.getValue(options);
        int port = DebugOptions.PrintGraphPort.getValue(options);
        try {
            SocketChannel channel = SocketChannel.open(new InetSocketAddress(host, port));
            String targetAnnouncement = String.format("Connected to the IGV on %s:%d", host, port);
            IgvDumpChannel.maybeAnnounceTarget(targetAnnouncement);
            return channel;
        }
        catch (InterruptedIOException | ClosedByInterruptException e) {
            return null;
        }
        catch (IOException e) {
            String networkFailure = String.format("Could not connect to the IGV on %s:%d", host, port);
            if (pathProvider != null) {
                return IgvDumpChannel.createFileChannel(pathProvider, networkFailure);
            }
            throw new IOException(networkFailure, e);
        }
    }

    private static void maybeAnnounceTarget(String targetAnnouncement) {
        if (!targetAnnouncement.equals(lastTargetAnnouncement)) {
            lastTargetAnnouncement = targetAnnouncement;
            TTY.println(targetAnnouncement);
        }
    }

    private static WritableByteChannel createFileChannel(Supplier<String> pathProvider, String networkFailure) throws IOException {
        String path = pathProvider.get();
        try {
            String dir;
            WritableByteChannel channel = PathUtilities.openFileChannel(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            String string = dir = PathUtilities.isDirectory(path, false) ? path : PathUtilities.getParent(path);
            if (networkFailure == null) {
                IgvDumpChannel.maybeAnnounceTarget("Dumping IGV graphs in " + dir);
            } else {
                IgvDumpChannel.maybeAnnounceTarget(networkFailure + ". Dumping IGV graphs in " + dir);
            }
            return channel;
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to open %s to dump IGV graphs", path), e);
        }
    }
}

