/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import java.util.concurrent.TimeUnit;
import jdk.graal.compiler.debug.AccumulatedKey;
import jdk.graal.compiler.debug.BaseTimerKey;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.TimeSource;
import org.graalvm.collections.Pair;

final class CPUTimerKey
extends BaseTimerKey {
    CPUTimerKey(String nameFormat, Object nameArg1, Object nameArg2) {
        super(nameFormat, nameArg1, nameArg2);
    }

    @Override
    public String toHumanReadableFormat(long value) {
        return String.format("%d.%d ms", value / 1000000L, value / 100000L % 10L);
    }

    @Override
    public Pair<String, String> toCSVFormat(long value) {
        return Pair.create((Object)Long.toString(value / 1000L), (Object)"us");
    }

    @Override
    protected BaseTimerKey.Timer createTimerInstance(DebugContext debug) {
        return new CPUTimer(this, debug);
    }

    @Override
    public TimeUnit getTimeUnit() {
        return TimeUnit.NANOSECONDS;
    }

    static class CPUTimer
    extends BaseTimerKey.Timer {
        CPUTimer(AccumulatedKey counter, DebugContext debug) {
            super(counter, debug);
        }

        @Override
        protected long getCounterValue() {
            return TimeSource.getTimeNS();
        }
    }
}

