/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import java.util.concurrent.TimeUnit;
import jdk.graal.compiler.debug.AbstractKey;
import jdk.graal.compiler.debug.AccumulatedKey;
import jdk.graal.compiler.debug.CloseableCounter;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.TimerKey;
import org.graalvm.collections.Pair;

abstract class BaseTimerKey
extends AccumulatedKey
implements TimerKey {
    BaseTimerKey(String nameFormat, Object nameArg1, Object nameArg2) {
        super(new FlatTimer(nameFormat, nameArg1, nameArg2), nameFormat, nameArg1, nameArg2);
        ((FlatTimer)this.flat).accm = this;
    }

    @Override
    public DebugCloseable start(DebugContext debug) {
        if (debug.isTimerEnabled(this)) {
            Timer result = this.createTimerInstance(debug);
            debug.currentTimer = result;
            return result;
        }
        return DebugCloseable.VOID_CLOSEABLE;
    }

    @Override
    public TimerKey getFlat() {
        return (FlatTimer)this.flat;
    }

    protected abstract Timer createTimerInstance(DebugContext var1);

    @Override
    public TimerKey doc(String doc) {
        this.setDoc(doc);
        return this;
    }

    static final class FlatTimer
    extends AbstractKey
    implements TimerKey {
        private BaseTimerKey accm;

        FlatTimer(String nameFormat, Object nameArg1, Object nameArg2) {
            super(nameFormat, nameArg1, nameArg2);
        }

        @Override
        protected String createName(String format, Object arg1, Object arg2) {
            return super.createName(format, arg1, arg2) + "_Flat";
        }

        @Override
        public TimeUnit getTimeUnit() {
            return this.accm.getTimeUnit();
        }

        @Override
        public DebugCloseable start(DebugContext debug) {
            return this.accm.start(debug);
        }

        @Override
        public TimerKey doc(String doc) {
            throw new IllegalArgumentException("Cannot set documentation for derived key " + this.getName());
        }

        @Override
        public String toHumanReadableFormat(long value) {
            return this.accm.toHumanReadableFormat(value);
        }

        @Override
        public Pair<String, String> toCSVFormat(long value) {
            return this.accm.toCSVFormat(value);
        }

        @Override
        public String getDocName() {
            return null;
        }
    }

    static abstract class Timer
    extends CloseableCounter
    implements DebugCloseable {
        final DebugContext debug;

        Timer(AccumulatedKey counter, DebugContext debug) {
            super(debug, debug.currentTimer, counter);
            this.debug = debug;
        }

        @Override
        public void close() {
            super.close();
            this.debug.currentTimer = this.parent;
        }
    }
}

