/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.phases.fuzzing;

import jdk.graal.compiler.core.phases.fuzzing.AbstractCompilationPlan;
import jdk.graal.compiler.core.phases.fuzzing.MinimalFuzzedTierPlan;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.tiers.LowTierContext;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.graal.compiler.phases.tiers.Suites;

public class MinimalFuzzedCompilationPlan
extends AbstractCompilationPlan {
    private final long randomSeed;

    protected MinimalFuzzedCompilationPlan(MinimalFuzzedTierPlan<HighTierContext> minimalHighTier, MinimalFuzzedTierPlan<MidTierContext> minimalMidTier, MinimalFuzzedTierPlan<LowTierContext> minimalLowTier, GraphState graphState, GraphState.MandatoryStages mandatoryStages, long randomSeed) {
        super(minimalHighTier, minimalMidTier, minimalLowTier, graphState, mandatoryStages);
        this.randomSeed = randomSeed;
        this.verifyCompilationPlan(graphState);
    }

    private MinimalFuzzedCompilationPlan(MinimalFuzzedTierPlan<HighTierContext> minimalHighTier, MinimalFuzzedTierPlan<MidTierContext> minimalMidTier, MinimalFuzzedTierPlan<LowTierContext> minimalLowTier, GraphState.MandatoryStages mandatoryStages, long randomSeed) {
        super(minimalHighTier, minimalMidTier, minimalLowTier, mandatoryStages);
        this.randomSeed = randomSeed;
    }

    public static MinimalFuzzedCompilationPlan createMinimalFuzzedCompilationPlan(Suites originalSuites, GraphState graphState, GraphState.MandatoryStages mandatoryStages, long randomSeed) {
        GraphState graphStateCopy = graphState.copy();
        MinimalFuzzedCompilationPlan.addInitialRequiredStages(graphStateCopy);
        MinimalFuzzedTierPlan highTier = MinimalFuzzedTierPlan.create(originalSuites.getHighTier().getPhases(), graphStateCopy, mandatoryStages.getHighTier(), randomSeed, "High tier");
        highTier.updateGraphState(graphStateCopy);
        MinimalFuzzedTierPlan midTier = MinimalFuzzedTierPlan.create(originalSuites.getMidTier().getPhases(), graphStateCopy, mandatoryStages.getMidTier(), randomSeed, "Mid tier");
        midTier.updateGraphState(graphStateCopy);
        MinimalFuzzedTierPlan lowTier = MinimalFuzzedTierPlan.create(originalSuites.getLowTier().getPhases(), graphStateCopy, mandatoryStages.getLowTier(), randomSeed, "Low tier");
        return new MinimalFuzzedCompilationPlan(highTier, midTier, lowTier, graphState, mandatoryStages, randomSeed);
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    @Override
    public String toString() {
        String phasePlan = super.toString();
        return String.format("The %sminimal fuzzed compilation plan based on random seed %s (-Dtest.graal.compilationplan.fuzzing.seed=%s) is:%n%s", AbstractCompilationPlan.PrintingUtils.printFailing(phasePlan), this.getRandomSeed(), this.getRandomSeed(), AbstractCompilationPlan.PrintingUtils.indent(phasePlan));
    }

    public MinimalFuzzedCompilationPlan copy() {
        return new MinimalFuzzedCompilationPlan(((MinimalFuzzedTierPlan)this.getHighTier()).copy(), ((MinimalFuzzedTierPlan)this.getMidTier()).copy(), ((MinimalFuzzedTierPlan)this.getLowTier()).copy(), this.getMandatoryStages(), this.getRandomSeed());
    }
}

