/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.phases;

import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.phases.BaseTier;
import jdk.graal.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import jdk.graal.compiler.loop.phases.LoopFullUnrollPhase;
import jdk.graal.compiler.loop.phases.LoopPeelingPhase;
import jdk.graal.compiler.loop.phases.LoopUnswitchingPhase;
import jdk.graal.compiler.nodes.loop.DefaultLoopPolicies;
import jdk.graal.compiler.nodes.loop.LoopPolicies;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.common.BoxNodeIdentityPhase;
import jdk.graal.compiler.phases.common.BoxNodeOptimizationPhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.DeadCodeEliminationPhase;
import jdk.graal.compiler.phases.common.DisableOverflownCountedLoopsPhase;
import jdk.graal.compiler.phases.common.DominatorBasedGlobalValueNumberingPhase;
import jdk.graal.compiler.phases.common.HighTierLoweringPhase;
import jdk.graal.compiler.phases.common.IterativeConditionalEliminationPhase;
import jdk.graal.compiler.phases.common.inlining.InliningPhase;
import jdk.graal.compiler.phases.common.inlining.policy.GreedyInliningPolicy;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.virtual.phases.ea.FinalPartialEscapePhase;
import jdk.graal.compiler.virtual.phases.ea.ReadEliminationPhase;

public class HighTier
extends BaseTier<HighTierContext> {
    public HighTier(OptionValues options) {
        CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
        this.appendPhase(canonicalizer);
        if (Options.Inline.getValue(options).booleanValue()) {
            this.appendPhase(new InliningPhase(new GreedyInliningPolicy(null), canonicalizer));
            this.appendPhase(new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional));
        }
        this.appendPhase(new DisableOverflownCountedLoopsPhase());
        if (GraalOptions.OptConvertDeoptsToGuards.getValue(options).booleanValue()) {
            this.appendPhase(new ConvertDeoptimizeToGuardPhase(canonicalizer));
        }
        if (GraalOptions.ConditionalElimination.getValue(options).booleanValue()) {
            this.appendPhase(new IterativeConditionalEliminationPhase(canonicalizer, false));
        }
        if (GraalOptions.EarlyGVN.getValue(options).booleanValue()) {
            this.appendPhase(new DominatorBasedGlobalValueNumberingPhase(canonicalizer));
        }
        LoopPolicies loopPolicies = this.createLoopPolicies(options);
        if (GraalOptions.FullUnroll.getValue(options).booleanValue()) {
            this.appendPhase(new LoopFullUnrollPhase(canonicalizer, loopPolicies));
        }
        if (GraalOptions.LoopPeeling.getValue(options).booleanValue()) {
            this.appendPhase(new LoopPeelingPhase(loopPolicies, canonicalizer));
        }
        if (GraalOptions.LoopUnswitch.getValue(options).booleanValue()) {
            this.appendPhase(new LoopUnswitchingPhase(loopPolicies, canonicalizer));
        }
        this.appendPhase(new BoxNodeIdentityPhase());
        if (GraalOptions.PartialEscapeAnalysis.getValue(options).booleanValue()) {
            this.appendPhase(new FinalPartialEscapePhase(true, canonicalizer, null, options));
        }
        if (GraalOptions.OptReadElimination.getValue(options).booleanValue()) {
            this.appendPhase(new ReadEliminationPhase(canonicalizer));
        }
        this.appendPhase(new BoxNodeOptimizationPhase(canonicalizer));
        this.appendPhase(new HighTierLoweringPhase(canonicalizer, true));
    }

    @Override
    public LoopPolicies createLoopPolicies(OptionValues options) {
        return new DefaultLoopPolicies();
    }

    public static class Options {
        public static final OptionKey<Boolean> Inline = new OptionKey<Boolean>(true);
    }
}

