/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.SpectrePHTMitigations;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.gen.DebugInfoBuilder;
import jdk.graal.compiler.core.gen.InstructionPrinter;
import jdk.graal.compiler.core.gen.NodeMatchRules;
import jdk.graal.compiler.core.match.ComplexMatchValue;
import jdk.graal.compiler.core.match.MatchPattern;
import jdk.graal.compiler.core.match.MatchRuleRegistry;
import jdk.graal.compiler.core.match.MatchStatement;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.graph.GraalGraphError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.lir.FullInfopointOp;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LabelRef;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.SwitchStrategy;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.debug.LIRGenerationDebugContext;
import jdk.graal.compiler.lir.framemap.FrameMapBuilder;
import jdk.graal.compiler.lir.gen.LIRGenerator;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.DirectCallTargetNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.FullInfopointNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.ImplicitNullCheckNode;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.LoweredCallTargetNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.IntegerTestNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.OpMaskOrTestNode;
import jdk.graal.compiler.nodes.calc.OpMaskTestNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.extended.IntegerSwitchNode;
import jdk.graal.compiler.nodes.extended.OpaqueLogicNode;
import jdk.graal.compiler.nodes.extended.SwitchNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.NodeValueMap;
import jdk.graal.compiler.nodes.spi.NodeWithState;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public abstract class NodeLIRBuilder
implements NodeLIRBuilderTool,
LIRGenerationDebugContext {
    private final NodeMap<Value> nodeOperands;
    private final DebugInfoBuilder debugInfoBuilder;
    private final int traceLIRGeneratorLevel;
    protected final LIRGenerator gen;
    private ValueNode currentInstruction;
    private ValueNode lastInstructionPrinted;
    private final NodeMatchRules nodeMatchRules;
    private EconomicMap<Class<? extends Node>, List<MatchStatement>> matchRules;
    private EconomicMap<Node, Integer> sharedMatchCounts;

    public NodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool gen, NodeMatchRules nodeMatchRules) {
        this.gen = (LIRGenerator)gen;
        this.nodeMatchRules = nodeMatchRules;
        this.nodeOperands = graph.createNodeMap();
        this.debugInfoBuilder = this.createDebugInfoBuilder(graph, this);
        OptionValues options = graph.getOptions();
        if (GraalOptions.MatchExpressions.getValue(options).booleanValue()) {
            this.matchRules = MatchRuleRegistry.lookup(nodeMatchRules.getClass(), options, graph.getDebug());
            this.sharedMatchCounts = EconomicMap.create();
        }
        int n = this.traceLIRGeneratorLevel = TTY.isSuppressed() ? 0 : LIRGenerator.Options.TraceLIRGeneratorLevel.getValue(options);
        assert (nodeMatchRules.lirBuilder == null);
        nodeMatchRules.lirBuilder = this;
    }

    public NodeMatchRules getNodeMatchRules() {
        return this.nodeMatchRules;
    }

    protected DebugInfoBuilder createDebugInfoBuilder(StructuredGraph graph, NodeValueMap nodeValueMap) {
        return new DebugInfoBuilder(nodeValueMap, this.gen.getProviders().getMetaAccessExtensionProvider(), graph.getDebug());
    }

    @Override
    public Value operand(Node node) {
        Value operand = this.getOperand(node);
        assert (operand != null) : String.format("missing operand for %1s", node);
        return operand;
    }

    @Override
    public boolean hasOperand(Node node) {
        return this.getOperand(node) != null;
    }

    private Value getOperand(Node node) {
        if (this.nodeOperands == null) {
            return null;
        }
        return this.nodeOperands.get(node);
    }

    @Override
    public ValueNode valueForOperand(Value value) {
        assert (this.nodeOperands != null);
        MapCursor<Node, Value> cursor = this.nodeOperands.getEntries();
        while (cursor.advance()) {
            if (!((Value)cursor.getValue()).equals((Object)value)) continue;
            return (ValueNode)cursor.getKey();
        }
        return null;
    }

    @Override
    public Object getSourceForOperand(Value value) {
        return this.valueForOperand(value);
    }

    @Override
    public Value setResult(ValueNode x, Value operand) {
        assert (!ValueUtil.isRegister((Value)operand) || !this.gen.attributes(ValueUtil.asRegister((Value)operand)).isAllocatable());
        assert (this.nodeOperands != null && (this.nodeOperands.get(x) == null || this.nodeOperands.get(x) instanceof ComplexMatchValue)) : "operand cannot be set twice";
        assert (operand != null && ValueUtil.isLegal((Value)operand)) : "operand must be legal";
        assert (!(x instanceof VirtualObjectNode)) : Assertions.errorMessage(x);
        this.nodeOperands.set(x, operand);
        return operand;
    }

    public void setMatchResult(Node x, Value operand) {
        assert (operand.equals((Object)ComplexMatchValue.INTERIOR_MATCH) || operand instanceof ComplexMatchValue) : Assertions.errorMessage(x, operand);
        assert (operand instanceof ComplexMatchValue || MatchPattern.isSingleValueUser(x)) : "interior matches must be single user";
        assert (this.nodeOperands != null && this.nodeOperands.get(x) == null) : "operand cannot be set twice";
        assert (!(x instanceof VirtualObjectNode)) : Assertions.errorMessage(x, operand);
        this.nodeOperands.set(x, operand);
    }

    public void incrementSharedMatchCount(Node node) {
        assert (this.nodeOperands != null && this.nodeOperands.get(node) == null) : "operand cannot be set twice";
        Integer matchValue = (Integer)this.sharedMatchCounts.get((Object)node);
        if (matchValue == null) {
            matchValue = 0;
        }
        matchValue = matchValue + 1;
        this.sharedMatchCounts.put((Object)node, (Object)matchValue);
        if (node.getUsageCount() == matchValue.intValue()) {
            this.nodeOperands.set(node, ComplexMatchValue.INTERIOR_MATCH);
        }
    }

    public LabelRef getLIRBlock(FixedNode b) {
        assert (this.gen.getResult().getLIR().getControlFlowGraph() instanceof ControlFlowGraph) : Assertions.errorMessage(this.gen.getResult().getLIR().getControlFlowGraph());
        HIRBlock result = ((ControlFlowGraph)this.gen.getResult().getLIR().getControlFlowGraph()).blockFor(b);
        int suxIndex = 0;
        for (int i = 0; i < this.gen.getCurrentBlock().getSuccessorCount(); ++i) {
            Object succ = this.gen.getCurrentBlock().getSuccessorAt(i);
            if (succ == result) {
                assert (this.gen.getCurrentBlock() instanceof HIRBlock) : Assertions.errorMessage(this.gen.getCurrentBlock());
                return LabelRef.forSuccessor(this.gen.getResult().getLIR(), this.gen.getCurrentBlock(), suxIndex);
            }
            ++suxIndex;
        }
        throw GraalError.shouldNotReachHere("Block not in successor list of current block");
    }

    public final void append(LIRInstruction op) {
        if (LIRGenerator.Options.PrintIRWithLIR.getValue(this.nodeOperands.graph().getOptions()).booleanValue() && !TTY.isSuppressed() && this.currentInstruction != null && this.lastInstructionPrinted != this.currentInstruction) {
            this.lastInstructionPrinted = this.currentInstruction;
            InstructionPrinter ip = new InstructionPrinter(TTY.out());
            ip.printInstructionListing(this.currentInstruction);
        }
        this.gen.append(op);
    }

    protected LIRKind getExactPhiKind(PhiNode phi) {
        LIRKind derivedKind = this.gen.toRegisterKind(this.gen.getLIRKind(phi.stamp(NodeView.DEFAULT)));
        for (int i = 0; i < phi.valueCount() && !derivedKind.isUnknownReference(); ++i) {
            LIRKind valueKind;
            ValueNode node = phi.valueAt(i);
            Value value = this.getOperand(node);
            if (value != null && !(value instanceof ComplexMatchValue)) {
                valueKind = (LIRKind)value.getValueKind(LIRKind.class);
            } else {
                assert (NodeLIRBuilder.isPhiInputFromBackedge(phi, i)) : String.format("Input %s to phi node %s is not yet available although it is not coming from a loop back edge", node, phi);
                LIRKind kind = this.gen.getLIRKind(node.stamp(NodeView.DEFAULT));
                valueKind = this.gen.toRegisterKind(kind);
            }
            derivedKind = LIRKind.mergeReferenceInformation(derivedKind, valueKind);
        }
        return derivedKind;
    }

    private static boolean isPhiInputFromBackedge(PhiNode phi, int index) {
        AbstractMergeNode merge = phi.merge();
        AbstractEndNode end = merge.phiPredecessorAt(index);
        return end instanceof LoopEndNode && ((LoopEndNode)end).loopBegin().equals(merge);
    }

    private Value[] createPhiIn(AbstractMergeNode merge) {
        ArrayList<Variable> values = new ArrayList<Variable>();
        for (ValuePhiNode phi : merge.valuePhis()) {
            assert (this.getOperand(phi) == null);
            Variable value = this.gen.newVariable(this.getExactPhiKind(phi));
            values.add(value);
            this.setResult(phi, (Value)value);
        }
        return values.toArray(new Value[values.size()]);
    }

    private Value[] createPhiOut(AbstractMergeNode merge, AbstractEndNode pred) {
        ArrayList<Value> values = new ArrayList<Value>();
        for (PhiNode phiNode : merge.valuePhis()) {
            ValueNode node = phiNode.valueAt(pred);
            Object value = this.operand(node);
            assert (value != null);
            if (ValueUtil.isRegister((Value)value)) {
                value = this.gen.emitMove((Value)value);
            } else if (node.isConstant() && !this.gen.getSpillMoveFactory().allowConstantToStackMove(node.asConstant()) && !LIRKind.isValue(value)) {
                Variable result = this.gen.newVariable(value.getValueKind());
                this.gen.emitMove(result, (Value)value);
                value = result;
            }
            values.add((Value)value);
        }
        return values.toArray(new Value[values.size()]);
    }

    public final void doBlockPrologue(HIRBlock block, OptionValues options) {
        if (SpectrePHTMitigations.Options.SpeculativeExecutionBarriers.getValue(options).booleanValue()) {
            boolean isStartBlock;
            boolean hasControlSplitPredecessor = false;
            for (int i = 0; i < block.getPredecessorCount(); ++i) {
                HIRBlock b = (HIRBlock)block.getPredecessorAt(i);
                if (b.getSuccessorCount() <= 1) continue;
                hasControlSplitPredecessor = true;
                break;
            }
            boolean bl = isStartBlock = block.getPredecessorCount() == 0;
            if (hasControlSplitPredecessor || isStartBlock) {
                this.getLIRGeneratorTool().emitSpeculationFence();
            }
        }
    }

    @Override
    public void doBlock(HIRBlock block, StructuredGraph graph, BlockMap<List<Node>> blockMap) {
        OptionValues options = graph.getOptions();
        try (LIRGeneratorTool.BlockScope blockScope = this.gen.getBlockScope(block);){
            this.setSourcePosition(null);
            if (block == this.gen.getResult().getLIR().getControlFlowGraph().getStartBlock()) {
                assert (block.getPredecessorCount() == 0) : Assertions.errorMessage(block);
                this.emitPrologue(graph);
            } else {
                assert (block.getPredecessorCount() > 0) : Assertions.errorMessage(block);
                AbstractBeginNode begin = block.getBeginNode();
                if (begin instanceof AbstractMergeNode) {
                    AbstractMergeNode merge = (AbstractMergeNode)begin;
                    StandardOp.LabelOp label = (StandardOp.LabelOp)this.gen.getResult().getLIR().getLIRforBlock(block).get(0);
                    label.setPhiValues(this.createPhiIn(merge));
                    if (LIRGenerator.Options.PrintIRWithLIR.getValue(options).booleanValue() && !TTY.isSuppressed()) {
                        TTY.println("Created PhiIn: " + String.valueOf(label));
                    }
                }
            }
            this.doBlockPrologue(block, options);
            List<Node> nodes = blockMap.get(block);
            boolean trace = this.traceLIRGeneratorLevel >= 3;
            for (int i = 0; i < nodes.size(); ++i) {
                Value operand;
                Node node = nodes.get(i);
                if (!(node instanceof ValueNode)) continue;
                this.setSourcePosition(node.getNodeSourcePosition());
                DebugContext debug = node.getDebug();
                ValueNode valueNode = (ValueNode)node;
                if (trace) {
                    TTY.println("LIRGen for " + String.valueOf(valueNode));
                }
                if ((operand = this.getOperand(valueNode)) == null) {
                    if (this.peephole(valueNode)) continue;
                    try {
                        this.doRoot(valueNode);
                        continue;
                    }
                    catch (GraalError e) {
                        throw GraalGraphError.transformAndAddContext(e, valueNode);
                    }
                    catch (BailoutException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new GraalGraphError(e).addContext(valueNode);
                    }
                }
                if (ComplexMatchValue.INTERIOR_MATCH.equals((Object)operand)) {
                    debug.log("interior match for %s", valueNode);
                    continue;
                }
                if (!(operand instanceof ComplexMatchValue)) continue;
                debug.log("complex match for %s", valueNode);
                this.setSourcePosition(node.getNodeSourcePosition());
                ComplexMatchValue match = (ComplexMatchValue)operand;
                operand = match.evaluate(this);
                if (operand == null) continue;
                this.setResult(valueNode, operand);
            }
            if (!this.gen.hasBlockEnd(block)) {
                NodeIterable<Node> successors = block.getEndNode().successors();
                assert (successors.count() == block.getSuccessorCount()) : Assertions.errorMessage(successors, block);
                if (block.getSuccessorCount() != 1) {
                    throw new GraalError("Block without BlockEndOp: " + String.valueOf(block.getEndNode()));
                }
                this.gen.emitJump(this.getLIRBlock((FixedNode)successors.first()));
            }
            assert (LIR.verifyBlock(this.gen.getResult().getLIR(), block));
        }
    }

    public void matchBlock(HIRBlock block, StructuredGraph.ScheduleResult schedule) {
        try (DebugCloseable matchScope = this.gen.getMatchScope(block);){
            this.matchComplexExpressions(block, schedule);
        }
    }

    protected void matchComplexExpressions(HIRBlock block, StructuredGraph.ScheduleResult schedule) {
        if (this.matchRules != null) {
            DebugContext debug = this.gen.getResult().getLIR().getDebug();
            try (DebugContext.Scope s = debug.scope("MatchComplexExpressions");){
                List<Node> nodes = schedule.getBlockToNodesMap().get(block);
                if (DebugOptions.LogVerbose.getValue(this.nodeOperands.graph().getOptions()).booleanValue()) {
                    int i = 0;
                    for (Node node : nodes) {
                        debug.log("%d: (%s) %1S", (Object)i++, (Object)node.getUsageCount(), (Object)node);
                    }
                }
                for (int index = nodes.size() - 1; index >= 0; --index) {
                    MatchStatement statement;
                    List statements;
                    Node node = nodes.get(index);
                    if (this.getOperand(node) != null || (statements = (List)this.matchRules.get(node.getClass())) == null) continue;
                    Iterator iterator = statements.iterator();
                    while (iterator.hasNext() && !(statement = (MatchStatement)iterator.next()).generate(this, index, node, block, schedule)) {
                    }
                }
            }
        }
    }

    protected abstract boolean peephole(ValueNode var1);

    private void doRoot(ValueNode instr) {
        if (this.traceLIRGeneratorLevel >= 2) {
            TTY.println("Emitting LIR for instruction " + String.valueOf(instr));
        }
        this.currentInstruction = instr;
        DebugContext debug = instr.getDebug();
        debug.log("Visiting %s", instr);
        this.emitNode(instr);
        debug.log("Operand for %s = %s", (Object)instr, (Object)this.getOperand(instr));
    }

    protected void emitNode(ValueNode node) {
        if (node.getDebug().isLogEnabled() && node.stamp(NodeView.DEFAULT).isEmpty()) {
            node.getDebug().log("This node has an empty stamp, we are emitting dead code(?): %s", node);
        }
        if (!(node instanceof LIRLowerable)) {
            throw GraalError.shouldNotReachHere("node is not LIRLowerable: " + String.valueOf(node));
        }
        ((LIRLowerable)((Object)node)).generate(this);
    }

    protected void emitPrologue(StructuredGraph graph) {
        CallingConvention incomingArguments = this.gen.getResult().getCallingConvention();
        Value[] params = new Value[incomingArguments.getArgumentCount()];
        this.prologAssignParams(incomingArguments, params);
        this.gen.emitIncomingValues(params);
        this.prologSetParameterNodes(graph, params);
    }

    protected final void prologAssignParams(CallingConvention incomingArguments, Value[] params) {
        for (int i = 0; i < incomingArguments.getArgumentCount(); ++i) {
            StackSlot slot;
            params[i] = incomingArguments.getArgument(i);
            if (!ValueUtil.isStackSlot((Value)params[i]) || !(slot = ValueUtil.asStackSlot((Value)params[i])).isInCallerFrame() || this.gen.getResult().getLIR().hasArgInCallerFrame()) continue;
            this.gen.getResult().getLIR().setHasArgInCallerFrame();
        }
    }

    protected void prologSetParameterNodes(StructuredGraph graph, Value[] params) {
        for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
            Value paramValue = params[param.index()];
            assert (paramValue.getValueKind().equals((Object)this.getLIRGeneratorTool().getLIRKind(param.stamp(NodeView.DEFAULT)))) : String.valueOf(paramValue) + " " + String.valueOf((Object)this.getLIRGeneratorTool().getLIRKind(param.stamp(NodeView.DEFAULT)));
            this.setResult(param, (Value)this.gen.emitMove(paramValue));
        }
    }

    @Override
    public void visitMerge(AbstractMergeNode x) {
    }

    @Override
    public void visitEndNode(AbstractEndNode end) {
        AbstractMergeNode merge = end.merge();
        StandardOp.JumpOp jump = this.newJumpOp(this.getLIRBlock(merge));
        jump.setPhiValues(this.createPhiOut(merge, end));
        this.append(jump);
    }

    @Override
    public void visitLoopEnd(LoopEndNode x) {
    }

    protected StandardOp.JumpOp newJumpOp(LabelRef ref) {
        return new StandardOp.JumpOp(ref);
    }

    protected LIRKind getPhiKind(PhiNode phi) {
        return this.gen.getLIRKind(phi.stamp(NodeView.DEFAULT));
    }

    @Override
    public void emitIf(IfNode x) {
        this.emitBranch(x.condition(), this.getLIRBlock(x.trueSuccessor()), this.getLIRBlock(x.falseSuccessor()), x.probability(x.trueSuccessor()));
    }

    public void emitBranch(LogicNode node, LabelRef trueSuccessor, LabelRef falseSuccessor, double trueSuccessorProbability) {
        if (node instanceof IsNullNode) {
            LIRKind kind = this.gen.getLIRKind(((IsNullNode)node).getValue().stamp(NodeView.DEFAULT));
            Value nullValue = this.gen.emitConstant(kind, (Constant)((IsNullNode)node).nullConstant());
            this.gen.emitCompareBranch(kind.getPlatformKind(), this.operand(((IsNullNode)node).getValue()), nullValue, Condition.EQ, false, trueSuccessor, falseSuccessor, trueSuccessorProbability);
        } else if (node instanceof CompareNode) {
            PlatformKind kind = this.gen.getLIRKind(((CompareNode)node).getX().stamp(NodeView.DEFAULT)).getPlatformKind();
            this.gen.emitCompareBranch(kind, this.operand(((CompareNode)node).getX()), this.operand(((CompareNode)node).getY()), ((CompareNode)node).condition().asCondition(), ((CompareNode)node).unorderedIsTrue(), trueSuccessor, falseSuccessor, trueSuccessorProbability);
        } else if (node instanceof LogicConstantNode) {
            this.gen.emitJump(((LogicConstantNode)node).getValue() ? trueSuccessor : falseSuccessor);
        } else if (node instanceof IntegerTestNode) {
            this.gen.emitIntegerTestBranch(this.operand(((IntegerTestNode)node).getX()), this.operand(((IntegerTestNode)node).getY()), trueSuccessor, falseSuccessor, trueSuccessorProbability);
        } else if (node instanceof OpMaskTestNode) {
            OpMaskTestNode test = (OpMaskTestNode)node;
            this.gen.emitOpMaskTestBranch(this.operand(test.getX()), test.invertX(), this.operand(test.getY()), trueSuccessor, falseSuccessor, trueSuccessorProbability);
        } else if (node instanceof OpMaskOrTestNode) {
            OpMaskOrTestNode orTest = (OpMaskOrTestNode)node;
            this.gen.emitOpMaskOrTestBranch(this.operand(orTest.getX()), this.operand(orTest.getY()), orTest.allZeros(), trueSuccessor, falseSuccessor, trueSuccessorProbability);
        } else if (node instanceof OpaqueLogicNode) {
            this.emitBranch(((OpaqueLogicNode)node).value(), trueSuccessor, falseSuccessor, trueSuccessorProbability);
        } else {
            throw GraalError.unimplemented(node.toString());
        }
    }

    @Override
    public void emitConditional(ConditionalNode conditional) {
        Value tVal = this.operand(conditional.trueValue());
        Value fVal = this.operand(conditional.falseValue());
        this.setResult(conditional, (Value)this.emitConditional(conditional.condition(), tVal, fVal));
    }

    public Variable emitConditional(LogicNode node, Value trueValue, Value falseValue) {
        if (node instanceof IsNullNode) {
            IsNullNode isNullNode = (IsNullNode)node;
            LIRKind kind = this.gen.getLIRKind(isNullNode.getValue().stamp(NodeView.DEFAULT));
            Value nullValue = this.gen.emitConstant(kind, (Constant)isNullNode.nullConstant());
            return this.gen.emitConditionalMove(kind.getPlatformKind(), this.operand(isNullNode.getValue()), nullValue, Condition.EQ, false, trueValue, falseValue);
        }
        if (node instanceof CompareNode) {
            CompareNode compare = (CompareNode)node;
            PlatformKind kind = this.gen.getLIRKind(compare.getX().stamp(NodeView.DEFAULT)).getPlatformKind();
            return this.gen.emitConditionalMove(kind, this.operand(compare.getX()), this.operand(compare.getY()), compare.condition().asCondition(), compare.unorderedIsTrue(), trueValue, falseValue);
        }
        if (node instanceof LogicConstantNode) {
            return this.gen.emitMove(((LogicConstantNode)node).getValue() ? trueValue : falseValue);
        }
        if (node instanceof IntegerTestNode) {
            IntegerTestNode test = (IntegerTestNode)node;
            return this.gen.emitIntegerTestMove(this.operand(test.getX()), this.operand(test.getY()), trueValue, falseValue);
        }
        if (node instanceof OpMaskTestNode) {
            OpMaskTestNode test = (OpMaskTestNode)node;
            return this.gen.emitOpMaskTestMove(this.operand(test.getX()), test.invertX(), this.operand(test.getY()), trueValue, falseValue);
        }
        if (node instanceof OpMaskOrTestNode) {
            OpMaskOrTestNode orTest = (OpMaskOrTestNode)node;
            return this.gen.emitOpMaskOrTestMove(this.operand(orTest.getX()), this.operand(orTest.getY()), orTest.allZeros(), trueValue, falseValue);
        }
        throw GraalError.unimplemented(node.toString());
    }

    @Override
    public void emitInvoke(Invoke x) {
        LoweredCallTargetNode callTarget = (LoweredCallTargetNode)x.callTarget();
        FrameMapBuilder frameMapBuilder = this.gen.getResult().getFrameMapBuilder();
        CallingConvention invokeCc = frameMapBuilder.getRegisterConfig().getCallingConvention(callTarget.callType(), (JavaType)x.asNode().stamp(NodeView.DEFAULT).javaType(this.gen.getMetaAccess()), callTarget.signature(), (ValueKindFactory)this.gen);
        frameMapBuilder.callsMethod(invokeCc);
        Value[] parameters = this.visitInvokeArguments(invokeCc, callTarget.arguments());
        LabelRef exceptionEdge = null;
        if (x instanceof InvokeWithExceptionNode) {
            exceptionEdge = this.getLIRBlock(((InvokeWithExceptionNode)x).exceptionEdge());
            exceptionEdge.getTargetBlock().setIndirectBranchTarget();
        }
        LIRFrameState callState = this.stateWithExceptionEdge(x, exceptionEdge);
        AllocatableValue result = invokeCc.getReturn();
        this.emitInvoke(callTarget, parameters, callState, (Value)result);
        if (ValueUtil.isLegal((Value)result)) {
            this.setResult(x.asNode(), (Value)this.gen.emitMove((Value)result));
        }
        if (x instanceof InvokeWithExceptionNode) {
            this.gen.emitJump(this.getLIRBlock(((InvokeWithExceptionNode)x).next()));
        }
    }

    protected void emitInvoke(LoweredCallTargetNode callTarget, Value[] parameters, LIRFrameState callState, Value result) {
        if (callTarget instanceof DirectCallTargetNode) {
            this.emitDirectCall((DirectCallTargetNode)callTarget, result, parameters, (Value[])AllocatableValue.NONE, callState);
        } else if (callTarget instanceof IndirectCallTargetNode) {
            this.emitIndirectCall((IndirectCallTargetNode)callTarget, result, parameters, (Value[])AllocatableValue.NONE, callState);
        } else {
            throw GraalError.shouldNotReachHereUnexpectedValue(callTarget);
        }
    }

    @Override
    public void emitForeignCall(ForeignCall x) {
        Value[] args;
        LIRFrameState callState;
        Variable result;
        ForeignCallLinkage linkage = this.gen.getForeignCalls().lookupForeignCall(x.getDescriptor());
        LabelRef exceptionEdge = null;
        if (x instanceof WithExceptionNode) {
            WithExceptionNode withExceptionNode = (WithExceptionNode)((Object)x);
            exceptionEdge = this.getLIRBlock(withExceptionNode.exceptionEdge());
            exceptionEdge.getTargetBlock().setIndirectBranchTarget();
        }
        if ((result = this.gen.emitForeignCall(linkage, callState = this.stateWithExceptionEdge(x, exceptionEdge), args = x.operands(this))) != null) {
            this.setResult(x.asNode(), (Value)result);
        }
        if (x instanceof WithExceptionNode) {
            this.gen.emitJump(this.getLIRBlock(((WithExceptionNode)((Object)x)).next()));
        }
    }

    protected abstract void emitDirectCall(DirectCallTargetNode var1, Value var2, Value[] var3, Value[] var4, LIRFrameState var5);

    protected abstract void emitIndirectCall(IndirectCallTargetNode var1, Value var2, Value[] var3, Value[] var4, LIRFrameState var5);

    public Value[] visitInvokeArguments(CallingConvention invokeCc, Collection<ValueNode> arguments) {
        Value[] result = new Value[arguments.size()];
        int j = 0;
        for (ValueNode arg : arguments) {
            if (arg != null) {
                AllocatableValue operand = invokeCc.getArgument(j);
                this.gen.emitMove(operand, this.operand(arg));
                result[j] = operand;
                ++j;
                continue;
            }
            throw GraalError.shouldNotReachHere("I thought we no longer have null entries for two-slot types...");
        }
        return result;
    }

    @Override
    public void emitSwitch(SwitchNode x) {
        assert (x.defaultSuccessor() != null);
        LabelRef defaultTarget = this.getLIRBlock(x.defaultSuccessor());
        int keyCount = x.keyCount();
        if (keyCount == 0) {
            this.gen.emitJump(defaultTarget);
        } else {
            AllocatableValue value = this.gen.asAllocatable(this.operand(x.value()));
            if (keyCount == 1) {
                assert (defaultTarget != null);
                double probability = x.probability(x.keySuccessor(0));
                LIRKind kind = this.gen.getLIRKind(x.value().stamp(NodeView.DEFAULT));
                Value key = this.gen.emitConstant(kind, x.keyAt(0));
                this.gen.emitCompareBranch(kind.getPlatformKind(), (Value)value, key, Condition.EQ, false, this.getLIRBlock(x.keySuccessor(0)), defaultTarget, probability);
            } else if (x instanceof IntegerSwitchNode && x.isSorted()) {
                IntegerSwitchNode intSwitch = (IntegerSwitchNode)x;
                LabelRef[] keyTargets = new LabelRef[keyCount];
                JavaConstant[] keyConstants = new JavaConstant[keyCount];
                double[] keyProbabilities = new double[keyCount];
                JavaKind keyKind = intSwitch.keyAt(0).getJavaKind();
                for (int i = 0; i < keyCount; ++i) {
                    keyTargets[i] = this.getLIRBlock(intSwitch.keySuccessor(i));
                    keyConstants[i] = intSwitch.keyAt(i);
                    keyProbabilities[i] = intSwitch.keyProbability(i);
                    assert (keyConstants[i].getJavaKind() == keyKind) : Assertions.errorMessage(keyConstants, keyKind);
                }
                this.gen.emitStrategySwitch(keyConstants, keyProbabilities, keyTargets, defaultTarget, value);
            } else {
                LabelRef[] keyTargets = new LabelRef[keyCount];
                Constant[] keyConstants = new Constant[keyCount];
                double[] keyProbabilities = new double[keyCount];
                for (int i = 0; i < keyCount; ++i) {
                    keyTargets[i] = this.getLIRBlock(x.keySuccessor(i));
                    keyConstants[i] = x.keyAt(i);
                    keyProbabilities[i] = x.keyProbability(i);
                }
                this.gen.emitStrategySwitch(new SwitchStrategy.SequentialStrategy(keyProbabilities, keyConstants), value, keyTargets, defaultTarget);
            }
        }
    }

    public DebugInfoBuilder getDebugInfoBuilder() {
        assert (this.debugInfoBuilder != null);
        return this.debugInfoBuilder;
    }

    private static FrameState getFrameState(DeoptimizingNode deopt) {
        if (deopt instanceof DeoptimizingNode.DeoptBefore) {
            assert (!(deopt instanceof DeoptimizingNode.DeoptDuring) && !(deopt instanceof DeoptimizingNode.DeoptAfter)) : Assertions.errorMessage(deopt);
            return ((DeoptimizingNode.DeoptBefore)deopt).stateBefore();
        }
        if (deopt instanceof DeoptimizingNode.DeoptDuring) {
            assert (!(deopt instanceof DeoptimizingNode.DeoptAfter)) : Assertions.errorMessage(deopt);
            return ((DeoptimizingNode.DeoptDuring)deopt).stateDuring();
        }
        assert (deopt instanceof DeoptimizingNode.DeoptAfter) : Assertions.errorMessage(deopt);
        return ((DeoptimizingNode.DeoptAfter)deopt).stateAfter();
    }

    @Override
    public LIRFrameState state(DeoptimizingNode deopt) {
        if (!deopt.canDeoptimize()) {
            return null;
        }
        return this.stateFor(deopt, NodeLIRBuilder.getFrameState(deopt));
    }

    public LIRFrameState stateWithExceptionEdge(DeoptimizingNode deopt, LabelRef exceptionEdge) {
        if (!deopt.canDeoptimize()) {
            return null;
        }
        return this.stateForWithExceptionEdge(deopt, NodeLIRBuilder.getFrameState(deopt), exceptionEdge);
    }

    public LIRFrameState stateFor(NodeWithState deopt, FrameState state) {
        return this.stateForWithExceptionEdge(deopt, state, null);
    }

    public LIRFrameState stateForWithExceptionEdge(NodeWithState deopt, FrameState state, LabelRef exceptionEdge) {
        if (this.gen.needOnlyOopMaps()) {
            return new LIRFrameState(null, null, null, false);
        }
        JavaConstant deoptReasonAndAction = null;
        JavaConstant deoptSpeculation = null;
        assert (state != null) : "Deopt node=" + String.valueOf(deopt) + " needs a state ";
        if (deopt instanceof ImplicitNullCheckNode) {
            ImplicitNullCheckNode implicitNullCheck = (ImplicitNullCheckNode)deopt;
            deoptReasonAndAction = implicitNullCheck.getDeoptReasonAndAction();
            deoptSpeculation = implicitNullCheck.getDeoptSpeculation();
        } else if (deopt instanceof IntegerDivRemNode) {
            IntegerDivRemNode idiv = (IntegerDivRemNode)deopt;
            deoptReasonAndAction = idiv.getDeoptReasonAndAction();
            deoptSpeculation = idiv.getDeoptSpeculation();
        }
        if (deoptSpeculation != null) {
            assert (deoptReasonAndAction != null);
            return this.getDebugInfoBuilder().build(deopt, state, exceptionEdge, deoptReasonAndAction, deoptSpeculation);
        }
        return this.getDebugInfoBuilder().build(deopt, state, exceptionEdge, null, null);
    }

    @Override
    public void emitOverflowCheckBranch(AbstractBeginNode overflowSuccessor, AbstractBeginNode next, Stamp stamp, double probability) {
        LIRKind cmpKind = this.getLIRGeneratorTool().getLIRKind(stamp);
        this.gen.emitOverflowCheckBranch(this.getLIRBlock(overflowSuccessor), this.getLIRBlock(next), cmpKind, probability);
    }

    @Override
    public void visitFullInfopointNode(FullInfopointNode i) {
        this.append(new FullInfopointOp(this.stateFor(i, i.getState()), i.getReason()));
    }

    private void setSourcePosition(NodeSourcePosition position) {
        this.gen.setSourcePosition(position);
    }

    @Override
    public LIRGenerator getLIRGeneratorTool() {
        return this.gen;
    }

    @Override
    public void emitReadExceptionObject(ValueNode node) {
        LIRGenerator lirGenTool = this.getLIRGeneratorTool();
        RegisterValue returnRegister = lirGenTool.getRegisterConfig().getReturnRegister(node.getStackKind()).asValue((ValueKind)LIRKind.fromJavaKind(lirGenTool.target().arch, node.getStackKind()));
        lirGenTool.emitIncomingValues(new Value[]{returnRegister});
        this.setResult(node, (Value)lirGenTool.emitMove((Value)returnRegister));
    }
}

