/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.gen;

import jdk.graal.compiler.debug.LogStream;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;

public class InstructionPrinter {
    private final LogStream out;

    public InstructionPrinter(LogStream out) {
        this.out = out;
    }

    public LogStream out() {
        return this.out;
    }

    public void printInstructionListing(ValueNode instruction) {
        int indentation = this.out.indentationLevel();
        this.out.fillTo(InstructionLineColumn.BCI.position + indentation, ' ').print(0).fillTo(InstructionLineColumn.USE.position + indentation, ' ').print("0").fillTo(InstructionLineColumn.VALUE.position + indentation, ' ').print(InstructionPrinter.valueString(instruction)).fillTo(InstructionLineColumn.INSTRUCTION.position + indentation, ' ');
        this.printInstruction(instruction);
        if (instruction instanceof StateSplit) {
            this.out.print("  [state: " + String.valueOf(((StateSplit)((Object)instruction)).stateAfter()) + "]");
        }
        this.out.println();
    }

    public void printInstruction(ValueNode node) {
        this.out.print(node.toString());
    }

    public static String valueString(ValueNode value) {
        return value == null ? "-" : Character.toLowerCase(value.getStackKind().getTypeChar()) + value.toString(Verbosity.Id);
    }

    public static enum InstructionLineColumn {
        BCI(2, "bci"),
        USE(7, "use"),
        VALUE(12, "tid"),
        INSTRUCTION(19, "instr"),
        END(60, "");

        final int position;
        final String label;

        private InstructionLineColumn(int position, String label) {
            this.position = position;
            this.label = label;
        }

        public void advance(LogStream out) {
            out.fillTo(this.position + out.indentationLevel(), ' ');
        }
    }
}

