/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.util;

import java.util.List;
import jdk.graal.compiler.debug.TTY;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class Util {
    public static <T> T uncheckedCast(Object object) {
        return (T)object;
    }

    public static <T> void atPutGrow(List<T> list, int pos, T x, T filler) {
        if (list.size() < pos + 1) {
            while (list.size() < pos + 1) {
                list.add(filler);
            }
            assert (list.size() == pos + 1) : "Size " + list.size() + " must be pos+1, pos=" + pos;
        }
        assert (list.size() >= pos + 1) : "Size " + list.size() + " must be pos+1, pos=" + pos;
        list.set(pos, x);
    }

    public static String indent(String lines, String indentation) {
        if (lines.length() == 0) {
            return lines;
        }
        String newLine = "\n";
        if (lines.endsWith("\n")) {
            return indentation + lines.substring(0, lines.length() - 1).replace("\n", "\n" + indentation) + "\n";
        }
        return indentation + lines.replace("\n", "\n" + indentation);
    }

    public static void printInlining(ResolvedJavaMethod method, int bci, int inliningDepth, boolean success, String msg, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append("        ");
        sb.append("     ");
        sb.append(String.format("%c%c%c%c%c ", Character.valueOf(' '), Character.valueOf(method.isSynchronized() ? (char)'s' : ' '), Character.valueOf(' '), Character.valueOf(' '), Character.valueOf(method.isNative() ? (char)'n' : ' ')));
        sb.append("     ");
        sb.append("    ");
        for (int i = 0; i < inliningDepth; ++i) {
            sb.append("  ");
        }
        sb.append(String.format("@ %d  %s   %s%s", bci, Util.methodName(method), success ? "" : "not inlining ", String.format(msg, args)));
        TTY.println(sb.toString());
    }

    private static String methodName(ResolvedJavaMethod method) {
        return method.format("%H.%n(%p):%r") + " (" + method.getCodeSize() + " bytes)";
    }

    public static String toString(StackTraceElement[] ste) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement e : ste) {
            sb.append('\t').append(e).append(System.lineSeparator());
        }
        return sb.toString();
    }
}

