/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.util;

import jdk.vm.ci.meta.ResolvedJavaMethod;

public final class MethodKey {
    private final String declaringClass;
    private final String name;
    private final String descriptor;
    private final int hashCode;

    public MethodKey(ResolvedJavaMethod method) {
        this.declaringClass = method.getDeclaringClass().getName();
        this.name = method.getName();
        this.descriptor = method.getSignature().toMethodDescriptor();
        this.hashCode = method.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodKey) {
            MethodKey that = (MethodKey)obj;
            return this.hashCode == that.hashCode && this.name.equals(that.name) && this.declaringClass.equals(that.declaringClass) && this.descriptor.equals(that.descriptor);
        }
        return false;
    }

    public String toString() {
        return this.declaringClass + "." + this.name + this.descriptor;
    }
}

