/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.util;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.core.common.util.EventCounter;
import jdk.graal.compiler.core.common.util.Util;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.serviceprovider.GraalServices;
import org.graalvm.nativeimage.ImageInfo;

public final class CompilationAlarm
implements AutoCloseable {
    public static final boolean LOG_PROGRESS_DETECTION = !ImageInfo.inImageRuntimeCode() && Boolean.parseBoolean(GraalServices.getSavedProperty("debug." + CompilationAlarm.class.getName() + ".logProgressDetection"));
    private final CompilationAlarm previous;
    private static final ThreadLocal<CompilationAlarm> currentAlarm = new ThreadLocal();
    private static final CompilationAlarm NEVER_EXPIRES = new CompilationAlarm(0.0);
    private double period;
    private long expirationNS;
    private PhaseTreeNode root;
    private PhaseTreeNode currentNode;
    private static final int CHILD_TREE_INIT_SIZE = 2;
    public static final int CHECK_BAILOUT_COUNTER = 4096;
    private static final ThreadLocal<StackTraceElement[]> lastStackTraceForThread = new ThreadLocal();
    private static final ThreadLocal<Long> lastUniqueStackTraceForThreadNS = new ThreadLocal();
    private static final ThreadLocal<EventCounter.EventCounterMarker> lastMarkerForThread = new ThreadLocal();
    private static final ThreadLocal<Long> noProgressStartPeriodNS = new ThreadLocal();

    private CompilationAlarm(double period) {
        this.currentNode = this.root = new PhaseTreeNode(this, "Root");
        this.previous = currentAlarm.get();
        this.reset(period);
    }

    public void reset(OptionValues options) {
        double optionPeriod = Options.CompilationExpirationPeriod.getValue(options);
        if (optionPeriod > 0.0) {
            this.reset(CompilationAlarm.scaleExpirationPeriod(optionPeriod, options));
        }
    }

    public static double scaleExpirationPeriod(double period, OptionValues options) {
        double p = period;
        if (Assertions.assertionsEnabled()) {
            p *= 2.0;
        }
        if (Assertions.detailedAssertionsEnabled(options)) {
            p *= 2.0;
        }
        return p;
    }

    public static CompilationAlarm current() {
        CompilationAlarm alarm = currentAlarm.get();
        return alarm == null ? NEVER_EXPIRES : alarm;
    }

    public double getPeriod() {
        return this.period;
    }

    public boolean hasExpired() {
        return this != NEVER_EXPIRES && this.expirationNS != 0L && System.nanoTime() > this.expirationNS;
    }

    public long elapsed() {
        return this == NEVER_EXPIRES ? -1L : System.nanoTime() - this.start();
    }

    static long periodNanoSeconds(double period) {
        return (long)(period * (double)TimeUnit.SECONDS.toNanos(1L));
    }

    private long start() {
        return this == NEVER_EXPIRES ? -1L : this.expirationNS - CompilationAlarm.periodNanoSeconds(this.period);
    }

    public void reset(double newPeriod) {
        if (this != NEVER_EXPIRES) {
            this.period = newPeriod;
            this.expirationNS = newPeriod == 0.0 ? 0L : System.nanoTime() + CompilationAlarm.periodNanoSeconds(newPeriod);
        }
    }

    public boolean isEnabled() {
        return this != NEVER_EXPIRES;
    }

    public void checkExpiration() {
        if (this.hasExpired()) {
            this.setCurrentNodeDuration(this.currentNode.name);
            PhaseTreeNode cloneTree = this.cloneTree(this.root, null);
            StringBuilder sb = new StringBuilder();
            cloneTree.durationNS = this.elapsed();
            this.printTree("", sb, cloneTree, true);
            throw new PermanentBailoutException("Compilation exceeded %.3f seconds. %n Phase timings:%n %s <===== TIMEOUT HERE", this.period, sb.toString().trim());
        }
    }

    @Override
    public void close() {
        currentAlarm.set(this.previous);
        CompilationAlarm.resetProgressDetection();
    }

    public void enterPhase(String name) {
        if (!this.isEnabled()) {
            return;
        }
        PhaseTreeNode node = new PhaseTreeNode(this, name);
        node.parent = this.currentNode;
        node.startTimeNS = System.nanoTime();
        this.currentNode.addChild(node);
        this.currentNode = node;
    }

    public void exitPhase(String name) {
        if (!this.isEnabled()) {
            return;
        }
        assert (this.currentNode.name.equals(name)) : Assertions.errorMessage("Must see the same phase that was opened in the close operation", name, this.elapsedPhaseTreeAsString());
        this.setCurrentNodeDuration(name);
        this.currentNode.closed = true;
        this.currentNode.parent.durationNS += this.currentNode.durationNS;
        this.currentNode = this.currentNode.parent;
    }

    private void setCurrentNodeDuration(String name) {
        assert (this.currentNode.startTimeNS >= 0L) : Assertions.errorMessage("Must have a positive start time", name, this.elapsedPhaseTreeAsString());
        this.currentNode.durationNS = System.nanoTime() - this.currentNode.startTimeNS;
    }

    private PhaseTreeNode cloneTree(PhaseTreeNode clonee, PhaseTreeNode parent) {
        PhaseTreeNode clone = new PhaseTreeNode(this, clonee.name);
        clone.parent = parent;
        if (clone.parent != null) {
            clone.parent.addChild(clone);
        }
        clone.durationNS = clonee.durationNS;
        clone.startTimeNS = clonee.startTimeNS;
        clone.closed = clonee.closed;
        if (clonee.children != null) {
            for (int i = 0; i < clonee.childIndex; ++i) {
                this.cloneTree(clonee.children[i], clone);
            }
        }
        return clone;
    }

    private void printTree(String indent, StringBuilder sb, PhaseTreeNode node, boolean printRoot) {
        sb.append(indent);
        if (!printRoot && node == this.root) {
            sb.append(node.name);
        } else {
            sb.append(node);
        }
        sb.append(System.lineSeparator());
        if (node.children != null) {
            for (int i = 0; i < node.childIndex; ++i) {
                this.printTree(indent + "\t", sb, node.children[i], printRoot);
            }
        }
    }

    public StringBuilder elapsedPhaseTreeAsString() {
        StringBuilder sb = new StringBuilder();
        this.printTree("", sb, this.root, false);
        return sb;
    }

    public static CompilationAlarm trackCompilationPeriod(OptionValues options) {
        double period = Options.CompilationExpirationPeriod.getValue(options);
        if (period > 0.0) {
            CompilationAlarm current;
            if (Assertions.assertionsEnabled()) {
                period *= 2.0;
            }
            if (Assertions.detailedAssertionsEnabled(options)) {
                period *= 2.0;
            }
            if ((current = currentAlarm.get()) == null) {
                current = new CompilationAlarm(period);
                currentAlarm.set(current);
                return current;
            }
        }
        return null;
    }

    public static CompilationAlarm disable() {
        CompilationAlarm current = new CompilationAlarm(0.0);
        currentAlarm.set(current);
        return current;
    }

    public static void checkProgress(Graph graph) {
        if (graph == null) {
            return;
        }
        if (graph.eventCounterOverflows(4096)) {
            CompilationAlarm.overflowAction(graph.getOptions(), graph);
        }
    }

    public static boolean checkProgress(OptionValues opt, EventCounter eventCounter) {
        if (opt == null) {
            return false;
        }
        if (eventCounter.eventCounterOverflows(4096)) {
            CompilationAlarm.overflowAction(opt, eventCounter);
            return true;
        }
        return false;
    }

    private static void overflowAction(OptionValues opt, EventCounter counter) {
        if (LOG_PROGRESS_DETECTION) {
            TTY.printf("CompilationAlarm: Progress detection %s; event counter overflowed%n", counter.eventCounterToString());
        }
        CompilationAlarm current = CompilationAlarm.current();
        current.checkExpiration();
        CompilationAlarm.assertProgress(opt, counter);
    }

    private static void assertProgress(OptionValues opt, EventCounter counter) {
        EventCounter.EventCounterMarker lastMarker = lastMarkerForThread.get();
        if (lastMarker != null && lastMarker != counter.getEventCounterMarker()) {
            CompilationAlarm.resetProgressDetection();
            return;
        }
        Object[] lastStackTrace = lastStackTraceForThread.get();
        if (lastStackTrace == null) {
            Long lastUniqueStackTraceTimeStampNS = lastUniqueStackTraceForThreadNS.get();
            if (lastUniqueStackTraceTimeStampNS == null) {
                CompilationAlarm.assertProgressNoTracking(opt, counter);
                return;
            }
            long delayNS = noProgressStartPeriodNS.get();
            long nowNS = System.nanoTime();
            long elapsedNS = nowNS - lastUniqueStackTraceTimeStampNS;
            if (elapsedNS <= delayNS) {
                if (LOG_PROGRESS_DETECTION) {
                    TTY.printf("CompilationAlarm: Progress detection %s; time diff of %d ms not long enough to take stack trace yet%n", counter.eventCounterToString(), TimeUnit.NANOSECONDS.toMillis(elapsedNS));
                }
                return;
            }
            if (LOG_PROGRESS_DETECTION) {
                TTY.printf("CompilationAlarm: Progress detection %s; time diff of %d ms long enough to take stack trace%n", counter.eventCounterToString(), TimeUnit.NANOSECONDS.toMillis(elapsedNS));
            }
        }
        Object[] currentStackTrace = Thread.currentThread().getStackTrace();
        if (lastStackTrace == null || lastStackTrace.length != currentStackTrace.length || !Arrays.equals(lastStackTrace, currentStackTrace)) {
            lastStackTraceForThread.set((StackTraceElement[])currentStackTrace);
            lastUniqueStackTraceForThreadNS.set(System.nanoTime());
            lastMarkerForThread.set(counter.getEventCounterMarker());
        } else {
            CompilationAlarm.assertProgressSlowPath(opt, (StackTraceElement[])lastStackTrace, counter, (StackTraceElement[])currentStackTrace);
        }
    }

    private static void assertProgressNoTracking(OptionValues opt, EventCounter counter) {
        lastUniqueStackTraceForThreadNS.set(System.nanoTime());
        lastMarkerForThread.set(counter.getEventCounterMarker());
        noProgressStartPeriodNS.set(CompilationAlarm.periodNanoSeconds(Options.CompilationNoProgressStartTrackingProgressPeriod.getValue(opt)));
        if (LOG_PROGRESS_DETECTION) {
            TTY.printf("CompilationAlarm: Progress detection %s; taking first time stamp, no stack yet%n", counter.eventCounterToString());
        }
    }

    private static void assertProgressSlowPath(OptionValues opt, StackTraceElement[] lastStackTrace, EventCounter counter, StackTraceElement[] currentStackTrace) {
        boolean stuck;
        long stuckThreshold = CompilationAlarm.periodNanoSeconds(Options.CompilationNoProgressPeriod.getValue(opt));
        if (stuckThreshold == 0L) {
            return;
        }
        assert (Arrays.equals(lastStackTrace, currentStackTrace)) : "Must only enter this branch if no progress was made";
        long lastUniqueStackTraceTime = lastUniqueStackTraceForThreadNS.get();
        long nowNS = System.nanoTime();
        long elapsedNS = nowNS - lastUniqueStackTraceTime;
        boolean bl = stuck = elapsedNS > stuckThreshold;
        if (LOG_PROGRESS_DETECTION) {
            TTY.printf("CompilationAlarm: Progress detection %s; no progress for %d ms; stuck? %s; stuck threshold %d ms%n", counter, TimeUnit.NANOSECONDS.toMillis(elapsedNS), stuck, stuckThreshold);
        }
        if (stuck) {
            throw new PermanentBailoutException("Observed identical stack traces for %d ms, indicating a stuck compilation, counter = %s, stack is:%n%s", TimeUnit.NANOSECONDS.toMillis(elapsedNS), counter, Util.toString(lastStackTrace));
        }
    }

    public static void resetProgressDetection() {
        lastStackTraceForThread.set(null);
        lastUniqueStackTraceForThreadNS.set(null);
        lastMarkerForThread.set(null);
        noProgressStartPeriodNS.set(null);
    }

    private class PhaseTreeNode {
        private PhaseTreeNode parent;
        private PhaseTreeNode[] children;
        private int childIndex = 0;
        private final String name;
        private long startTimeNS = -1L;
        private long durationNS = 0L;
        public boolean closed;

        PhaseTreeNode(CompilationAlarm compilationAlarm, String name) {
            this.name = name;
        }

        private void addChild(PhaseTreeNode child) {
            if (this.children == null) {
                this.children = new PhaseTreeNode[2];
                this.children[this.childIndex++] = child;
                return;
            }
            if (this.childIndex >= this.children.length) {
                this.children = Arrays.copyOf(this.children, this.children.length * 2);
            }
            this.children[this.childIndex++] = child;
        }

        public String toString() {
            return this.name + "->" + TimeUnit.NANOSECONDS.toMillis(this.durationNS) + "ms elapsed [startMS=" + TimeUnit.NANOSECONDS.toMillis(this.startTimeNS) + "]";
        }
    }

    public static class Options {
        public static final OptionKey<Double> CompilationExpirationPeriod = new OptionKey<Double>(300.0);
        public static final OptionKey<Double> CompilationNoProgressPeriod = new OptionKey<Double>(30.0);
        public static final OptionKey<Double> CompilationNoProgressStartTrackingProgressPeriod = new OptionKey<Double>(10.0);
    }
}

